/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.graph.clz.ApplicationClz;
import org.jboss.windup.graph.clz.GraphableClz;
import org.jboss.windup.graph.clz.UnknownClz;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.CustomerPackageResolver;
import org.jboss.windup.util.ProfileResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassesProvidedDecorator
implements MetaDecorator<ZipMetadata> {
    public static String MISSING_DEPENDENCIES_TO_APPLICATION_CLASSES = "MISSING_DEPENDENCIES_TO_APPLICATION_CLASSES";
    public static String PROVIDED_CLASS_LOCATIONS = "PROVIDED_CLASS_LOCATIONS";
    private static final Logger LOG = LoggerFactory.getLogger(ClassesProvidedDecorator.class);
    private CustomerPackageResolver customerPackageResolver;
    private ProfileResolver profileResolver;

    public void setProfileResolver(ProfileResolver profileResolver) {
        this.profileResolver = profileResolver;
    }

    public void setCustomerPackageResolver(CustomerPackageResolver customerPackageResolver) {
        this.customerPackageResolver = customerPackageResolver;
    }

    @Override
    public void processMeta(ZipMetadata meta) {
    }

    protected void findProblem(GraphableClz source, GraphableClz g, Integer i, Set<GraphableClz> transversed, Map<String, Set<String>> missingToAffected) {
        if (!transversed.contains(g)) {
            transversed.add(g);
            if (g instanceof ApplicationClz) {
                for (GraphableClz p : ((ApplicationClz)g).getDependsOn()) {
                    this.findProblem(source, p, new Integer(i + 1), transversed, missingToAffected);
                }
            } else if (g instanceof UnknownClz) {
                if (!missingToAffected.containsKey(g.getClassName())) {
                    missingToAffected.put(g.getClassName(), new TreeSet());
                }
                missingToAffected.get(g.getClassName()).add(source.getClassName());
            }
        }
    }

    protected String extractClassName(String entryName) {
        String className = StringUtils.replace((String)entryName, (String)"\\", (String)"/");
        className = StringUtils.removeStart((String)className, (String)"/");
        className = StringUtils.replace((String)className, (String)"/", (String)".");
        className = StringUtils.removeEnd((String)className, (String)".class");
        if (StringUtils.contains((String)(className = StringUtils.removeEnd((String)className, (String)".java")), (String)"WEB-INF.classes.")) {
            className = StringUtils.substringAfter((String)className, (String)"WEB-INF.classes.");
        }
        return className;
    }

    protected void recursivelyCollectRequiredProvided(ZipMetadata meta, Map<String, GraphableClz> provided) {
        try {
            Enumeration<? extends ZipEntry> e = meta.getZipFile().entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!StringUtils.endsWith((String)entry.getName(), (String)".class")) continue;
                String className = this.extractClassName(entry.getName());
                Set<String> required = this.extractImports(meta.getZipFile(), entry);
                ApplicationClz cg = new ApplicationClz((ArchiveMetadata)meta, className, required);
                provided.put(className, (GraphableClz)cg);
            }
        }
        catch (Exception e) {
            LOG.error("Exception getting JDK version.", (Throwable)e);
        }
        for (ArchiveMetadata child : meta.getNestedArchives()) {
            ZipMetadata cast = (ZipMetadata)child;
            this.recursivelyCollectRequiredProvided(cast, provided);
        }
    }

    protected Set<String> extractImports(ZipFile zipFile, ZipEntry entry) {
        try {
            CtClass ctClz = new ClassPool().makeClass(zipFile.getInputStream(entry));
            if (LOG.isDebugEnabled()) {
                for (String clz : ctClz.getClassFile2().getInterfaces()) {
                    LOG.debug("Interfaces: " + clz);
                }
                LOG.debug("Super Class: " + ctClz.getClassFile2().getSuperclass());
            }
            HashSet<String> clzImports = new HashSet<String>(ClassesProvidedDecorator.castList(String.class, ctClz.getRefClasses()));
            return clzImports;
        }
        catch (Exception e) {
            LOG.error("Extract imports error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> castList(Class<? extends T> aclass, Collection<?> c) {
        ArrayList<T> r = new ArrayList<T>(c.size());
        for (Object o : c) {
            r.add(aclass.cast(o));
        }
        return r;
    }
}

