/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.util.ReflectionUtils;

public abstract class ClassUtils {
    public static final Method FUNCTION_APPLY_METHOD = ReflectionUtils.findMethod(Function.class, (String)"apply", (Class[])null);
    public static final Method SELECTOR_ACCEPT_METHOD;
    public static final Method TRANSFORMER_TRANSFORM_METHOD;
    public static final Method HANDLER_HANDLE_METHOD;
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap;

    public static Class<?> findClosestMatch(Class<?> type, Set<Class<?>> candidates, boolean failOnTie) {
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Class<?> closestMatch = null;
        for (Class<?> candidate : candidates) {
            int typeDiffWeight = ClassUtils.getTypeDifferenceWeight(candidate, type);
            if (typeDiffWeight < minTypeDiffWeight) {
                minTypeDiffWeight = typeDiffWeight;
                closestMatch = candidate;
                continue;
            }
            if (!failOnTie || typeDiffWeight >= Integer.MAX_VALUE || typeDiffWeight != minTypeDiffWeight) continue;
            throw new IllegalStateException("Unresolvable ambiguity while attempting to find closest match for [" + type.getName() + "]. Candidate types [" + closestMatch.getName() + "] and [" + candidate.getName() + "] have equal weight.");
        }
        return closestMatch;
    }

    private static int getTypeDifferenceWeight(Class<?> candidate, Class<?> type) {
        int result = 0;
        if (!org.springframework.util.ClassUtils.isAssignable(candidate, type)) {
            return Integer.MAX_VALUE;
        }
        Class<?> superClass = type.getSuperclass();
        while (superClass != null) {
            if (type.equals(superClass)) {
                result += 2;
                superClass = null;
                continue;
            }
            if (org.springframework.util.ClassUtils.isAssignable(candidate, superClass)) {
                result += 2;
                superClass = superClass.getSuperclass();
                continue;
            }
            superClass = null;
        }
        if (candidate.isInterface()) {
            ++result;
        }
        return result;
    }

    public static Class<?> resolvePrimitiveType(Class<?> clazz) {
        return primitiveWrapperTypeMap.get(clazz);
    }

    static {
        Class genericSelectorClass = null;
        try {
            genericSelectorClass = org.springframework.util.ClassUtils.forName((String)"org.springframework.integration.core.GenericSelector", (ClassLoader)org.springframework.util.ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        SELECTOR_ACCEPT_METHOD = ReflectionUtils.findMethod((Class)genericSelectorClass, (String)"accept", (Class[])null);
        Class genericTransformerClass = null;
        try {
            genericTransformerClass = org.springframework.util.ClassUtils.forName((String)"org.springframework.integration.transformer.GenericTransformer", (ClassLoader)org.springframework.util.ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        TRANSFORMER_TRANSFORM_METHOD = ReflectionUtils.findMethod((Class)genericTransformerClass, (String)"transform", (Class[])null);
        Class genericHandlerClass = null;
        try {
            genericHandlerClass = org.springframework.util.ClassUtils.forName((String)"org.springframework.integration.handler.GenericHandler", (ClassLoader)org.springframework.util.ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        HANDLER_HANDLE_METHOD = ReflectionUtils.findMethod((Class)genericHandlerClass, (String)"handle", (Class[])null);
        primitiveWrapperTypeMap = new HashMap(8);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
    }
}

