// Code generated by github.com/swaggest/json-cli v1.11.1, DO NOT EDIT.

// Package openapi31 contains JSON mapping structures.
package openapi31

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"regexp"
	"strings"
)

// Spec structure is generated from "#".
//
// The description of OpenAPI v3.1.x documents without schema validation, as defined by https://spec.openapis.org/oas/v3.1.0.
type Spec struct {
	// Value must match pattern: `^3\.1\.\d+(-.+)?$`.
	// Required.
	Openapi           string                         `json:"openapi"`
	Info              Info                           `json:"info"`                        // Required.
	JSONSchemaDialect *string                        `json:"jsonSchemaDialect,omitempty"` // Format: uri.
	Servers           []Server                       `json:"servers,omitempty"`
	Paths             *Paths                         `json:"paths,omitempty"`
	Webhooks          map[string]PathItemOrReference `json:"webhooks,omitempty"`
	Components        *Components                    `json:"components,omitempty"`
	Security          []map[string][]string          `json:"security,omitempty"`
	Tags              []Tag                          `json:"tags,omitempty"`
	ExternalDocs      *ExternalDocumentation         `json:"externalDocs,omitempty"`
	MapOfAnything     map[string]interface{}         `json:"-"` // Key must match pattern: `^x-`.
}

// WithOpenapi sets Openapi value.
func (s *Spec) WithOpenapi(val string) *Spec {
	s.Openapi = val
	return s
}

// WithInfo sets Info value.
func (s *Spec) WithInfo(val Info) *Spec {
	s.Info = val
	return s
}

// WithJSONSchemaDialect sets JSONSchemaDialect value.
func (s *Spec) WithJSONSchemaDialect(val string) *Spec {
	s.JSONSchemaDialect = &val
	return s
}

// WithServers sets Servers value.
func (s *Spec) WithServers(val ...Server) *Spec {
	s.Servers = val
	return s
}

// WithPaths sets Paths value.
func (s *Spec) WithPaths(val Paths) *Spec {
	s.Paths = &val
	return s
}

// PathsEns ensures returned Paths is not nil.
func (s *Spec) PathsEns() *Paths {
	if s.Paths == nil {
		s.Paths = new(Paths)
	}

	return s.Paths
}

// WithWebhooks sets Webhooks value.
func (s *Spec) WithWebhooks(val map[string]PathItemOrReference) *Spec {
	s.Webhooks = val
	return s
}

// WithWebhooksItem sets Webhooks item value.
func (s *Spec) WithWebhooksItem(key string, val PathItemOrReference) *Spec {
	if s.Webhooks == nil {
		s.Webhooks = make(map[string]PathItemOrReference, 1)
	}

	s.Webhooks[key] = val

	return s
}

// WithComponents sets Components value.
func (s *Spec) WithComponents(val Components) *Spec {
	s.Components = &val
	return s
}

// ComponentsEns ensures returned Components is not nil.
func (s *Spec) ComponentsEns() *Components {
	if s.Components == nil {
		s.Components = new(Components)
	}

	return s.Components
}

// WithSecurity sets Security value.
func (s *Spec) WithSecurity(val ...map[string][]string) *Spec {
	s.Security = val
	return s
}

// WithTags sets Tags value.
func (s *Spec) WithTags(val ...Tag) *Spec {
	s.Tags = val
	return s
}

// WithExternalDocs sets ExternalDocs value.
func (s *Spec) WithExternalDocs(val ExternalDocumentation) *Spec {
	s.ExternalDocs = &val
	return s
}

// ExternalDocsEns ensures returned ExternalDocs is not nil.
func (s *Spec) ExternalDocsEns() *ExternalDocumentation {
	if s.ExternalDocs == nil {
		s.ExternalDocs = new(ExternalDocumentation)
	}

	return s.ExternalDocs
}

// WithMapOfAnything sets MapOfAnything value.
func (s *Spec) WithMapOfAnything(val map[string]interface{}) *Spec {
	s.MapOfAnything = val
	return s
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (s *Spec) WithMapOfAnythingItem(key string, val interface{}) *Spec {
	if s.MapOfAnything == nil {
		s.MapOfAnything = make(map[string]interface{}, 1)
	}

	s.MapOfAnything[key] = val

	return s
}

type marshalSpec Spec

var knownKeysSpec = []string{
	"openapi",
	"info",
	"jsonSchemaDialect",
	"servers",
	"paths",
	"webhooks",
	"components",
	"security",
	"tags",
	"externalDocs",
}

var requireKeysSpec = []string{
	"openapi",
	"info",
}

// UnmarshalJSON decodes JSON.
func (s *Spec) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSpec(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSpec {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysSpec {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ms.MapOfAnything == nil {
				ms.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ms.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*s = Spec(ms)

	return nil
}

// MarshalJSON encodes JSON.
func (s Spec) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalSpec(s), s.MapOfAnything)
}

// Info structure is generated from "#/$defs/info".
type Info struct {
	Title          string                 `json:"title"` // Required.
	Summary        *string                `json:"summary,omitempty"`
	Description    *string                `json:"description,omitempty"`
	TermsOfService *string                `json:"termsOfService,omitempty"` // Format: uri.
	Contact        *Contact               `json:"contact,omitempty"`
	License        *License               `json:"license,omitempty"`
	Version        string                 `json:"version"` // Required.
	MapOfAnything  map[string]interface{} `json:"-"`       // Key must match pattern: `^x-`.
}

// WithTitle sets Title value.
func (i *Info) WithTitle(val string) *Info {
	i.Title = val
	return i
}

// WithSummary sets Summary value.
func (i *Info) WithSummary(val string) *Info {
	i.Summary = &val
	return i
}

// WithDescription sets Description value.
func (i *Info) WithDescription(val string) *Info {
	i.Description = &val
	return i
}

// WithTermsOfService sets TermsOfService value.
func (i *Info) WithTermsOfService(val string) *Info {
	i.TermsOfService = &val
	return i
}

// WithContact sets Contact value.
func (i *Info) WithContact(val Contact) *Info {
	i.Contact = &val
	return i
}

// ContactEns ensures returned Contact is not nil.
func (i *Info) ContactEns() *Contact {
	if i.Contact == nil {
		i.Contact = new(Contact)
	}

	return i.Contact
}

// WithLicense sets License value.
func (i *Info) WithLicense(val License) *Info {
	i.License = &val
	return i
}

// LicenseEns ensures returned License is not nil.
func (i *Info) LicenseEns() *License {
	if i.License == nil {
		i.License = new(License)
	}

	return i.License
}

// WithVersion sets Version value.
func (i *Info) WithVersion(val string) *Info {
	i.Version = val
	return i
}

// WithMapOfAnything sets MapOfAnything value.
func (i *Info) WithMapOfAnything(val map[string]interface{}) *Info {
	i.MapOfAnything = val
	return i
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (i *Info) WithMapOfAnythingItem(key string, val interface{}) *Info {
	if i.MapOfAnything == nil {
		i.MapOfAnything = make(map[string]interface{}, 1)
	}

	i.MapOfAnything[key] = val

	return i
}

type marshalInfo Info

var knownKeysInfo = []string{
	"title",
	"summary",
	"description",
	"termsOfService",
	"contact",
	"license",
	"version",
}

var requireKeysInfo = []string{
	"title",
	"version",
}

// UnmarshalJSON decodes JSON.
func (i *Info) UnmarshalJSON(data []byte) error {
	var err error

	mi := marshalInfo(*i)

	err = json.Unmarshal(data, &mi)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysInfo {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysInfo {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mi.MapOfAnything == nil {
				mi.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mi.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*i = Info(mi)

	return nil
}

// MarshalJSON encodes JSON.
func (i Info) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalInfo(i), i.MapOfAnything)
}

// Contact structure is generated from "#/$defs/contact".
type Contact struct {
	Name          *string                `json:"name,omitempty"`
	URL           *string                `json:"url,omitempty"`   // Format: uri.
	Email         *string                `json:"email,omitempty"` // Format: email.
	MapOfAnything map[string]interface{} `json:"-"`               // Key must match pattern: `^x-`.
}

// WithName sets Name value.
func (c *Contact) WithName(val string) *Contact {
	c.Name = &val
	return c
}

// WithURL sets URL value.
func (c *Contact) WithURL(val string) *Contact {
	c.URL = &val
	return c
}

// WithEmail sets Email value.
func (c *Contact) WithEmail(val string) *Contact {
	c.Email = &val
	return c
}

// WithMapOfAnything sets MapOfAnything value.
func (c *Contact) WithMapOfAnything(val map[string]interface{}) *Contact {
	c.MapOfAnything = val
	return c
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (c *Contact) WithMapOfAnythingItem(key string, val interface{}) *Contact {
	if c.MapOfAnything == nil {
		c.MapOfAnything = make(map[string]interface{}, 1)
	}

	c.MapOfAnything[key] = val

	return c
}

type marshalContact Contact

var knownKeysContact = []string{
	"name",
	"url",
	"email",
}

// UnmarshalJSON decodes JSON.
func (c *Contact) UnmarshalJSON(data []byte) error {
	var err error

	mc := marshalContact(*c)

	err = json.Unmarshal(data, &mc)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range knownKeysContact {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mc.MapOfAnything == nil {
				mc.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mc.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*c = Contact(mc)

	return nil
}

// MarshalJSON encodes JSON.
func (c Contact) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalContact(c), c.MapOfAnything)
}

// License structure is generated from "#/$defs/license".
type License struct {
	Name          string                 `json:"name"` // Required.
	Identifier    *string                `json:"identifier,omitempty"`
	URL           *string                `json:"url,omitempty"` // Format: uri.
	MapOfAnything map[string]interface{} `json:"-"`             // Key must match pattern: `^x-`.
}

// WithName sets Name value.
func (l *License) WithName(val string) *License {
	l.Name = val
	return l
}

// WithIdentifier sets Identifier value.
func (l *License) WithIdentifier(val string) *License {
	l.Identifier = &val
	return l
}

// WithURL sets URL value.
func (l *License) WithURL(val string) *License {
	l.URL = &val
	return l
}

// WithMapOfAnything sets MapOfAnything value.
func (l *License) WithMapOfAnything(val map[string]interface{}) *License {
	l.MapOfAnything = val
	return l
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (l *License) WithMapOfAnythingItem(key string, val interface{}) *License {
	if l.MapOfAnything == nil {
		l.MapOfAnything = make(map[string]interface{}, 1)
	}

	l.MapOfAnything[key] = val

	return l
}

type marshalLicense License

var knownKeysLicense = []string{
	"name",
	"identifier",
	"url",
}

var requireKeysLicense = []string{
	"name",
}

// UnmarshalJSON decodes JSON.
func (l *License) UnmarshalJSON(data []byte) error {
	var err error

	ml := marshalLicense(*l)

	err = json.Unmarshal(data, &ml)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysLicense {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysLicense {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ml.MapOfAnything == nil {
				ml.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ml.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*l = License(ml)

	return nil
}

// MarshalJSON encodes JSON.
func (l License) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalLicense(l), l.MapOfAnything)
}

// Server structure is generated from "#/$defs/server".
type Server struct {
	// Format: uri-reference.
	// Required.
	URL           string                    `json:"url"`
	Description   *string                   `json:"description,omitempty"`
	Variables     map[string]ServerVariable `json:"variables,omitempty"`
	MapOfAnything map[string]interface{}    `json:"-"` // Key must match pattern: `^x-`.
}

// WithURL sets URL value.
func (s *Server) WithURL(val string) *Server {
	s.URL = val
	return s
}

// WithDescription sets Description value.
func (s *Server) WithDescription(val string) *Server {
	s.Description = &val
	return s
}

// WithVariables sets Variables value.
func (s *Server) WithVariables(val map[string]ServerVariable) *Server {
	s.Variables = val
	return s
}

// WithVariablesItem sets Variables item value.
func (s *Server) WithVariablesItem(key string, val ServerVariable) *Server {
	if s.Variables == nil {
		s.Variables = make(map[string]ServerVariable, 1)
	}

	s.Variables[key] = val

	return s
}

// WithMapOfAnything sets MapOfAnything value.
func (s *Server) WithMapOfAnything(val map[string]interface{}) *Server {
	s.MapOfAnything = val
	return s
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (s *Server) WithMapOfAnythingItem(key string, val interface{}) *Server {
	if s.MapOfAnything == nil {
		s.MapOfAnything = make(map[string]interface{}, 1)
	}

	s.MapOfAnything[key] = val

	return s
}

type marshalServer Server

var knownKeysServer = []string{
	"url",
	"description",
	"variables",
}

var requireKeysServer = []string{
	"url",
}

// UnmarshalJSON decodes JSON.
func (s *Server) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalServer(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysServer {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysServer {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ms.MapOfAnything == nil {
				ms.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ms.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*s = Server(ms)

	return nil
}

// MarshalJSON encodes JSON.
func (s Server) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalServer(s), s.MapOfAnything)
}

// ServerVariable structure is generated from "#/$defs/server-variable".
type ServerVariable struct {
	Enum          []string               `json:"enum,omitempty"`
	Default       string                 `json:"default"` // Required.
	Description   *string                `json:"description,omitempty"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithEnum sets Enum value.
func (s *ServerVariable) WithEnum(val ...string) *ServerVariable {
	s.Enum = val
	return s
}

// WithDefault sets Default value.
func (s *ServerVariable) WithDefault(val string) *ServerVariable {
	s.Default = val
	return s
}

// WithDescription sets Description value.
func (s *ServerVariable) WithDescription(val string) *ServerVariable {
	s.Description = &val
	return s
}

// WithMapOfAnything sets MapOfAnything value.
func (s *ServerVariable) WithMapOfAnything(val map[string]interface{}) *ServerVariable {
	s.MapOfAnything = val
	return s
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (s *ServerVariable) WithMapOfAnythingItem(key string, val interface{}) *ServerVariable {
	if s.MapOfAnything == nil {
		s.MapOfAnything = make(map[string]interface{}, 1)
	}

	s.MapOfAnything[key] = val

	return s
}

type marshalServerVariable ServerVariable

var knownKeysServerVariable = []string{
	"enum",
	"default",
	"description",
}

var requireKeysServerVariable = []string{
	"default",
}

// UnmarshalJSON decodes JSON.
func (s *ServerVariable) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalServerVariable(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysServerVariable {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysServerVariable {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ms.MapOfAnything == nil {
				ms.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ms.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*s = ServerVariable(ms)

	return nil
}

// MarshalJSON encodes JSON.
func (s ServerVariable) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalServerVariable(s), s.MapOfAnything)
}

// PathItem structure is generated from "#/$defs/path-item".
type PathItem struct {
	Summary       *string                `json:"summary,omitempty"`
	Description   *string                `json:"description,omitempty"`
	Servers       []Server               `json:"servers,omitempty"`
	Parameters    []ParameterOrReference `json:"parameters,omitempty"`
	Get           *Operation             `json:"get,omitempty"`
	Put           *Operation             `json:"put,omitempty"`
	Post          *Operation             `json:"post,omitempty"`
	Delete        *Operation             `json:"delete,omitempty"`
	Options       *Operation             `json:"options,omitempty"`
	Head          *Operation             `json:"head,omitempty"`
	Patch         *Operation             `json:"patch,omitempty"`
	Trace         *Operation             `json:"trace,omitempty"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithSummary sets Summary value.
func (p *PathItem) WithSummary(val string) *PathItem {
	p.Summary = &val
	return p
}

// WithDescription sets Description value.
func (p *PathItem) WithDescription(val string) *PathItem {
	p.Description = &val
	return p
}

// WithServers sets Servers value.
func (p *PathItem) WithServers(val ...Server) *PathItem {
	p.Servers = val
	return p
}

// WithParameters sets Parameters value.
func (p *PathItem) WithParameters(val ...ParameterOrReference) *PathItem {
	p.Parameters = val
	return p
}

// WithGet sets Get value.
func (p *PathItem) WithGet(val Operation) *PathItem {
	p.Get = &val
	return p
}

// GetEns ensures returned Get is not nil.
func (p *PathItem) GetEns() *Operation {
	if p.Get == nil {
		p.Get = new(Operation)
	}

	return p.Get
}

// WithPut sets Put value.
func (p *PathItem) WithPut(val Operation) *PathItem {
	p.Put = &val
	return p
}

// PutEns ensures returned Put is not nil.
func (p *PathItem) PutEns() *Operation {
	if p.Put == nil {
		p.Put = new(Operation)
	}

	return p.Put
}

// WithPost sets Post value.
func (p *PathItem) WithPost(val Operation) *PathItem {
	p.Post = &val
	return p
}

// PostEns ensures returned Post is not nil.
func (p *PathItem) PostEns() *Operation {
	if p.Post == nil {
		p.Post = new(Operation)
	}

	return p.Post
}

// WithDelete sets Delete value.
func (p *PathItem) WithDelete(val Operation) *PathItem {
	p.Delete = &val
	return p
}

// DeleteEns ensures returned Delete is not nil.
func (p *PathItem) DeleteEns() *Operation {
	if p.Delete == nil {
		p.Delete = new(Operation)
	}

	return p.Delete
}

// WithOptions sets Options value.
func (p *PathItem) WithOptions(val Operation) *PathItem {
	p.Options = &val
	return p
}

// OptionsEns ensures returned Options is not nil.
func (p *PathItem) OptionsEns() *Operation {
	if p.Options == nil {
		p.Options = new(Operation)
	}

	return p.Options
}

// WithHead sets Head value.
func (p *PathItem) WithHead(val Operation) *PathItem {
	p.Head = &val
	return p
}

// HeadEns ensures returned Head is not nil.
func (p *PathItem) HeadEns() *Operation {
	if p.Head == nil {
		p.Head = new(Operation)
	}

	return p.Head
}

// WithPatch sets Patch value.
func (p *PathItem) WithPatch(val Operation) *PathItem {
	p.Patch = &val
	return p
}

// PatchEns ensures returned Patch is not nil.
func (p *PathItem) PatchEns() *Operation {
	if p.Patch == nil {
		p.Patch = new(Operation)
	}

	return p.Patch
}

// WithTrace sets Trace value.
func (p *PathItem) WithTrace(val Operation) *PathItem {
	p.Trace = &val
	return p
}

// TraceEns ensures returned Trace is not nil.
func (p *PathItem) TraceEns() *Operation {
	if p.Trace == nil {
		p.Trace = new(Operation)
	}

	return p.Trace
}

// WithMapOfAnything sets MapOfAnything value.
func (p *PathItem) WithMapOfAnything(val map[string]interface{}) *PathItem {
	p.MapOfAnything = val
	return p
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (p *PathItem) WithMapOfAnythingItem(key string, val interface{}) *PathItem {
	if p.MapOfAnything == nil {
		p.MapOfAnything = make(map[string]interface{}, 1)
	}

	p.MapOfAnything[key] = val

	return p
}

type marshalPathItem PathItem

var knownKeysPathItem = []string{
	"summary",
	"description",
	"servers",
	"parameters",
	"get",
	"put",
	"post",
	"delete",
	"options",
	"head",
	"patch",
	"trace",
}

// UnmarshalJSON decodes JSON.
func (p *PathItem) UnmarshalJSON(data []byte) error {
	var err error

	mp := marshalPathItem(*p)

	err = json.Unmarshal(data, &mp)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range knownKeysPathItem {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mp.MapOfAnything == nil {
				mp.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mp.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*p = PathItem(mp)

	return nil
}

// MarshalJSON encodes JSON.
func (p PathItem) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalPathItem(p), p.MapOfAnything)
}

// Reference structure is generated from "#/$defs/reference".
type Reference struct {
	// Format: uri-reference.
	// Required.
	Ref         string  `json:"$ref"`
	Summary     *string `json:"summary,omitempty"`
	Description *string `json:"description,omitempty"`
}

// WithRef sets Ref value.
func (r *Reference) WithRef(val string) *Reference {
	r.Ref = val
	return r
}

// WithSummary sets Summary value.
func (r *Reference) WithSummary(val string) *Reference {
	r.Summary = &val
	return r
}

// WithDescription sets Description value.
func (r *Reference) WithDescription(val string) *Reference {
	r.Description = &val
	return r
}

type marshalReference Reference

var requireKeysReference = []string{
	"$ref",
}

// UnmarshalJSON decodes JSON.
func (r *Reference) UnmarshalJSON(data []byte) error {
	var err error

	mr := marshalReference(*r)

	err = json.Unmarshal(data, &mr)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysReference {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	*r = Reference(mr)

	return nil
}

// Parameter structure is generated from "#/$defs/parameter".
type Parameter struct {
	Name          string                        `json:"name"` // Required.
	In            ParameterIn                   `json:"in"`   // Required.
	Description   *string                       `json:"description,omitempty"`
	Required      *bool                         `json:"required,omitempty"`
	Deprecated    *bool                         `json:"deprecated,omitempty"`
	Schema        map[string]interface{}        `json:"schema,omitempty"`
	Content       map[string]MediaType          `json:"content,omitempty"`
	Style         *ParameterStyle               `json:"style,omitempty"`
	Explode       *bool                         `json:"explode,omitempty"`
	Example       *interface{}                  `json:"example,omitempty"`
	Examples      map[string]ExampleOrReference `json:"examples,omitempty"`
	MapOfAnything map[string]interface{}        `json:"-"` // Key must match pattern: `^x-`.
}

// WithName sets Name value.
func (p *Parameter) WithName(val string) *Parameter {
	p.Name = val
	return p
}

// WithIn sets In value.
func (p *Parameter) WithIn(val ParameterIn) *Parameter {
	p.In = val
	return p
}

// WithDescription sets Description value.
func (p *Parameter) WithDescription(val string) *Parameter {
	p.Description = &val
	return p
}

// WithRequired sets Required value.
func (p *Parameter) WithRequired(val bool) *Parameter {
	p.Required = &val
	return p
}

// WithDeprecated sets Deprecated value.
func (p *Parameter) WithDeprecated(val bool) *Parameter {
	p.Deprecated = &val
	return p
}

// WithSchema sets Schema value.
func (p *Parameter) WithSchema(val map[string]interface{}) *Parameter {
	p.Schema = val
	return p
}

// WithSchemaItem sets Schema item value.
func (p *Parameter) WithSchemaItem(key string, val interface{}) *Parameter {
	if p.Schema == nil {
		p.Schema = make(map[string]interface{}, 1)
	}

	p.Schema[key] = val

	return p
}

// WithContent sets Content value.
func (p *Parameter) WithContent(val map[string]MediaType) *Parameter {
	p.Content = val
	return p
}

// WithContentItem sets Content item value.
func (p *Parameter) WithContentItem(key string, val MediaType) *Parameter {
	if p.Content == nil {
		p.Content = make(map[string]MediaType, 1)
	}

	p.Content[key] = val

	return p
}

// WithStyle sets Style value.
func (p *Parameter) WithStyle(val ParameterStyle) *Parameter {
	p.Style = &val
	return p
}

// WithExplode sets Explode value.
func (p *Parameter) WithExplode(val bool) *Parameter {
	p.Explode = &val
	return p
}

// WithExample sets Example value.
func (p *Parameter) WithExample(val interface{}) *Parameter {
	p.Example = &val
	return p
}

// WithExamples sets Examples value.
func (p *Parameter) WithExamples(val map[string]ExampleOrReference) *Parameter {
	p.Examples = val
	return p
}

// WithExamplesItem sets Examples item value.
func (p *Parameter) WithExamplesItem(key string, val ExampleOrReference) *Parameter {
	if p.Examples == nil {
		p.Examples = make(map[string]ExampleOrReference, 1)
	}

	p.Examples[key] = val

	return p
}

// WithMapOfAnything sets MapOfAnything value.
func (p *Parameter) WithMapOfAnything(val map[string]interface{}) *Parameter {
	p.MapOfAnything = val
	return p
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (p *Parameter) WithMapOfAnythingItem(key string, val interface{}) *Parameter {
	if p.MapOfAnything == nil {
		p.MapOfAnything = make(map[string]interface{}, 1)
	}

	p.MapOfAnything[key] = val

	return p
}

type marshalParameter Parameter

var knownKeysParameter = []string{
	"name",
	"in",
	"description",
	"required",
	"deprecated",
	"schema",
	"content",
	"style",
	"explode",
	"example",
	"examples",
}

var requireKeysParameter = []string{
	"name",
	"in",
}

// UnmarshalJSON decodes JSON.
func (p *Parameter) UnmarshalJSON(data []byte) error {
	var err error

	mp := marshalParameter(*p)

	err = json.Unmarshal(data, &mp)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysParameter {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if mp.Example == nil {
		if _, ok := rawMap["example"]; ok {
			var v interface{}
			mp.Example = &v
		}
	}

	for _, key := range knownKeysParameter {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mp.MapOfAnything == nil {
				mp.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mp.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*p = Parameter(mp)

	return nil
}

// MarshalJSON encodes JSON.
func (p Parameter) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalParameter(p), p.MapOfAnything)
}

// MediaType structure is generated from "#/$defs/media-type".
type MediaType struct {
	Schema        map[string]interface{}        `json:"schema,omitempty"`
	Encoding      map[string]Encoding           `json:"encoding,omitempty"`
	Example       *interface{}                  `json:"example,omitempty"`
	Examples      map[string]ExampleOrReference `json:"examples,omitempty"`
	MapOfAnything map[string]interface{}        `json:"-"` // Key must match pattern: `^x-`.
}

// WithSchema sets Schema value.
func (m *MediaType) WithSchema(val map[string]interface{}) *MediaType {
	m.Schema = val
	return m
}

// WithSchemaItem sets Schema item value.
func (m *MediaType) WithSchemaItem(key string, val interface{}) *MediaType {
	if m.Schema == nil {
		m.Schema = make(map[string]interface{}, 1)
	}

	m.Schema[key] = val

	return m
}

// WithEncoding sets Encoding value.
func (m *MediaType) WithEncoding(val map[string]Encoding) *MediaType {
	m.Encoding = val
	return m
}

// WithEncodingItem sets Encoding item value.
func (m *MediaType) WithEncodingItem(key string, val Encoding) *MediaType {
	if m.Encoding == nil {
		m.Encoding = make(map[string]Encoding, 1)
	}

	m.Encoding[key] = val

	return m
}

// WithExample sets Example value.
func (m *MediaType) WithExample(val interface{}) *MediaType {
	m.Example = &val
	return m
}

// WithExamples sets Examples value.
func (m *MediaType) WithExamples(val map[string]ExampleOrReference) *MediaType {
	m.Examples = val
	return m
}

// WithExamplesItem sets Examples item value.
func (m *MediaType) WithExamplesItem(key string, val ExampleOrReference) *MediaType {
	if m.Examples == nil {
		m.Examples = make(map[string]ExampleOrReference, 1)
	}

	m.Examples[key] = val

	return m
}

// WithMapOfAnything sets MapOfAnything value.
func (m *MediaType) WithMapOfAnything(val map[string]interface{}) *MediaType {
	m.MapOfAnything = val
	return m
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (m *MediaType) WithMapOfAnythingItem(key string, val interface{}) *MediaType {
	if m.MapOfAnything == nil {
		m.MapOfAnything = make(map[string]interface{}, 1)
	}

	m.MapOfAnything[key] = val

	return m
}

type marshalMediaType MediaType

var knownKeysMediaType = []string{
	"schema",
	"encoding",
	"example",
	"examples",
}

// UnmarshalJSON decodes JSON.
func (m *MediaType) UnmarshalJSON(data []byte) error {
	var err error

	mm := marshalMediaType(*m)

	err = json.Unmarshal(data, &mm)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	if mm.Example == nil {
		if _, ok := rawMap["example"]; ok {
			var v interface{}
			mm.Example = &v
		}
	}

	for _, key := range knownKeysMediaType {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mm.MapOfAnything == nil {
				mm.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mm.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*m = MediaType(mm)

	return nil
}

// MarshalJSON encodes JSON.
func (m MediaType) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalMediaType(m), m.MapOfAnything)
}

// Encoding structure is generated from "#/$defs/encoding".
type Encoding struct {
	ContentType   *string                      `json:"contentType,omitempty"` // Format: media-range.
	Headers       map[string]HeaderOrReference `json:"headers,omitempty"`
	Style         *EncodingStyle               `json:"style,omitempty"`
	Explode       *bool                        `json:"explode,omitempty"`
	AllowReserved *bool                        `json:"allowReserved,omitempty"`
}

// WithContentType sets ContentType value.
func (e *Encoding) WithContentType(val string) *Encoding {
	e.ContentType = &val
	return e
}

// WithHeaders sets Headers value.
func (e *Encoding) WithHeaders(val map[string]HeaderOrReference) *Encoding {
	e.Headers = val
	return e
}

// WithHeadersItem sets Headers item value.
func (e *Encoding) WithHeadersItem(key string, val HeaderOrReference) *Encoding {
	if e.Headers == nil {
		e.Headers = make(map[string]HeaderOrReference, 1)
	}

	e.Headers[key] = val

	return e
}

// WithStyle sets Style value.
func (e *Encoding) WithStyle(val EncodingStyle) *Encoding {
	e.Style = &val
	return e
}

// WithExplode sets Explode value.
func (e *Encoding) WithExplode(val bool) *Encoding {
	e.Explode = &val
	return e
}

// WithAllowReserved sets AllowReserved value.
func (e *Encoding) WithAllowReserved(val bool) *Encoding {
	e.AllowReserved = &val
	return e
}

// Header structure is generated from "#/$defs/header".
type Header struct {
	Description   *string                       `json:"description,omitempty"`
	Required      *bool                         `json:"required,omitempty"`
	Deprecated    *bool                         `json:"deprecated,omitempty"`
	Schema        map[string]interface{}        `json:"schema,omitempty"`
	Content       map[string]MediaType          `json:"content,omitempty"`
	Example       *interface{}                  `json:"example,omitempty"`
	Examples      map[string]ExampleOrReference `json:"examples,omitempty"`
	Explode       *bool                         `json:"explode,omitempty"`
	MapOfAnything map[string]interface{}        `json:"-"` // Key must match pattern: `^x-`.
}

// WithDescription sets Description value.
func (h *Header) WithDescription(val string) *Header {
	h.Description = &val
	return h
}

// WithRequired sets Required value.
func (h *Header) WithRequired(val bool) *Header {
	h.Required = &val
	return h
}

// WithDeprecated sets Deprecated value.
func (h *Header) WithDeprecated(val bool) *Header {
	h.Deprecated = &val
	return h
}

// WithSchema sets Schema value.
func (h *Header) WithSchema(val map[string]interface{}) *Header {
	h.Schema = val
	return h
}

// WithSchemaItem sets Schema item value.
func (h *Header) WithSchemaItem(key string, val interface{}) *Header {
	if h.Schema == nil {
		h.Schema = make(map[string]interface{}, 1)
	}

	h.Schema[key] = val

	return h
}

// WithContent sets Content value.
func (h *Header) WithContent(val map[string]MediaType) *Header {
	h.Content = val
	return h
}

// WithContentItem sets Content item value.
func (h *Header) WithContentItem(key string, val MediaType) *Header {
	if h.Content == nil {
		h.Content = make(map[string]MediaType, 1)
	}

	h.Content[key] = val

	return h
}

// WithExample sets Example value.
func (h *Header) WithExample(val interface{}) *Header {
	h.Example = &val
	return h
}

// WithExamples sets Examples value.
func (h *Header) WithExamples(val map[string]ExampleOrReference) *Header {
	h.Examples = val
	return h
}

// WithExamplesItem sets Examples item value.
func (h *Header) WithExamplesItem(key string, val ExampleOrReference) *Header {
	if h.Examples == nil {
		h.Examples = make(map[string]ExampleOrReference, 1)
	}

	h.Examples[key] = val

	return h
}

// WithExplode sets Explode value.
func (h *Header) WithExplode(val bool) *Header {
	h.Explode = &val
	return h
}

// WithMapOfAnything sets MapOfAnything value.
func (h *Header) WithMapOfAnything(val map[string]interface{}) *Header {
	h.MapOfAnything = val
	return h
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (h *Header) WithMapOfAnythingItem(key string, val interface{}) *Header {
	if h.MapOfAnything == nil {
		h.MapOfAnything = make(map[string]interface{}, 1)
	}

	h.MapOfAnything[key] = val

	return h
}

type marshalHeader Header

var knownKeysHeader = []string{
	"description",
	"required",
	"deprecated",
	"schema",
	"content",
	"example",
	"examples",
	"explode",
	"style",
}

// UnmarshalJSON decodes JSON.
func (h *Header) UnmarshalJSON(data []byte) error {
	var err error

	mh := marshalHeader(*h)

	err = json.Unmarshal(data, &mh)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	_, schemaExists := rawMap["schema"]
	_, contentExists := rawMap["content"]
	if schemaExists && contentExists {
		return fmt.Errorf("both schema and content are set, only one of them is allowed")
	} else if !schemaExists && !contentExists {
		return fmt.Errorf("schema or content are expected")
	}

	if v, exists := rawMap["style"]; exists && string(v) != `"simple"` {
		return fmt.Errorf(`bad const value for "style" ("simple" expected, %s received)`, v)
	}

	delete(rawMap, "style")

	if mh.Example == nil {
		if _, ok := rawMap["example"]; ok {
			var v interface{}
			mh.Example = &v
		}
	}

	for _, key := range knownKeysHeader {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mh.MapOfAnything == nil {
				mh.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mh.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*h = Header(mh)

	return nil
}

// constHeader is unconditionally added to JSON.
var constHeader = json.RawMessage(`{"style":"simple"}`)

// MarshalJSON encodes JSON.
func (h Header) MarshalJSON() ([]byte, error) {
	return marshalUnion(constHeader, marshalHeader(h), h.MapOfAnything)
}

// Example structure is generated from "#/$defs/example".
type Example struct {
	Summary       *string                `json:"summary,omitempty"`
	Description   *string                `json:"description,omitempty"`
	Value         *interface{}           `json:"value,omitempty"`
	ExternalValue *string                `json:"externalValue,omitempty"` // Format: uri.
	MapOfAnything map[string]interface{} `json:"-"`                       // Key must match pattern: `^x-`.
}

// WithSummary sets Summary value.
func (e *Example) WithSummary(val string) *Example {
	e.Summary = &val
	return e
}

// WithDescription sets Description value.
func (e *Example) WithDescription(val string) *Example {
	e.Description = &val
	return e
}

// WithValue sets Value value.
func (e *Example) WithValue(val interface{}) *Example {
	e.Value = &val
	return e
}

// WithExternalValue sets ExternalValue value.
func (e *Example) WithExternalValue(val string) *Example {
	e.ExternalValue = &val
	return e
}

// WithMapOfAnything sets MapOfAnything value.
func (e *Example) WithMapOfAnything(val map[string]interface{}) *Example {
	e.MapOfAnything = val
	return e
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (e *Example) WithMapOfAnythingItem(key string, val interface{}) *Example {
	if e.MapOfAnything == nil {
		e.MapOfAnything = make(map[string]interface{}, 1)
	}

	e.MapOfAnything[key] = val

	return e
}

type marshalExample Example

var knownKeysExample = []string{
	"summary",
	"description",
	"value",
	"externalValue",
}

// UnmarshalJSON decodes JSON.
func (e *Example) UnmarshalJSON(data []byte) error {
	var err error

	var not interface{}

	if json.Unmarshal(data, &not) == nil {
		return errors.New("not constraint failed for Example")
	}

	me := marshalExample(*e)

	err = json.Unmarshal(data, &me)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	if me.Value == nil {
		if _, ok := rawMap["value"]; ok {
			var v interface{}
			me.Value = &v
		}
	}

	for _, key := range knownKeysExample {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if me.MapOfAnything == nil {
				me.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			me.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*e = Example(me)

	return nil
}

// MarshalJSON encodes JSON.
func (e Example) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalExample(e), e.MapOfAnything)
}

// ExampleOrReference structure is generated from "#/$defs/example-or-reference".
type ExampleOrReference struct {
	Reference *Reference `json:"-"`
	Example   *Example   `json:"-"`
}

// WithReference sets Reference value.
func (e *ExampleOrReference) WithReference(val Reference) *ExampleOrReference {
	e.Reference = &val
	return e
}

// ReferenceEns ensures returned Reference is not nil.
func (e *ExampleOrReference) ReferenceEns() *Reference {
	if e.Reference == nil {
		e.Reference = new(Reference)
	}

	return e.Reference
}

// WithExample sets Example value.
func (e *ExampleOrReference) WithExample(val Example) *ExampleOrReference {
	e.Example = &val
	return e
}

// ExampleEns ensures returned Example is not nil.
func (e *ExampleOrReference) ExampleEns() *Example {
	if e.Example == nil {
		e.Example = new(Example)
	}

	return e.Example
}

// UnmarshalJSON decodes JSON.
func (e *ExampleOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &e.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		e.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &e.Example)
	if err != nil {
		oneOfErrors["Example"] = err
		e.Example = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for ExampleOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (e ExampleOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(e.Reference, e.Example)
}

// HeaderOrReference structure is generated from "#/$defs/header-or-reference".
type HeaderOrReference struct {
	Reference *Reference `json:"-"`
	Header    *Header    `json:"-"`
}

// WithReference sets Reference value.
func (h *HeaderOrReference) WithReference(val Reference) *HeaderOrReference {
	h.Reference = &val
	return h
}

// ReferenceEns ensures returned Reference is not nil.
func (h *HeaderOrReference) ReferenceEns() *Reference {
	if h.Reference == nil {
		h.Reference = new(Reference)
	}

	return h.Reference
}

// WithHeader sets Header value.
func (h *HeaderOrReference) WithHeader(val Header) *HeaderOrReference {
	h.Header = &val
	return h
}

// HeaderEns ensures returned Header is not nil.
func (h *HeaderOrReference) HeaderEns() *Header {
	if h.Header == nil {
		h.Header = new(Header)
	}

	return h.Header
}

// UnmarshalJSON decodes JSON.
func (h *HeaderOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &h.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		h.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &h.Header)
	if err != nil {
		oneOfErrors["Header"] = err
		h.Header = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for HeaderOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (h HeaderOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(h.Reference, h.Header)
}

// EncodingAllOf0 structure is generated from "#/$defs/encoding/allOf/0".
type EncodingAllOf0 struct {
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithMapOfAnything sets MapOfAnything value.
func (e *EncodingAllOf0) WithMapOfAnything(val map[string]interface{}) *EncodingAllOf0 {
	e.MapOfAnything = val
	return e
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (e *EncodingAllOf0) WithMapOfAnythingItem(key string, val interface{}) *EncodingAllOf0 {
	if e.MapOfAnything == nil {
		e.MapOfAnything = make(map[string]interface{}, 1)
	}

	e.MapOfAnything[key] = val

	return e
}

// UnmarshalJSON decodes JSON.
func (e *EncodingAllOf0) UnmarshalJSON(data []byte) error {
	var err error

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if e.MapOfAnything == nil {
				e.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			e.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	return nil
}

// MarshalJSON encodes JSON.
func (e EncodingAllOf0) MarshalJSON() ([]byte, error) {
	return marshalUnion(e.MapOfAnything)
}

// Examples structure is generated from "#/$defs/examples".
type Examples struct {
	Example  *interface{}                  `json:"example,omitempty"`
	Examples map[string]ExampleOrReference `json:"examples,omitempty"`
}

// WithExample sets Example value.
func (e *Examples) WithExample(val interface{}) *Examples {
	e.Example = &val
	return e
}

// WithExamples sets Examples value.
func (e *Examples) WithExamples(val map[string]ExampleOrReference) *Examples {
	e.Examples = val
	return e
}

// WithExamplesItem sets Examples item value.
func (e *Examples) WithExamplesItem(key string, val ExampleOrReference) *Examples {
	if e.Examples == nil {
		e.Examples = make(map[string]ExampleOrReference, 1)
	}

	e.Examples[key] = val

	return e
}

// ParameterOrReference structure is generated from "#/$defs/parameter-or-reference".
type ParameterOrReference struct {
	Reference *Reference `json:"-"`
	Parameter *Parameter `json:"-"`
}

// WithReference sets Reference value.
func (p *ParameterOrReference) WithReference(val Reference) *ParameterOrReference {
	p.Reference = &val
	return p
}

// ReferenceEns ensures returned Reference is not nil.
func (p *ParameterOrReference) ReferenceEns() *Reference {
	if p.Reference == nil {
		p.Reference = new(Reference)
	}

	return p.Reference
}

// WithParameter sets Parameter value.
func (p *ParameterOrReference) WithParameter(val Parameter) *ParameterOrReference {
	p.Parameter = &val
	return p
}

// ParameterEns ensures returned Parameter is not nil.
func (p *ParameterOrReference) ParameterEns() *Parameter {
	if p.Parameter == nil {
		p.Parameter = new(Parameter)
	}

	return p.Parameter
}

// UnmarshalJSON decodes JSON.
func (p *ParameterOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &p.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		p.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &p.Parameter)
	if err != nil {
		oneOfErrors["Parameter"] = err
		p.Parameter = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for ParameterOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (p ParameterOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(p.Reference, p.Parameter)
}

// Operation structure is generated from "#/$defs/operation".
type Operation struct {
	Tags          []string                        `json:"tags,omitempty"`
	Summary       *string                         `json:"summary,omitempty"`
	Description   *string                         `json:"description,omitempty"`
	ExternalDocs  *ExternalDocumentation          `json:"externalDocs,omitempty"`
	ID            *string                         `json:"operationId,omitempty"`
	Parameters    []ParameterOrReference          `json:"parameters,omitempty"`
	RequestBody   *RequestBodyOrReference         `json:"requestBody,omitempty"`
	Responses     *Responses                      `json:"responses,omitempty"`
	Callbacks     map[string]CallbacksOrReference `json:"callbacks,omitempty"`
	Deprecated    *bool                           `json:"deprecated,omitempty"`
	Security      []map[string][]string           `json:"security,omitempty"`
	Servers       []Server                        `json:"servers,omitempty"`
	MapOfAnything map[string]interface{}          `json:"-"` // Key must match pattern: `^x-`.
}

// WithTags sets Tags value.
func (o *Operation) WithTags(val ...string) *Operation {
	o.Tags = val
	return o
}

// WithSummary sets Summary value.
func (o *Operation) WithSummary(val string) *Operation {
	o.Summary = &val
	return o
}

// WithDescription sets Description value.
func (o *Operation) WithDescription(val string) *Operation {
	o.Description = &val
	return o
}

// WithExternalDocs sets ExternalDocs value.
func (o *Operation) WithExternalDocs(val ExternalDocumentation) *Operation {
	o.ExternalDocs = &val
	return o
}

// ExternalDocsEns ensures returned ExternalDocs is not nil.
func (o *Operation) ExternalDocsEns() *ExternalDocumentation {
	if o.ExternalDocs == nil {
		o.ExternalDocs = new(ExternalDocumentation)
	}

	return o.ExternalDocs
}

// WithID sets ID value.
func (o *Operation) WithID(val string) *Operation {
	o.ID = &val
	return o
}

// WithParameters sets Parameters value.
func (o *Operation) WithParameters(val ...ParameterOrReference) *Operation {
	o.Parameters = val
	return o
}

// WithRequestBody sets RequestBody value.
func (o *Operation) WithRequestBody(val RequestBodyOrReference) *Operation {
	o.RequestBody = &val
	return o
}

// RequestBodyEns ensures returned RequestBody is not nil.
func (o *Operation) RequestBodyEns() *RequestBodyOrReference {
	if o.RequestBody == nil {
		o.RequestBody = new(RequestBodyOrReference)
	}

	return o.RequestBody
}

// WithResponses sets Responses value.
func (o *Operation) WithResponses(val Responses) *Operation {
	o.Responses = &val
	return o
}

// ResponsesEns ensures returned Responses is not nil.
func (o *Operation) ResponsesEns() *Responses {
	if o.Responses == nil {
		o.Responses = new(Responses)
	}

	return o.Responses
}

// WithCallbacks sets Callbacks value.
func (o *Operation) WithCallbacks(val map[string]CallbacksOrReference) *Operation {
	o.Callbacks = val
	return o
}

// WithCallbacksItem sets Callbacks item value.
func (o *Operation) WithCallbacksItem(key string, val CallbacksOrReference) *Operation {
	if o.Callbacks == nil {
		o.Callbacks = make(map[string]CallbacksOrReference, 1)
	}

	o.Callbacks[key] = val

	return o
}

// WithDeprecated sets Deprecated value.
func (o *Operation) WithDeprecated(val bool) *Operation {
	o.Deprecated = &val
	return o
}

// WithSecurity sets Security value.
func (o *Operation) WithSecurity(val ...map[string][]string) *Operation {
	o.Security = val
	return o
}

// WithServers sets Servers value.
func (o *Operation) WithServers(val ...Server) *Operation {
	o.Servers = val
	return o
}

// WithMapOfAnything sets MapOfAnything value.
func (o *Operation) WithMapOfAnything(val map[string]interface{}) *Operation {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *Operation) WithMapOfAnythingItem(key string, val interface{}) *Operation {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOperation Operation

var knownKeysOperation = []string{
	"tags",
	"summary",
	"description",
	"externalDocs",
	"operationId",
	"parameters",
	"requestBody",
	"responses",
	"callbacks",
	"deprecated",
	"security",
	"servers",
}

// UnmarshalJSON decodes JSON.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOperation(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range knownKeysOperation {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = Operation(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o Operation) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOperation(o), o.MapOfAnything)
}

// ExternalDocumentation structure is generated from "#/$defs/external-documentation".
type ExternalDocumentation struct {
	Description *string `json:"description,omitempty"`
	// Format: uri.
	// Required.
	URL           string                 `json:"url"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithDescription sets Description value.
func (e *ExternalDocumentation) WithDescription(val string) *ExternalDocumentation {
	e.Description = &val
	return e
}

// WithURL sets URL value.
func (e *ExternalDocumentation) WithURL(val string) *ExternalDocumentation {
	e.URL = val
	return e
}

// WithMapOfAnything sets MapOfAnything value.
func (e *ExternalDocumentation) WithMapOfAnything(val map[string]interface{}) *ExternalDocumentation {
	e.MapOfAnything = val
	return e
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (e *ExternalDocumentation) WithMapOfAnythingItem(key string, val interface{}) *ExternalDocumentation {
	if e.MapOfAnything == nil {
		e.MapOfAnything = make(map[string]interface{}, 1)
	}

	e.MapOfAnything[key] = val

	return e
}

type marshalExternalDocumentation ExternalDocumentation

var knownKeysExternalDocumentation = []string{
	"description",
	"url",
}

var requireKeysExternalDocumentation = []string{
	"url",
}

// UnmarshalJSON decodes JSON.
func (e *ExternalDocumentation) UnmarshalJSON(data []byte) error {
	var err error

	me := marshalExternalDocumentation(*e)

	err = json.Unmarshal(data, &me)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysExternalDocumentation {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysExternalDocumentation {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if me.MapOfAnything == nil {
				me.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			me.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*e = ExternalDocumentation(me)

	return nil
}

// MarshalJSON encodes JSON.
func (e ExternalDocumentation) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalExternalDocumentation(e), e.MapOfAnything)
}

// RequestBody structure is generated from "#/$defs/request-body".
type RequestBody struct {
	Description   *string                `json:"description,omitempty"`
	Content       map[string]MediaType   `json:"content"` // Required.
	Required      *bool                  `json:"required,omitempty"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithDescription sets Description value.
func (r *RequestBody) WithDescription(val string) *RequestBody {
	r.Description = &val
	return r
}

// WithContent sets Content value.
func (r *RequestBody) WithContent(val map[string]MediaType) *RequestBody {
	r.Content = val
	return r
}

// WithContentItem sets Content item value.
func (r *RequestBody) WithContentItem(key string, val MediaType) *RequestBody {
	if r.Content == nil {
		r.Content = make(map[string]MediaType, 1)
	}

	r.Content[key] = val

	return r
}

// WithRequired sets Required value.
func (r *RequestBody) WithRequired(val bool) *RequestBody {
	r.Required = &val
	return r
}

// WithMapOfAnything sets MapOfAnything value.
func (r *RequestBody) WithMapOfAnything(val map[string]interface{}) *RequestBody {
	r.MapOfAnything = val
	return r
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (r *RequestBody) WithMapOfAnythingItem(key string, val interface{}) *RequestBody {
	if r.MapOfAnything == nil {
		r.MapOfAnything = make(map[string]interface{}, 1)
	}

	r.MapOfAnything[key] = val

	return r
}

type marshalRequestBody RequestBody

var knownKeysRequestBody = []string{
	"description",
	"content",
	"required",
}

var requireKeysRequestBody = []string{
	"content",
}

// UnmarshalJSON decodes JSON.
func (r *RequestBody) UnmarshalJSON(data []byte) error {
	var err error

	mr := marshalRequestBody(*r)

	err = json.Unmarshal(data, &mr)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysRequestBody {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysRequestBody {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mr.MapOfAnything == nil {
				mr.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mr.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*r = RequestBody(mr)

	return nil
}

// MarshalJSON encodes JSON.
func (r RequestBody) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalRequestBody(r), r.MapOfAnything)
}

// RequestBodyOrReference structure is generated from "#/$defs/request-body-or-reference".
type RequestBodyOrReference struct {
	Reference   *Reference   `json:"-"`
	RequestBody *RequestBody `json:"-"`
}

// WithReference sets Reference value.
func (r *RequestBodyOrReference) WithReference(val Reference) *RequestBodyOrReference {
	r.Reference = &val
	return r
}

// ReferenceEns ensures returned Reference is not nil.
func (r *RequestBodyOrReference) ReferenceEns() *Reference {
	if r.Reference == nil {
		r.Reference = new(Reference)
	}

	return r.Reference
}

// WithRequestBody sets RequestBody value.
func (r *RequestBodyOrReference) WithRequestBody(val RequestBody) *RequestBodyOrReference {
	r.RequestBody = &val
	return r
}

// RequestBodyEns ensures returned RequestBody is not nil.
func (r *RequestBodyOrReference) RequestBodyEns() *RequestBody {
	if r.RequestBody == nil {
		r.RequestBody = new(RequestBody)
	}

	return r.RequestBody
}

// UnmarshalJSON decodes JSON.
func (r *RequestBodyOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &r.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		r.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &r.RequestBody)
	if err != nil {
		oneOfErrors["RequestBody"] = err
		r.RequestBody = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for RequestBodyOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (r RequestBodyOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(r.Reference, r.RequestBody)
}

// Responses structure is generated from "#/$defs/responses".
type Responses struct {
	Default                        *ResponseOrReference           `json:"default,omitempty"`
	MapOfResponseOrReferenceValues map[string]ResponseOrReference `json:"-"` // Key must match pattern: `^[1-5](?:[0-9]{2}|XX)$`.
	MapOfAnything                  map[string]interface{}         `json:"-"` // Key must match pattern: `^x-`.
}

// WithDefault sets Default value.
func (r *Responses) WithDefault(val ResponseOrReference) *Responses {
	r.Default = &val
	return r
}

// DefaultEns ensures returned Default is not nil.
func (r *Responses) DefaultEns() *ResponseOrReference {
	if r.Default == nil {
		r.Default = new(ResponseOrReference)
	}

	return r.Default
}

// WithMapOfResponseOrReferenceValues sets MapOfResponseOrReferenceValues value.
func (r *Responses) WithMapOfResponseOrReferenceValues(val map[string]ResponseOrReference) *Responses {
	r.MapOfResponseOrReferenceValues = val
	return r
}

// WithMapOfResponseOrReferenceValuesItem sets MapOfResponseOrReferenceValues item value.
func (r *Responses) WithMapOfResponseOrReferenceValuesItem(key string, val ResponseOrReference) *Responses {
	if r.MapOfResponseOrReferenceValues == nil {
		r.MapOfResponseOrReferenceValues = make(map[string]ResponseOrReference, 1)
	}

	r.MapOfResponseOrReferenceValues[key] = val

	return r
}

// WithMapOfAnything sets MapOfAnything value.
func (r *Responses) WithMapOfAnything(val map[string]interface{}) *Responses {
	r.MapOfAnything = val
	return r
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (r *Responses) WithMapOfAnythingItem(key string, val interface{}) *Responses {
	if r.MapOfAnything == nil {
		r.MapOfAnything = make(map[string]interface{}, 1)
	}

	r.MapOfAnything[key] = val

	return r
}

type marshalResponses Responses

var knownKeysResponses = []string{
	"default",
}

// UnmarshalJSON decodes JSON.
func (r *Responses) UnmarshalJSON(data []byte) error {
	var err error

	mr := marshalResponses(*r)

	err = json.Unmarshal(data, &mr)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range knownKeysResponses {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regex15092XX.MatchString(key) {
			matched = true

			if mr.MapOfResponseOrReferenceValues == nil {
				mr.MapOfResponseOrReferenceValues = make(map[string]ResponseOrReference, 1)
			}

			var val ResponseOrReference

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mr.MapOfResponseOrReferenceValues[key] = val
		}

		if regexX.MatchString(key) {
			matched = true

			if mr.MapOfAnything == nil {
				mr.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mr.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*r = Responses(mr)

	return nil
}

// MarshalJSON encodes JSON.
func (r Responses) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalResponses(r), r.MapOfResponseOrReferenceValues, r.MapOfAnything)
}

// Response structure is generated from "#/$defs/response".
type Response struct {
	Description   string                       `json:"description"` // Required.
	Headers       map[string]HeaderOrReference `json:"headers,omitempty"`
	Content       map[string]MediaType         `json:"content,omitempty"`
	Links         map[string]LinkOrReference   `json:"links,omitempty"`
	MapOfAnything map[string]interface{}       `json:"-"` // Key must match pattern: `^x-`.
}

// WithDescription sets Description value.
func (r *Response) WithDescription(val string) *Response {
	r.Description = val
	return r
}

// WithHeaders sets Headers value.
func (r *Response) WithHeaders(val map[string]HeaderOrReference) *Response {
	r.Headers = val
	return r
}

// WithHeadersItem sets Headers item value.
func (r *Response) WithHeadersItem(key string, val HeaderOrReference) *Response {
	if r.Headers == nil {
		r.Headers = make(map[string]HeaderOrReference, 1)
	}

	r.Headers[key] = val

	return r
}

// WithContent sets Content value.
func (r *Response) WithContent(val map[string]MediaType) *Response {
	r.Content = val
	return r
}

// WithContentItem sets Content item value.
func (r *Response) WithContentItem(key string, val MediaType) *Response {
	if r.Content == nil {
		r.Content = make(map[string]MediaType, 1)
	}

	r.Content[key] = val

	return r
}

// WithLinks sets Links value.
func (r *Response) WithLinks(val map[string]LinkOrReference) *Response {
	r.Links = val
	return r
}

// WithLinksItem sets Links item value.
func (r *Response) WithLinksItem(key string, val LinkOrReference) *Response {
	if r.Links == nil {
		r.Links = make(map[string]LinkOrReference, 1)
	}

	r.Links[key] = val

	return r
}

// WithMapOfAnything sets MapOfAnything value.
func (r *Response) WithMapOfAnything(val map[string]interface{}) *Response {
	r.MapOfAnything = val
	return r
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (r *Response) WithMapOfAnythingItem(key string, val interface{}) *Response {
	if r.MapOfAnything == nil {
		r.MapOfAnything = make(map[string]interface{}, 1)
	}

	r.MapOfAnything[key] = val

	return r
}

type marshalResponse Response

var knownKeysResponse = []string{
	"description",
	"headers",
	"content",
	"links",
}

var requireKeysResponse = []string{
	"description",
}

// UnmarshalJSON decodes JSON.
func (r *Response) UnmarshalJSON(data []byte) error {
	var err error

	mr := marshalResponse(*r)

	err = json.Unmarshal(data, &mr)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysResponse {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysResponse {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mr.MapOfAnything == nil {
				mr.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mr.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*r = Response(mr)

	return nil
}

// MarshalJSON encodes JSON.
func (r Response) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalResponse(r), r.MapOfAnything)
}

// Link structure is generated from "#/$defs/link".
type Link struct {
	OperationRef  *string                `json:"operationRef,omitempty"` // Format: uri-reference.
	OperationID   *string                `json:"operationId,omitempty"`
	Parameters    map[string]string      `json:"parameters,omitempty"`
	RequestBody   *interface{}           `json:"requestBody,omitempty"`
	Description   *string                `json:"description,omitempty"`
	Body          *Server                `json:"body,omitempty"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithOperationRef sets OperationRef value.
func (l *Link) WithOperationRef(val string) *Link {
	l.OperationRef = &val
	return l
}

// WithOperationID sets OperationID value.
func (l *Link) WithOperationID(val string) *Link {
	l.OperationID = &val
	return l
}

// WithParameters sets Parameters value.
func (l *Link) WithParameters(val map[string]string) *Link {
	l.Parameters = val
	return l
}

// WithParametersItem sets Parameters item value.
func (l *Link) WithParametersItem(key string, val string) *Link {
	if l.Parameters == nil {
		l.Parameters = make(map[string]string, 1)
	}

	l.Parameters[key] = val

	return l
}

// WithRequestBody sets RequestBody value.
func (l *Link) WithRequestBody(val interface{}) *Link {
	l.RequestBody = &val
	return l
}

// WithDescription sets Description value.
func (l *Link) WithDescription(val string) *Link {
	l.Description = &val
	return l
}

// WithBody sets Body value.
func (l *Link) WithBody(val Server) *Link {
	l.Body = &val
	return l
}

// BodyEns ensures returned Body is not nil.
func (l *Link) BodyEns() *Server {
	if l.Body == nil {
		l.Body = new(Server)
	}

	return l.Body
}

// WithMapOfAnything sets MapOfAnything value.
func (l *Link) WithMapOfAnything(val map[string]interface{}) *Link {
	l.MapOfAnything = val
	return l
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (l *Link) WithMapOfAnythingItem(key string, val interface{}) *Link {
	if l.MapOfAnything == nil {
		l.MapOfAnything = make(map[string]interface{}, 1)
	}

	l.MapOfAnything[key] = val

	return l
}

type marshalLink Link

var knownKeysLink = []string{
	"operationRef",
	"operationId",
	"parameters",
	"requestBody",
	"description",
	"body",
}

// UnmarshalJSON decodes JSON.
func (l *Link) UnmarshalJSON(data []byte) error {
	var err error

	ml := marshalLink(*l)

	err = json.Unmarshal(data, &ml)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	if ml.RequestBody == nil {
		if _, ok := rawMap["requestBody"]; ok {
			var v interface{}
			ml.RequestBody = &v
		}
	}

	for _, key := range knownKeysLink {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ml.MapOfAnything == nil {
				ml.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ml.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*l = Link(ml)

	return nil
}

// MarshalJSON encodes JSON.
func (l Link) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalLink(l), l.MapOfAnything)
}

// LinkOrReference structure is generated from "#/$defs/link-or-reference".
type LinkOrReference struct {
	Reference *Reference `json:"-"`
	Link      *Link      `json:"-"`
}

// WithReference sets Reference value.
func (l *LinkOrReference) WithReference(val Reference) *LinkOrReference {
	l.Reference = &val
	return l
}

// ReferenceEns ensures returned Reference is not nil.
func (l *LinkOrReference) ReferenceEns() *Reference {
	if l.Reference == nil {
		l.Reference = new(Reference)
	}

	return l.Reference
}

// WithLink sets Link value.
func (l *LinkOrReference) WithLink(val Link) *LinkOrReference {
	l.Link = &val
	return l
}

// LinkEns ensures returned Link is not nil.
func (l *LinkOrReference) LinkEns() *Link {
	if l.Link == nil {
		l.Link = new(Link)
	}

	return l.Link
}

// UnmarshalJSON decodes JSON.
func (l *LinkOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &l.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		l.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &l.Link)
	if err != nil {
		oneOfErrors["Link"] = err
		l.Link = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for LinkOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (l LinkOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(l.Reference, l.Link)
}

// ResponseOrReference structure is generated from "#/$defs/response-or-reference".
type ResponseOrReference struct {
	Reference *Reference `json:"-"`
	Response  *Response  `json:"-"`
}

// WithReference sets Reference value.
func (r *ResponseOrReference) WithReference(val Reference) *ResponseOrReference {
	r.Reference = &val
	return r
}

// ReferenceEns ensures returned Reference is not nil.
func (r *ResponseOrReference) ReferenceEns() *Reference {
	if r.Reference == nil {
		r.Reference = new(Reference)
	}

	return r.Reference
}

// WithResponse sets Response value.
func (r *ResponseOrReference) WithResponse(val Response) *ResponseOrReference {
	r.Response = &val
	return r
}

// ResponseEns ensures returned Response is not nil.
func (r *ResponseOrReference) ResponseEns() *Response {
	if r.Response == nil {
		r.Response = new(Response)
	}

	return r.Response
}

// UnmarshalJSON decodes JSON.
func (r *ResponseOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &r.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		r.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &r.Response)
	if err != nil {
		oneOfErrors["Response"] = err
		r.Response = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for ResponseOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (r ResponseOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(r.Reference, r.Response)
}

// Callbacks structure is generated from "#/$defs/callbacks".
type Callbacks struct {
	MapOfAnything        map[string]interface{}         `json:"-"` // Key must match pattern: `^x-`.
	AdditionalProperties map[string]PathItemOrReference `json:"-"` // All unmatched properties.
}

// WithMapOfAnything sets MapOfAnything value.
func (c *Callbacks) WithMapOfAnything(val map[string]interface{}) *Callbacks {
	c.MapOfAnything = val
	return c
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (c *Callbacks) WithMapOfAnythingItem(key string, val interface{}) *Callbacks {
	if c.MapOfAnything == nil {
		c.MapOfAnything = make(map[string]interface{}, 1)
	}

	c.MapOfAnything[key] = val

	return c
}

// WithAdditionalProperties sets AdditionalProperties value.
func (c *Callbacks) WithAdditionalProperties(val map[string]PathItemOrReference) *Callbacks {
	c.AdditionalProperties = val
	return c
}

// WithAdditionalPropertiesItem sets AdditionalProperties item value.
func (c *Callbacks) WithAdditionalPropertiesItem(key string, val PathItemOrReference) *Callbacks {
	if c.AdditionalProperties == nil {
		c.AdditionalProperties = make(map[string]PathItemOrReference, 1)
	}

	c.AdditionalProperties[key] = val

	return c
}

// UnmarshalJSON decodes JSON.
func (c *Callbacks) UnmarshalJSON(data []byte) error {
	var err error

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if c.MapOfAnything == nil {
				c.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			c.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	for key, rawValue := range rawMap {
		if c.AdditionalProperties == nil {
			c.AdditionalProperties = make(map[string]PathItemOrReference, 1)
		}

		var val PathItemOrReference

		err = json.Unmarshal(rawValue, &val)
		if err != nil {
			return err
		}

		c.AdditionalProperties[key] = val
	}

	return nil
}

// MarshalJSON encodes JSON.
func (c Callbacks) MarshalJSON() ([]byte, error) {
	return marshalUnion(c.MapOfAnything, c.AdditionalProperties)
}

// PathItemOrReference structure is generated from "#/$defs/path-item-or-reference".
type PathItemOrReference struct {
	Reference *Reference `json:"-"`
	PathItem  *PathItem  `json:"-"`
}

// WithReference sets Reference value.
func (p *PathItemOrReference) WithReference(val Reference) *PathItemOrReference {
	p.Reference = &val
	return p
}

// ReferenceEns ensures returned Reference is not nil.
func (p *PathItemOrReference) ReferenceEns() *Reference {
	if p.Reference == nil {
		p.Reference = new(Reference)
	}

	return p.Reference
}

// WithPathItem sets PathItem value.
func (p *PathItemOrReference) WithPathItem(val PathItem) *PathItemOrReference {
	p.PathItem = &val
	return p
}

// PathItemEns ensures returned PathItem is not nil.
func (p *PathItemOrReference) PathItemEns() *PathItem {
	if p.PathItem == nil {
		p.PathItem = new(PathItem)
	}

	return p.PathItem
}

// UnmarshalJSON decodes JSON.
func (p *PathItemOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &p.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		p.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &p.PathItem)
	if err != nil {
		oneOfErrors["PathItem"] = err
		p.PathItem = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for PathItemOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (p PathItemOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(p.Reference, p.PathItem)
}

// CallbacksOrReference structure is generated from "#/$defs/callbacks-or-reference".
type CallbacksOrReference struct {
	Reference *Reference `json:"-"`
	Callbacks *Callbacks `json:"-"`
}

// WithReference sets Reference value.
func (c *CallbacksOrReference) WithReference(val Reference) *CallbacksOrReference {
	c.Reference = &val
	return c
}

// ReferenceEns ensures returned Reference is not nil.
func (c *CallbacksOrReference) ReferenceEns() *Reference {
	if c.Reference == nil {
		c.Reference = new(Reference)
	}

	return c.Reference
}

// WithCallbacks sets Callbacks value.
func (c *CallbacksOrReference) WithCallbacks(val Callbacks) *CallbacksOrReference {
	c.Callbacks = &val
	return c
}

// CallbacksEns ensures returned Callbacks is not nil.
func (c *CallbacksOrReference) CallbacksEns() *Callbacks {
	if c.Callbacks == nil {
		c.Callbacks = new(Callbacks)
	}

	return c.Callbacks
}

// UnmarshalJSON decodes JSON.
func (c *CallbacksOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &c.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		c.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &c.Callbacks)
	if err != nil {
		oneOfErrors["Callbacks"] = err
		c.Callbacks = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for CallbacksOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (c CallbacksOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(c.Reference, c.Callbacks)
}

// Paths structure is generated from "#/$defs/paths".
type Paths struct {
	MapOfPathItemValues map[string]PathItem    `json:"-"` // Key must match pattern: `^/`.
	MapOfAnything       map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithMapOfPathItemValues sets MapOfPathItemValues value.
func (p *Paths) WithMapOfPathItemValues(val map[string]PathItem) *Paths {
	p.MapOfPathItemValues = val
	return p
}

// WithMapOfPathItemValuesItem sets MapOfPathItemValues item value.
func (p *Paths) WithMapOfPathItemValuesItem(key string, val PathItem) *Paths {
	if p.MapOfPathItemValues == nil {
		p.MapOfPathItemValues = make(map[string]PathItem, 1)
	}

	p.MapOfPathItemValues[key] = val

	return p
}

// WithMapOfAnything sets MapOfAnything value.
func (p *Paths) WithMapOfAnything(val map[string]interface{}) *Paths {
	p.MapOfAnything = val
	return p
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (p *Paths) WithMapOfAnythingItem(key string, val interface{}) *Paths {
	if p.MapOfAnything == nil {
		p.MapOfAnything = make(map[string]interface{}, 1)
	}

	p.MapOfAnything[key] = val

	return p
}

// UnmarshalJSON decodes JSON.
func (p *Paths) UnmarshalJSON(data []byte) error {
	var err error

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for key, rawValue := range rawMap {
		matched := false

		if regex.MatchString(key) {
			matched = true

			if p.MapOfPathItemValues == nil {
				p.MapOfPathItemValues = make(map[string]PathItem, 1)
			}

			var val PathItem

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			p.MapOfPathItemValues[key] = val
		}

		if regexX.MatchString(key) {
			matched = true

			if p.MapOfAnything == nil {
				p.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			p.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	return nil
}

// MarshalJSON encodes JSON.
func (p Paths) MarshalJSON() ([]byte, error) {
	return marshalUnion(p.MapOfPathItemValues, p.MapOfAnything)
}

// Components structure is generated from "#/$defs/components".
type Components struct {
	Schemas         map[string]map[string]interface{}    `json:"schemas,omitempty"`
	Responses       map[string]ResponseOrReference       `json:"responses,omitempty"`
	Parameters      map[string]ParameterOrReference      `json:"parameters,omitempty"`
	Examples        map[string]ExampleOrReference        `json:"examples,omitempty"`
	RequestBodies   map[string]RequestBodyOrReference    `json:"requestBodies,omitempty"`
	Headers         map[string]HeaderOrReference         `json:"headers,omitempty"`
	SecuritySchemes map[string]SecuritySchemeOrReference `json:"securitySchemes,omitempty"`
	Links           map[string]LinkOrReference           `json:"links,omitempty"`
	Callbacks       map[string]CallbacksOrReference      `json:"callbacks,omitempty"`
	PathItems       map[string]PathItemOrReference       `json:"pathItems,omitempty"`
}

// WithSchemas sets Schemas value.
func (c *Components) WithSchemas(val map[string]map[string]interface{}) *Components {
	c.Schemas = val
	return c
}

// WithSchemasItem sets Schemas item value.
func (c *Components) WithSchemasItem(key string, val map[string]interface{}) *Components {
	if c.Schemas == nil {
		c.Schemas = make(map[string]map[string]interface{}, 1)
	}

	c.Schemas[key] = val

	return c
}

// WithResponses sets Responses value.
func (c *Components) WithResponses(val map[string]ResponseOrReference) *Components {
	c.Responses = val
	return c
}

// WithResponsesItem sets Responses item value.
func (c *Components) WithResponsesItem(key string, val ResponseOrReference) *Components {
	if c.Responses == nil {
		c.Responses = make(map[string]ResponseOrReference, 1)
	}

	c.Responses[key] = val

	return c
}

// WithParameters sets Parameters value.
func (c *Components) WithParameters(val map[string]ParameterOrReference) *Components {
	c.Parameters = val
	return c
}

// WithParametersItem sets Parameters item value.
func (c *Components) WithParametersItem(key string, val ParameterOrReference) *Components {
	if c.Parameters == nil {
		c.Parameters = make(map[string]ParameterOrReference, 1)
	}

	c.Parameters[key] = val

	return c
}

// WithExamples sets Examples value.
func (c *Components) WithExamples(val map[string]ExampleOrReference) *Components {
	c.Examples = val
	return c
}

// WithExamplesItem sets Examples item value.
func (c *Components) WithExamplesItem(key string, val ExampleOrReference) *Components {
	if c.Examples == nil {
		c.Examples = make(map[string]ExampleOrReference, 1)
	}

	c.Examples[key] = val

	return c
}

// WithRequestBodies sets RequestBodies value.
func (c *Components) WithRequestBodies(val map[string]RequestBodyOrReference) *Components {
	c.RequestBodies = val
	return c
}

// WithRequestBodiesItem sets RequestBodies item value.
func (c *Components) WithRequestBodiesItem(key string, val RequestBodyOrReference) *Components {
	if c.RequestBodies == nil {
		c.RequestBodies = make(map[string]RequestBodyOrReference, 1)
	}

	c.RequestBodies[key] = val

	return c
}

// WithHeaders sets Headers value.
func (c *Components) WithHeaders(val map[string]HeaderOrReference) *Components {
	c.Headers = val
	return c
}

// WithHeadersItem sets Headers item value.
func (c *Components) WithHeadersItem(key string, val HeaderOrReference) *Components {
	if c.Headers == nil {
		c.Headers = make(map[string]HeaderOrReference, 1)
	}

	c.Headers[key] = val

	return c
}

// WithSecuritySchemes sets SecuritySchemes value.
func (c *Components) WithSecuritySchemes(val map[string]SecuritySchemeOrReference) *Components {
	c.SecuritySchemes = val
	return c
}

// WithSecuritySchemesItem sets SecuritySchemes item value.
func (c *Components) WithSecuritySchemesItem(key string, val SecuritySchemeOrReference) *Components {
	if c.SecuritySchemes == nil {
		c.SecuritySchemes = make(map[string]SecuritySchemeOrReference, 1)
	}

	c.SecuritySchemes[key] = val

	return c
}

// WithLinks sets Links value.
func (c *Components) WithLinks(val map[string]LinkOrReference) *Components {
	c.Links = val
	return c
}

// WithLinksItem sets Links item value.
func (c *Components) WithLinksItem(key string, val LinkOrReference) *Components {
	if c.Links == nil {
		c.Links = make(map[string]LinkOrReference, 1)
	}

	c.Links[key] = val

	return c
}

// WithCallbacks sets Callbacks value.
func (c *Components) WithCallbacks(val map[string]CallbacksOrReference) *Components {
	c.Callbacks = val
	return c
}

// WithCallbacksItem sets Callbacks item value.
func (c *Components) WithCallbacksItem(key string, val CallbacksOrReference) *Components {
	if c.Callbacks == nil {
		c.Callbacks = make(map[string]CallbacksOrReference, 1)
	}

	c.Callbacks[key] = val

	return c
}

// WithPathItems sets PathItems value.
func (c *Components) WithPathItems(val map[string]PathItemOrReference) *Components {
	c.PathItems = val
	return c
}

// WithPathItemsItem sets PathItems item value.
func (c *Components) WithPathItemsItem(key string, val PathItemOrReference) *Components {
	if c.PathItems == nil {
		c.PathItems = make(map[string]PathItemOrReference, 1)
	}

	c.PathItems[key] = val

	return c
}

// SecurityScheme structure is generated from "#/$defs/security-scheme".
type SecurityScheme struct {
	Description   *string                   `json:"description,omitempty"`
	APIKey        *SecuritySchemeAPIKey     `json:"-"`
	HTTP          *SecuritySchemeHTTP       `json:"-"`
	HTTPBearer    *SecuritySchemeHTTPBearer `json:"-"`
	Oauth2        *SecuritySchemeOauth2     `json:"-"`
	Oidc          *SecuritySchemeOidc       `json:"-"`
	MutualTLS     *MutualTLS                `json:"-"`
	MapOfAnything map[string]interface{}    `json:"-"` // Key must match pattern: `^x-`.
}

// WithDescription sets Description value.
func (s *SecurityScheme) WithDescription(val string) *SecurityScheme {
	s.Description = &val
	return s
}

// WithAPIKey sets APIKey value.
func (s *SecurityScheme) WithAPIKey(val SecuritySchemeAPIKey) *SecurityScheme {
	s.APIKey = &val
	return s
}

// APIKeyEns ensures returned APIKey is not nil.
func (s *SecurityScheme) APIKeyEns() *SecuritySchemeAPIKey {
	if s.APIKey == nil {
		s.APIKey = new(SecuritySchemeAPIKey)
	}

	return s.APIKey
}

// WithHTTP sets HTTP value.
func (s *SecurityScheme) WithHTTP(val SecuritySchemeHTTP) *SecurityScheme {
	s.HTTP = &val
	return s
}

// HTTPEns ensures returned HTTP is not nil.
func (s *SecurityScheme) HTTPEns() *SecuritySchemeHTTP {
	if s.HTTP == nil {
		s.HTTP = new(SecuritySchemeHTTP)
	}

	return s.HTTP
}

// WithHTTPBearer sets HTTPBearer value.
func (s *SecurityScheme) WithHTTPBearer(val SecuritySchemeHTTPBearer) *SecurityScheme {
	s.HTTPBearer = &val
	return s
}

// HTTPBearerEns ensures returned HTTPBearer is not nil.
func (s *SecurityScheme) HTTPBearerEns() *SecuritySchemeHTTPBearer {
	if s.HTTPBearer == nil {
		s.HTTPBearer = new(SecuritySchemeHTTPBearer)
	}

	return s.HTTPBearer
}

// WithOauth2 sets Oauth2 value.
func (s *SecurityScheme) WithOauth2(val SecuritySchemeOauth2) *SecurityScheme {
	s.Oauth2 = &val
	return s
}

// Oauth2Ens ensures returned Oauth2 is not nil.
func (s *SecurityScheme) Oauth2Ens() *SecuritySchemeOauth2 {
	if s.Oauth2 == nil {
		s.Oauth2 = new(SecuritySchemeOauth2)
	}

	return s.Oauth2
}

// WithOidc sets Oidc value.
func (s *SecurityScheme) WithOidc(val SecuritySchemeOidc) *SecurityScheme {
	s.Oidc = &val
	return s
}

// OidcEns ensures returned Oidc is not nil.
func (s *SecurityScheme) OidcEns() *SecuritySchemeOidc {
	if s.Oidc == nil {
		s.Oidc = new(SecuritySchemeOidc)
	}

	return s.Oidc
}

// WithMutualTLS sets MutualTLS value.
func (s *SecurityScheme) WithMutualTLS(val MutualTLS) *SecurityScheme {
	s.MutualTLS = &val
	return s
}

// MutualTLSEns ensures returned MutualTLS is not nil.
func (s *SecurityScheme) MutualTLSEns() *MutualTLS {
	if s.MutualTLS == nil {
		s.MutualTLS = new(MutualTLS)
	}

	return s.MutualTLS
}

// WithMapOfAnything sets MapOfAnything value.
func (s *SecurityScheme) WithMapOfAnything(val map[string]interface{}) *SecurityScheme {
	s.MapOfAnything = val
	return s
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (s *SecurityScheme) WithMapOfAnythingItem(key string, val interface{}) *SecurityScheme {
	if s.MapOfAnything == nil {
		s.MapOfAnything = make(map[string]interface{}, 1)
	}

	s.MapOfAnything[key] = val

	return s
}

type marshalSecurityScheme SecurityScheme

var knownKeysSecurityScheme = []string{
	"description",
}

var requireKeysSecurityScheme = []string{
	"type",
}

// UnmarshalJSON decodes JSON.
func (s *SecurityScheme) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecurityScheme(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	oneOfErrors := make(map[string]error, 6)
	oneOfValid := 0

	err = json.Unmarshal(data, &ms.APIKey)
	if err != nil {
		oneOfErrors["APIKey"] = err
		ms.APIKey = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &ms.HTTP)
	if err != nil {
		oneOfErrors["HTTP"] = err
		ms.HTTP = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &ms.HTTPBearer)
	if err != nil {
		oneOfErrors["HTTPBearer"] = err
		ms.HTTPBearer = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &ms.Oauth2)
	if err != nil {
		oneOfErrors["Oauth2"] = err
		ms.Oauth2 = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &ms.Oidc)
	if err != nil {
		oneOfErrors["Oidc"] = err
		ms.Oidc = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &ms.MutualTLS)
	if err != nil {
		oneOfErrors["MutualTLS"] = err
		ms.MutualTLS = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for SecurityScheme with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecurityScheme {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysSecurityScheme {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if ms.MapOfAnything == nil {
				ms.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			ms.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*s = SecurityScheme(ms)

	return nil
}

// MarshalJSON encodes JSON.
func (s SecurityScheme) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalSecurityScheme(s), s.MapOfAnything, s.APIKey, s.HTTP, s.HTTPBearer, s.Oauth2, s.Oidc, s.MutualTLS)
}

// SecuritySchemeAPIKey structure is generated from "#/$defs/security-scheme/$defs/type-apikey".
type SecuritySchemeAPIKey struct {
	Name string                 `json:"name"` // Required.
	In   SecuritySchemeAPIKeyIn `json:"in"`   // Required.
}

// WithName sets Name value.
func (s *SecuritySchemeAPIKey) WithName(val string) *SecuritySchemeAPIKey {
	s.Name = val
	return s
}

// WithIn sets In value.
func (s *SecuritySchemeAPIKey) WithIn(val SecuritySchemeAPIKeyIn) *SecuritySchemeAPIKey {
	s.In = val
	return s
}

type marshalSecuritySchemeAPIKey SecuritySchemeAPIKey

var requireKeysSecuritySchemeAPIKey = []string{
	"type",
	"name",
	"in",
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeAPIKey) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecuritySchemeAPIKey(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecuritySchemeAPIKey {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"apiKey"` {
		return fmt.Errorf(`bad const value for "type" ("apiKey" expected, %s received)`, v)
	}

	delete(rawMap, "type")

	*s = SecuritySchemeAPIKey(ms)

	return nil
}

// constSecuritySchemeAPIKey is unconditionally added to JSON.
var constSecuritySchemeAPIKey = json.RawMessage(`{"type":"apiKey"}`)

// MarshalJSON encodes JSON.
func (s SecuritySchemeAPIKey) MarshalJSON() ([]byte, error) {
	return marshalUnion(constSecuritySchemeAPIKey, marshalSecuritySchemeAPIKey(s))
}

// SecuritySchemeHTTP structure is generated from "#/$defs/security-scheme/$defs/type-http".
type SecuritySchemeHTTP struct {
	Scheme string `json:"scheme"` // Required.
}

// WithScheme sets Scheme value.
func (s *SecuritySchemeHTTP) WithScheme(val string) *SecuritySchemeHTTP {
	s.Scheme = val
	return s
}

type marshalSecuritySchemeHTTP SecuritySchemeHTTP

var requireKeysSecuritySchemeHTTP = []string{
	"type",
	"scheme",
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeHTTP) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecuritySchemeHTTP(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecuritySchemeHTTP {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"http"` {
		return fmt.Errorf(`bad const value for "type" ("http" expected, %s received)`, v)
	}

	delete(rawMap, "type")

	if strings.ToLower(ms.Scheme) == "bearer" {
		return errors.New("use SecuritySchemeHTTPBearer for bearer scheme")
	}

	*s = SecuritySchemeHTTP(ms)

	return nil
}

// constSecuritySchemeHTTP is unconditionally added to JSON.
var constSecuritySchemeHTTP = json.RawMessage(`{"type":"http"}`)

// MarshalJSON encodes JSON.
func (s SecuritySchemeHTTP) MarshalJSON() ([]byte, error) {
	return marshalUnion(constSecuritySchemeHTTP, marshalSecuritySchemeHTTP(s))
}

// SecuritySchemeHTTPBearer structure is generated from "#/$defs/security-scheme/$defs/type-http-bearer".
type SecuritySchemeHTTPBearer struct {
	// Value must match pattern: `^[Bb][Ee][Aa][Rr][Ee][Rr]$`.
	// Required.
	Scheme       string  `json:"scheme"`
	BearerFormat *string `json:"bearerFormat,omitempty"`
}

// WithScheme sets Scheme value.
func (s *SecuritySchemeHTTPBearer) WithScheme(val string) *SecuritySchemeHTTPBearer {
	s.Scheme = val
	return s
}

// WithBearerFormat sets BearerFormat value.
func (s *SecuritySchemeHTTPBearer) WithBearerFormat(val string) *SecuritySchemeHTTPBearer {
	s.BearerFormat = &val
	return s
}

type marshalSecuritySchemeHTTPBearer SecuritySchemeHTTPBearer

var requireKeysSecuritySchemeHTTPBearer = []string{
	"type",
	"scheme",
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeHTTPBearer) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecuritySchemeHTTPBearer(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecuritySchemeHTTPBearer {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"http"` {
		return fmt.Errorf(`bad const value for "type" ("http" expected, %s received)`, v)
	}

	if strings.ToLower(ms.Scheme) != "bearer" {
		return errors.New("bearer scheme required")
	}

	delete(rawMap, "type")

	*s = SecuritySchemeHTTPBearer(ms)

	return nil
}

// constSecuritySchemeHTTPBearer is unconditionally added to JSON.
var constSecuritySchemeHTTPBearer = json.RawMessage(`{"type":"http"}`)

// MarshalJSON encodes JSON.
func (s SecuritySchemeHTTPBearer) MarshalJSON() ([]byte, error) {
	return marshalUnion(constSecuritySchemeHTTPBearer, marshalSecuritySchemeHTTPBearer(s))
}

// SecuritySchemeOauth2 structure is generated from "#/$defs/security-scheme/$defs/type-oauth2".
type SecuritySchemeOauth2 struct {
	Flows OauthFlows `json:"flows"` // Required.
}

// WithFlows sets Flows value.
func (s *SecuritySchemeOauth2) WithFlows(val OauthFlows) *SecuritySchemeOauth2 {
	s.Flows = val
	return s
}

type marshalSecuritySchemeOauth2 SecuritySchemeOauth2

var requireKeysSecuritySchemeOauth2 = []string{
	"type",
	"flows",
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeOauth2) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecuritySchemeOauth2(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecuritySchemeOauth2 {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"oauth2"` {
		return fmt.Errorf(`bad const value for "type" ("oauth2" expected, %s received)`, v)
	}

	delete(rawMap, "type")

	*s = SecuritySchemeOauth2(ms)

	return nil
}

// constSecuritySchemeOauth2 is unconditionally added to JSON.
var constSecuritySchemeOauth2 = json.RawMessage(`{"type":"oauth2"}`)

// MarshalJSON encodes JSON.
func (s SecuritySchemeOauth2) MarshalJSON() ([]byte, error) {
	return marshalUnion(constSecuritySchemeOauth2, marshalSecuritySchemeOauth2(s))
}

// OauthFlows structure is generated from "#/$defs/oauth-flows".
type OauthFlows struct {
	Implicit          *OauthFlowsDefsImplicit          `json:"implicit,omitempty"`
	Password          *OauthFlowsDefsPassword          `json:"password,omitempty"`
	ClientCredentials *OauthFlowsDefsClientCredentials `json:"clientCredentials,omitempty"`
	AuthorizationCode *OauthFlowsDefsAuthorizationCode `json:"authorizationCode,omitempty"`
	MapOfAnything     map[string]interface{}           `json:"-"` // Key must match pattern: `^x-`.
}

// WithImplicit sets Implicit value.
func (o *OauthFlows) WithImplicit(val OauthFlowsDefsImplicit) *OauthFlows {
	o.Implicit = &val
	return o
}

// ImplicitEns ensures returned Implicit is not nil.
func (o *OauthFlows) ImplicitEns() *OauthFlowsDefsImplicit {
	if o.Implicit == nil {
		o.Implicit = new(OauthFlowsDefsImplicit)
	}

	return o.Implicit
}

// WithPassword sets Password value.
func (o *OauthFlows) WithPassword(val OauthFlowsDefsPassword) *OauthFlows {
	o.Password = &val
	return o
}

// PasswordEns ensures returned Password is not nil.
func (o *OauthFlows) PasswordEns() *OauthFlowsDefsPassword {
	if o.Password == nil {
		o.Password = new(OauthFlowsDefsPassword)
	}

	return o.Password
}

// WithClientCredentials sets ClientCredentials value.
func (o *OauthFlows) WithClientCredentials(val OauthFlowsDefsClientCredentials) *OauthFlows {
	o.ClientCredentials = &val
	return o
}

// ClientCredentialsEns ensures returned ClientCredentials is not nil.
func (o *OauthFlows) ClientCredentialsEns() *OauthFlowsDefsClientCredentials {
	if o.ClientCredentials == nil {
		o.ClientCredentials = new(OauthFlowsDefsClientCredentials)
	}

	return o.ClientCredentials
}

// WithAuthorizationCode sets AuthorizationCode value.
func (o *OauthFlows) WithAuthorizationCode(val OauthFlowsDefsAuthorizationCode) *OauthFlows {
	o.AuthorizationCode = &val
	return o
}

// AuthorizationCodeEns ensures returned AuthorizationCode is not nil.
func (o *OauthFlows) AuthorizationCodeEns() *OauthFlowsDefsAuthorizationCode {
	if o.AuthorizationCode == nil {
		o.AuthorizationCode = new(OauthFlowsDefsAuthorizationCode)
	}

	return o.AuthorizationCode
}

// WithMapOfAnything sets MapOfAnything value.
func (o *OauthFlows) WithMapOfAnything(val map[string]interface{}) *OauthFlows {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *OauthFlows) WithMapOfAnythingItem(key string, val interface{}) *OauthFlows {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOauthFlows OauthFlows

var knownKeysOauthFlows = []string{
	"implicit",
	"password",
	"clientCredentials",
	"authorizationCode",
}

// UnmarshalJSON decodes JSON.
func (o *OauthFlows) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOauthFlows(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range knownKeysOauthFlows {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = OauthFlows(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o OauthFlows) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOauthFlows(o), o.MapOfAnything)
}

// OauthFlowsDefsImplicit structure is generated from "#/$defs/oauth-flows/$defs/implicit".
type OauthFlowsDefsImplicit struct {
	// Format: uri.
	// Required.
	AuthorizationURL string                 `json:"authorizationUrl"`
	RefreshURL       *string                `json:"refreshUrl,omitempty"` // Format: uri.
	Scopes           map[string]string      `json:"scopes"`               // Required.
	MapOfAnything    map[string]interface{} `json:"-"`                    // Key must match pattern: `^x-`.
}

// WithAuthorizationURL sets AuthorizationURL value.
func (o *OauthFlowsDefsImplicit) WithAuthorizationURL(val string) *OauthFlowsDefsImplicit {
	o.AuthorizationURL = val
	return o
}

// WithRefreshURL sets RefreshURL value.
func (o *OauthFlowsDefsImplicit) WithRefreshURL(val string) *OauthFlowsDefsImplicit {
	o.RefreshURL = &val
	return o
}

// WithScopes sets Scopes value.
func (o *OauthFlowsDefsImplicit) WithScopes(val map[string]string) *OauthFlowsDefsImplicit {
	o.Scopes = val
	return o
}

// WithScopesItem sets Scopes item value.
func (o *OauthFlowsDefsImplicit) WithScopesItem(key string, val string) *OauthFlowsDefsImplicit {
	if o.Scopes == nil {
		o.Scopes = make(map[string]string, 1)
	}

	o.Scopes[key] = val

	return o
}

// WithMapOfAnything sets MapOfAnything value.
func (o *OauthFlowsDefsImplicit) WithMapOfAnything(val map[string]interface{}) *OauthFlowsDefsImplicit {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *OauthFlowsDefsImplicit) WithMapOfAnythingItem(key string, val interface{}) *OauthFlowsDefsImplicit {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOauthFlowsDefsImplicit OauthFlowsDefsImplicit

var knownKeysOauthFlowsDefsImplicit = []string{
	"authorizationUrl",
	"refreshUrl",
	"scopes",
}

var requireKeysOauthFlowsDefsImplicit = []string{
	"authorizationUrl",
	"scopes",
}

// UnmarshalJSON decodes JSON.
func (o *OauthFlowsDefsImplicit) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOauthFlowsDefsImplicit(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysOauthFlowsDefsImplicit {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysOauthFlowsDefsImplicit {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = OauthFlowsDefsImplicit(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o OauthFlowsDefsImplicit) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOauthFlowsDefsImplicit(o), o.MapOfAnything)
}

// OauthFlowsDefsPassword structure is generated from "#/$defs/oauth-flows/$defs/password".
type OauthFlowsDefsPassword struct {
	// Format: uri.
	// Required.
	TokenURL      string                 `json:"tokenUrl"`
	RefreshURL    *string                `json:"refreshUrl,omitempty"` // Format: uri.
	Scopes        map[string]string      `json:"scopes"`               // Required.
	MapOfAnything map[string]interface{} `json:"-"`                    // Key must match pattern: `^x-`.
}

// WithTokenURL sets TokenURL value.
func (o *OauthFlowsDefsPassword) WithTokenURL(val string) *OauthFlowsDefsPassword {
	o.TokenURL = val
	return o
}

// WithRefreshURL sets RefreshURL value.
func (o *OauthFlowsDefsPassword) WithRefreshURL(val string) *OauthFlowsDefsPassword {
	o.RefreshURL = &val
	return o
}

// WithScopes sets Scopes value.
func (o *OauthFlowsDefsPassword) WithScopes(val map[string]string) *OauthFlowsDefsPassword {
	o.Scopes = val
	return o
}

// WithScopesItem sets Scopes item value.
func (o *OauthFlowsDefsPassword) WithScopesItem(key string, val string) *OauthFlowsDefsPassword {
	if o.Scopes == nil {
		o.Scopes = make(map[string]string, 1)
	}

	o.Scopes[key] = val

	return o
}

// WithMapOfAnything sets MapOfAnything value.
func (o *OauthFlowsDefsPassword) WithMapOfAnything(val map[string]interface{}) *OauthFlowsDefsPassword {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *OauthFlowsDefsPassword) WithMapOfAnythingItem(key string, val interface{}) *OauthFlowsDefsPassword {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOauthFlowsDefsPassword OauthFlowsDefsPassword

var knownKeysOauthFlowsDefsPassword = []string{
	"tokenUrl",
	"refreshUrl",
	"scopes",
}

var requireKeysOauthFlowsDefsPassword = []string{
	"tokenUrl",
	"scopes",
}

// UnmarshalJSON decodes JSON.
func (o *OauthFlowsDefsPassword) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOauthFlowsDefsPassword(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysOauthFlowsDefsPassword {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysOauthFlowsDefsPassword {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = OauthFlowsDefsPassword(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o OauthFlowsDefsPassword) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOauthFlowsDefsPassword(o), o.MapOfAnything)
}

// OauthFlowsDefsClientCredentials structure is generated from "#/$defs/oauth-flows/$defs/client-credentials".
type OauthFlowsDefsClientCredentials struct {
	// Format: uri.
	// Required.
	TokenURL      string                 `json:"tokenUrl"`
	RefreshURL    *string                `json:"refreshUrl,omitempty"` // Format: uri.
	Scopes        map[string]string      `json:"scopes"`               // Required.
	MapOfAnything map[string]interface{} `json:"-"`                    // Key must match pattern: `^x-`.
}

// WithTokenURL sets TokenURL value.
func (o *OauthFlowsDefsClientCredentials) WithTokenURL(val string) *OauthFlowsDefsClientCredentials {
	o.TokenURL = val
	return o
}

// WithRefreshURL sets RefreshURL value.
func (o *OauthFlowsDefsClientCredentials) WithRefreshURL(val string) *OauthFlowsDefsClientCredentials {
	o.RefreshURL = &val
	return o
}

// WithScopes sets Scopes value.
func (o *OauthFlowsDefsClientCredentials) WithScopes(val map[string]string) *OauthFlowsDefsClientCredentials {
	o.Scopes = val
	return o
}

// WithScopesItem sets Scopes item value.
func (o *OauthFlowsDefsClientCredentials) WithScopesItem(key string, val string) *OauthFlowsDefsClientCredentials {
	if o.Scopes == nil {
		o.Scopes = make(map[string]string, 1)
	}

	o.Scopes[key] = val

	return o
}

// WithMapOfAnything sets MapOfAnything value.
func (o *OauthFlowsDefsClientCredentials) WithMapOfAnything(val map[string]interface{}) *OauthFlowsDefsClientCredentials {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *OauthFlowsDefsClientCredentials) WithMapOfAnythingItem(key string, val interface{}) *OauthFlowsDefsClientCredentials {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOauthFlowsDefsClientCredentials OauthFlowsDefsClientCredentials

var knownKeysOauthFlowsDefsClientCredentials = []string{
	"tokenUrl",
	"refreshUrl",
	"scopes",
}

var requireKeysOauthFlowsDefsClientCredentials = []string{
	"tokenUrl",
	"scopes",
}

// UnmarshalJSON decodes JSON.
func (o *OauthFlowsDefsClientCredentials) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOauthFlowsDefsClientCredentials(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysOauthFlowsDefsClientCredentials {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysOauthFlowsDefsClientCredentials {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = OauthFlowsDefsClientCredentials(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o OauthFlowsDefsClientCredentials) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOauthFlowsDefsClientCredentials(o), o.MapOfAnything)
}

// OauthFlowsDefsAuthorizationCode structure is generated from "#/$defs/oauth-flows/$defs/authorization-code".
type OauthFlowsDefsAuthorizationCode struct {
	// Format: uri.
	// Required.
	AuthorizationURL string `json:"authorizationUrl"`
	// Format: uri.
	// Required.
	TokenURL      string                 `json:"tokenUrl"`
	RefreshURL    *string                `json:"refreshUrl,omitempty"` // Format: uri.
	Scopes        map[string]string      `json:"scopes"`               // Required.
	MapOfAnything map[string]interface{} `json:"-"`                    // Key must match pattern: `^x-`.
}

// WithAuthorizationURL sets AuthorizationURL value.
func (o *OauthFlowsDefsAuthorizationCode) WithAuthorizationURL(val string) *OauthFlowsDefsAuthorizationCode {
	o.AuthorizationURL = val
	return o
}

// WithTokenURL sets TokenURL value.
func (o *OauthFlowsDefsAuthorizationCode) WithTokenURL(val string) *OauthFlowsDefsAuthorizationCode {
	o.TokenURL = val
	return o
}

// WithRefreshURL sets RefreshURL value.
func (o *OauthFlowsDefsAuthorizationCode) WithRefreshURL(val string) *OauthFlowsDefsAuthorizationCode {
	o.RefreshURL = &val
	return o
}

// WithScopes sets Scopes value.
func (o *OauthFlowsDefsAuthorizationCode) WithScopes(val map[string]string) *OauthFlowsDefsAuthorizationCode {
	o.Scopes = val
	return o
}

// WithScopesItem sets Scopes item value.
func (o *OauthFlowsDefsAuthorizationCode) WithScopesItem(key string, val string) *OauthFlowsDefsAuthorizationCode {
	if o.Scopes == nil {
		o.Scopes = make(map[string]string, 1)
	}

	o.Scopes[key] = val

	return o
}

// WithMapOfAnything sets MapOfAnything value.
func (o *OauthFlowsDefsAuthorizationCode) WithMapOfAnything(val map[string]interface{}) *OauthFlowsDefsAuthorizationCode {
	o.MapOfAnything = val
	return o
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (o *OauthFlowsDefsAuthorizationCode) WithMapOfAnythingItem(key string, val interface{}) *OauthFlowsDefsAuthorizationCode {
	if o.MapOfAnything == nil {
		o.MapOfAnything = make(map[string]interface{}, 1)
	}

	o.MapOfAnything[key] = val

	return o
}

type marshalOauthFlowsDefsAuthorizationCode OauthFlowsDefsAuthorizationCode

var knownKeysOauthFlowsDefsAuthorizationCode = []string{
	"authorizationUrl",
	"tokenUrl",
	"refreshUrl",
	"scopes",
}

var requireKeysOauthFlowsDefsAuthorizationCode = []string{
	"authorizationUrl",
	"tokenUrl",
	"scopes",
}

// UnmarshalJSON decodes JSON.
func (o *OauthFlowsDefsAuthorizationCode) UnmarshalJSON(data []byte) error {
	var err error

	mo := marshalOauthFlowsDefsAuthorizationCode(*o)

	err = json.Unmarshal(data, &mo)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysOauthFlowsDefsAuthorizationCode {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysOauthFlowsDefsAuthorizationCode {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mo.MapOfAnything == nil {
				mo.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mo.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*o = OauthFlowsDefsAuthorizationCode(mo)

	return nil
}

// MarshalJSON encodes JSON.
func (o OauthFlowsDefsAuthorizationCode) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalOauthFlowsDefsAuthorizationCode(o), o.MapOfAnything)
}

// SecuritySchemeOidc structure is generated from "#/$defs/security-scheme/$defs/type-oidc".
type SecuritySchemeOidc struct {
	// Format: uri.
	// Required.
	OpenIDConnectURL string `json:"openIdConnectUrl"`
}

// WithOpenIDConnectURL sets OpenIDConnectURL value.
func (s *SecuritySchemeOidc) WithOpenIDConnectURL(val string) *SecuritySchemeOidc {
	s.OpenIDConnectURL = val
	return s
}

type marshalSecuritySchemeOidc SecuritySchemeOidc

var requireKeysSecuritySchemeOidc = []string{
	"type",
	"openIdConnectUrl",
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeOidc) UnmarshalJSON(data []byte) error {
	var err error

	ms := marshalSecuritySchemeOidc(*s)

	err = json.Unmarshal(data, &ms)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysSecuritySchemeOidc {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"openIdConnect"` {
		return fmt.Errorf(`bad const value for "type" ("openIdConnect" expected, %s received)`, v)
	}

	delete(rawMap, "type")

	*s = SecuritySchemeOidc(ms)

	return nil
}

// constSecuritySchemeOidc is unconditionally added to JSON.
var constSecuritySchemeOidc = json.RawMessage(`{"type":"openIdConnect"}`)

// MarshalJSON encodes JSON.
func (s SecuritySchemeOidc) MarshalJSON() ([]byte, error) {
	return marshalUnion(constSecuritySchemeOidc, marshalSecuritySchemeOidc(s))
}

// MutualTLS structure is generated from "#/$defs/security-scheme/oneOf/5".
//
// mutualTLS.
type MutualTLS struct{}

// UnmarshalJSON decodes JSON.
func (m *MutualTLS) UnmarshalJSON(data []byte) error {
	var err error

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	if v, exists := rawMap["type"]; exists && string(v) != `"mutualTLS"` {
		return fmt.Errorf(`bad const value for "type" ("mutualTLS" expected, %s received)`, v)
	}

	delete(rawMap, "type")

	return nil
}

// constMutualTLS is unconditionally added to JSON.
var constMutualTLS = json.RawMessage(`{"type":"mutualTLS"}`)

// MarshalJSON encodes JSON.
func (m MutualTLS) MarshalJSON() ([]byte, error) {
	return marshalUnion(constMutualTLS)
}

// SecuritySchemeOrReference structure is generated from "#/$defs/security-scheme-or-reference".
type SecuritySchemeOrReference struct {
	Reference      *Reference      `json:"-"`
	SecurityScheme *SecurityScheme `json:"-"`
}

// WithReference sets Reference value.
func (s *SecuritySchemeOrReference) WithReference(val Reference) *SecuritySchemeOrReference {
	s.Reference = &val
	return s
}

// ReferenceEns ensures returned Reference is not nil.
func (s *SecuritySchemeOrReference) ReferenceEns() *Reference {
	if s.Reference == nil {
		s.Reference = new(Reference)
	}

	return s.Reference
}

// WithSecurityScheme sets SecurityScheme value.
func (s *SecuritySchemeOrReference) WithSecurityScheme(val SecurityScheme) *SecuritySchemeOrReference {
	s.SecurityScheme = &val
	return s
}

// SecuritySchemeEns ensures returned SecurityScheme is not nil.
func (s *SecuritySchemeOrReference) SecuritySchemeEns() *SecurityScheme {
	if s.SecurityScheme == nil {
		s.SecurityScheme = new(SecurityScheme)
	}

	return s.SecurityScheme
}

// UnmarshalJSON decodes JSON.
func (s *SecuritySchemeOrReference) UnmarshalJSON(data []byte) error {
	var err error

	oneOfErrors := make(map[string]error, 2)
	oneOfValid := 0

	err = json.Unmarshal(data, &s.Reference)
	if err != nil {
		oneOfErrors["Reference"] = err
		s.Reference = nil
	} else {
		oneOfValid++
	}

	err = json.Unmarshal(data, &s.SecurityScheme)
	if err != nil {
		oneOfErrors["SecurityScheme"] = err
		s.SecurityScheme = nil
	} else {
		oneOfValid++
	}

	if oneOfValid != 1 {
		return fmt.Errorf("oneOf constraint failed for SecuritySchemeOrReference with %d valid results: %v", oneOfValid, oneOfErrors)
	}

	return nil
}

// MarshalJSON encodes JSON.
func (s SecuritySchemeOrReference) MarshalJSON() ([]byte, error) {
	return marshalUnion(s.Reference, s.SecurityScheme)
}

// Tag structure is generated from "#/$defs/tag".
type Tag struct {
	Name          string                 `json:"name"` // Required.
	Description   *string                `json:"description,omitempty"`
	ExternalDocs  *ExternalDocumentation `json:"externalDocs,omitempty"`
	MapOfAnything map[string]interface{} `json:"-"` // Key must match pattern: `^x-`.
}

// WithName sets Name value.
func (t *Tag) WithName(val string) *Tag {
	t.Name = val
	return t
}

// WithDescription sets Description value.
func (t *Tag) WithDescription(val string) *Tag {
	t.Description = &val
	return t
}

// WithExternalDocs sets ExternalDocs value.
func (t *Tag) WithExternalDocs(val ExternalDocumentation) *Tag {
	t.ExternalDocs = &val
	return t
}

// ExternalDocsEns ensures returned ExternalDocs is not nil.
func (t *Tag) ExternalDocsEns() *ExternalDocumentation {
	if t.ExternalDocs == nil {
		t.ExternalDocs = new(ExternalDocumentation)
	}

	return t.ExternalDocs
}

// WithMapOfAnything sets MapOfAnything value.
func (t *Tag) WithMapOfAnything(val map[string]interface{}) *Tag {
	t.MapOfAnything = val
	return t
}

// WithMapOfAnythingItem sets MapOfAnything item value.
func (t *Tag) WithMapOfAnythingItem(key string, val interface{}) *Tag {
	if t.MapOfAnything == nil {
		t.MapOfAnything = make(map[string]interface{}, 1)
	}

	t.MapOfAnything[key] = val

	return t
}

type marshalTag Tag

var knownKeysTag = []string{
	"name",
	"description",
	"externalDocs",
}

var requireKeysTag = []string{
	"name",
}

// UnmarshalJSON decodes JSON.
func (t *Tag) UnmarshalJSON(data []byte) error {
	var err error

	mt := marshalTag(*t)

	err = json.Unmarshal(data, &mt)
	if err != nil {
		return err
	}

	var rawMap map[string]json.RawMessage

	err = json.Unmarshal(data, &rawMap)
	if err != nil {
		rawMap = nil
	}

	for _, key := range requireKeysTag {
		if _, found := rawMap[key]; !found {
			return errors.New("required key missing: " + key)
		}
	}

	for _, key := range knownKeysTag {
		delete(rawMap, key)
	}

	for key, rawValue := range rawMap {
		matched := false

		if regexX.MatchString(key) {
			matched = true

			if mt.MapOfAnything == nil {
				mt.MapOfAnything = make(map[string]interface{}, 1)
			}

			var val interface{}

			err = json.Unmarshal(rawValue, &val)
			if err != nil {
				return err
			}

			mt.MapOfAnything[key] = val
		}

		if matched {
			delete(rawMap, key)
		}
	}

	*t = Tag(mt)

	return nil
}

// MarshalJSON encodes JSON.
func (t Tag) MarshalJSON() ([]byte, error) {
	return marshalUnion(marshalTag(t), t.MapOfAnything)
}

// ParameterIn is an enum type.
type ParameterIn string

// ParameterIn values enumeration.
const (
	ParameterInQuery  = ParameterIn("query")
	ParameterInHeader = ParameterIn("header")
	ParameterInPath   = ParameterIn("path")
	ParameterInCookie = ParameterIn("cookie")
)

// MarshalJSON encodes JSON.
func (i ParameterIn) MarshalJSON() ([]byte, error) {
	switch i {
	case ParameterInQuery:
	case ParameterInHeader:
	case ParameterInPath:
	case ParameterInCookie:

	default:
		return nil, fmt.Errorf("unexpected ParameterIn value: %v", i)
	}

	return json.Marshal(string(i))
}

// UnmarshalJSON decodes JSON.
func (i *ParameterIn) UnmarshalJSON(data []byte) error {
	var ii string

	err := json.Unmarshal(data, &ii)
	if err != nil {
		return err
	}

	v := ParameterIn(ii)

	switch v {
	case ParameterInQuery:
	case ParameterInHeader:
	case ParameterInPath:
	case ParameterInCookie:

	default:
		return fmt.Errorf("unexpected ParameterIn value: %v", v)
	}

	*i = v

	return nil
}

// EncodingStyle is an enum type.
type EncodingStyle string

// EncodingStyle values enumeration.
const (
	EncodingStyleForm           = EncodingStyle("form")
	EncodingStyleSpaceDelimited = EncodingStyle("spaceDelimited")
	EncodingStylePipeDelimited  = EncodingStyle("pipeDelimited")
	EncodingStyleDeepObject     = EncodingStyle("deepObject")
)

// MarshalJSON encodes JSON.
func (i EncodingStyle) MarshalJSON() ([]byte, error) {
	switch i {
	case EncodingStyleForm:
	case EncodingStyleSpaceDelimited:
	case EncodingStylePipeDelimited:
	case EncodingStyleDeepObject:

	default:
		return nil, fmt.Errorf("unexpected EncodingStyle value: %v", i)
	}

	return json.Marshal(string(i))
}

// UnmarshalJSON decodes JSON.
func (i *EncodingStyle) UnmarshalJSON(data []byte) error {
	var ii string

	err := json.Unmarshal(data, &ii)
	if err != nil {
		return err
	}

	v := EncodingStyle(ii)

	switch v {
	case EncodingStyleForm:
	case EncodingStyleSpaceDelimited:
	case EncodingStylePipeDelimited:
	case EncodingStyleDeepObject:

	default:
		return fmt.Errorf("unexpected EncodingStyle value: %v", v)
	}

	*i = v

	return nil
}

// ParameterStyle is an enum type.
type ParameterStyle string

// ParameterStyle values enumeration.
const (
	ParameterStyleForm           = ParameterStyle("form")
	ParameterStyleSpaceDelimited = ParameterStyle("spaceDelimited")
	ParameterStylePipeDelimited  = ParameterStyle("pipeDelimited")
	ParameterStyleDeepObject     = ParameterStyle("deepObject")
)

// MarshalJSON encodes JSON.
func (i ParameterStyle) MarshalJSON() ([]byte, error) {
	switch i {
	case ParameterStyleForm:
	case ParameterStyleSpaceDelimited:
	case ParameterStylePipeDelimited:
	case ParameterStyleDeepObject:

	default:
		return nil, fmt.Errorf("unexpected ParameterStyle value: %v", i)
	}

	return json.Marshal(string(i))
}

// UnmarshalJSON decodes JSON.
func (i *ParameterStyle) UnmarshalJSON(data []byte) error {
	var ii string

	err := json.Unmarshal(data, &ii)
	if err != nil {
		return err
	}

	v := ParameterStyle(ii)

	switch v {
	case ParameterStyleForm:
	case ParameterStyleSpaceDelimited:
	case ParameterStylePipeDelimited:
	case ParameterStyleDeepObject:

	default:
		return fmt.Errorf("unexpected ParameterStyle value: %v", v)
	}

	*i = v

	return nil
}

// SecuritySchemeAPIKeyIn is an enum type.
type SecuritySchemeAPIKeyIn string

// SecuritySchemeAPIKeyIn values enumeration.
const (
	SecuritySchemeAPIKeyInQuery  = SecuritySchemeAPIKeyIn("query")
	SecuritySchemeAPIKeyInHeader = SecuritySchemeAPIKeyIn("header")
	SecuritySchemeAPIKeyInCookie = SecuritySchemeAPIKeyIn("cookie")
)

// MarshalJSON encodes JSON.
func (i SecuritySchemeAPIKeyIn) MarshalJSON() ([]byte, error) {
	switch i {
	case SecuritySchemeAPIKeyInQuery:
	case SecuritySchemeAPIKeyInHeader:
	case SecuritySchemeAPIKeyInCookie:

	default:
		return nil, fmt.Errorf("unexpected SecuritySchemeAPIKeyIn value: %v", i)
	}

	return json.Marshal(string(i))
}

// UnmarshalJSON decodes JSON.
func (i *SecuritySchemeAPIKeyIn) UnmarshalJSON(data []byte) error {
	var ii string

	err := json.Unmarshal(data, &ii)
	if err != nil {
		return err
	}

	v := SecuritySchemeAPIKeyIn(ii)

	switch v {
	case SecuritySchemeAPIKeyInQuery:
	case SecuritySchemeAPIKeyInHeader:
	case SecuritySchemeAPIKeyInCookie:

	default:
		return fmt.Errorf("unexpected SecuritySchemeAPIKeyIn value: %v", v)
	}

	*i = v

	return nil
}

func marshalUnion(maps ...interface{}) ([]byte, error) {
	result := []byte("{")
	isObject := true

	for _, m := range maps {
		j, err := json.Marshal(m)
		if err != nil {
			return nil, err
		}

		if string(j) == "{}" {
			continue
		}

		if string(j) == "null" {
			continue
		}

		if j[0] != '{' {
			if len(result) == 1 && (isObject || bytes.Equal(result, j)) {
				result = j
				isObject = false

				continue
			}

			return nil, errors.New("failed to union map: object expected, " + string(j) + " received")
		}

		if !isObject {
			return nil, errors.New("failed to union " + string(result) + " and " + string(j))
		}

		if len(result) > 1 {
			result[len(result)-1] = ','
		}

		result = append(result, j[1:]...)
	}

	// Close empty result.
	if isObject && len(result) == 1 {
		result = append(result, '}')
	}

	return result, nil
}

// Regular expressions for pattern properties.
var (
	regexX       = regexp.MustCompile("^x-")
	regex15092XX = regexp.MustCompile("^[1-5](?:[0-9]{2}|XX)$")
	regex        = regexp.MustCompile("^/")
)
