/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.instrumentation.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.bytecode.instrumentation.internal.FieldInterceptionHelper;
import org.hibernate.service.instrumentation.spi.InstrumentationService;

public class CachingInstrumentationService
implements InstrumentationService {
    private final ConcurrentHashMap<Class<?>, Boolean> isInstrumentedCache = new ConcurrentHashMap();

    @Override
    public boolean isInstrumented(Class<?> entityType) {
        Boolean isInstrumented = this.isInstrumentedCache.get(entityType);
        if (isInstrumented == null) {
            isInstrumented = FieldInterceptionHelper.isInstrumented(entityType);
            this.isInstrumentedCache.put(entityType, isInstrumented);
        }
        return isInstrumented;
    }

    @Override
    public boolean isInstrumented(Object entity) {
        return entity != null && this.isInstrumented(entity.getClass());
    }
}

