/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditConfigParser
implements XMLStreamConstants {
    public List<AuditProviderEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<AuditProviderEntry> entries = new ArrayList<AuditProviderEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            AuditProviderEntry entry = null;
            if (!"provider-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private AuditProviderEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if (!"code".equals(attQName.getLocalPart())) continue;
            codeName = attributeValue;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        AuditProviderEntry entry = new AuditProviderEntry(codeName, options);
        return entry;
    }

    public List<AuditProviderEntry> parse(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<AuditProviderEntry> entries = new ArrayList<AuditProviderEntry>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            AuditProviderEntry entry = null;
            if (!element.equals((Object)Element.PROVIDER_MODULE)) {
                throw StaxParserUtil.unexpectedElement(reader);
            }
            entry = this.getEntry(reader);
            entries.add(entry);
        }
        return entries;
    }

    private AuditProviderEntry getEntry(XMLStreamReader reader) throws XMLStreamException {
        String codeName = null;
        HashMap<String, Object> options = new HashMap<String, Object>();
        int count = reader.getAttributeCount();
        if (count < 1) {
            throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.CODE));
        }
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    codeName = value;
                    continue block3;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        AuditProviderEntry entry = new AuditProviderEntry(codeName, options);
        return entry;
    }
}

