/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.metadata.decoration.archetype.VendorResult;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.CustomerPackageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownArchiveProfiler {
    private static final Logger LOG = LoggerFactory.getLogger(KnownArchiveProfiler.class);
    private Map<Pattern, String> knownPackages;
    private CustomerPackageResolver customerPackageResolver;

    public void setCustomerPackageResolver(CustomerPackageResolver customerPackageResolver) {
        this.customerPackageResolver = customerPackageResolver;
    }

    public void setKnownPackages(Map<String, String> knownPackagesSet) {
        this.knownPackages = this.compilePatternSet(knownPackagesSet);
    }

    protected Map<Pattern, String> compilePatternSet(Map<String, String> patternStringSet) {
        if (patternStringSet == null) {
            return null;
        }
        HashMap<Pattern, String> target = new HashMap<Pattern, String>(patternStringSet.size());
        for (String patternString : patternStringSet.keySet()) {
            String patternVal = patternStringSet.get(patternString);
            if (!StringUtils.startsWith((String)patternString, (String)"^")) {
                patternString = "^" + patternString;
            }
            target.put(Pattern.compile(patternString), patternVal);
        }
        return target;
    }

    public boolean isKnownVendor(ZipMetadata archive, String pkg) {
        for (Pattern cbl : this.knownPackages.keySet()) {
            if (!cbl.matcher(pkg).find()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found known package: " + pkg + " matching: " + cbl.pattern());
            }
            String vendor = this.knownPackages.get(cbl);
            VendorResult vr = new VendorResult();
            vr.setDescription(vendor);
            archive.getDecorations().add(vr);
            return true;
        }
        return false;
    }

    public boolean isExclusivelyKnownArchive(ZipMetadata archive) {
        String extension = archive.getFilePointer().getAbsolutePath();
        if (!StringUtils.equalsIgnoreCase((String)(extension = StringUtils.substringAfterLast((String)extension, (String)".")), (String)"jar")) {
            return false;
        }
        VendorResult vr = null;
        boolean exclusivelyKnown = false;
        Enumeration<? extends ZipEntry> e = archive.getZipFile().entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String entryName = this.getClassNameFromFile(entry.getName());
            if (!exclusivelyKnown) {
                for (Pattern cbl : this.knownPackages.keySet()) {
                    if (!cbl.matcher(entryName).find()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found known package: " + entry.getName() + " matching: " + cbl.pattern());
                    }
                    String vendor = this.knownPackages.get(cbl);
                    LOG.debug("Known Package: " + archive.getName() + "; Vendor: " + vendor);
                    exclusivelyKnown = true;
                    vr = new VendorResult();
                    vr.setDescription(vendor);
                    break;
                }
            }
            if (!this.customerPackageResolver.isCustomerPkg(entryName)) continue;
            return false;
        }
        if (exclusivelyKnown && vr != null) {
            archive.getDecorations().add(vr);
        }
        return exclusivelyKnown;
    }

    protected String getClassNameFromFile(String entryName) {
        String className = StringUtils.replace((String)entryName, (String)"\\", (String)"/");
        className = StringUtils.removeStart((String)className, (String)"/");
        className = StringUtils.replace((String)className, (String)"/", (String)".");
        if (StringUtils.contains((String)(className = StringUtils.substringBefore((String)className, (String)"$")), (String)"WEB-INF.classes.")) {
            className = StringUtils.substringAfter((String)className, (String)"WEB-INF.classes.");
        }
        if (StringUtils.contains((String)className, (String)"META-INF.classes.")) {
            className = StringUtils.substringAfter((String)className, (String)"META-INF.classes.");
        }
        return className;
    }
}

