/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.expression;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public final class ExpressionUtils {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final Log logger = LogFactory.getLog(ExpressionUtils.class);

    private ExpressionUtils() {
    }

    public static StandardEvaluationContext createStandardEvaluationContext() {
        return (StandardEvaluationContext)ExpressionUtils.doCreateContext(null, false);
    }

    public static SimpleEvaluationContext createSimpleEvaluationContext() {
        return (SimpleEvaluationContext)ExpressionUtils.doCreateContext(null, true);
    }

    public static StandardEvaluationContext createStandardEvaluationContext(BeanFactory beanFactory) {
        if (beanFactory == null) {
            logger.warn((Object)"Creating EvaluationContext with no beanFactory", (Throwable)new RuntimeException("No beanFactory"));
        }
        return (StandardEvaluationContext)ExpressionUtils.doCreateContext(beanFactory, false);
    }

    public static SimpleEvaluationContext createSimpleEvaluationContext(BeanFactory beanFactory) {
        if (beanFactory == null) {
            logger.warn((Object)"Creating EvaluationContext with no beanFactory", (Throwable)new RuntimeException("No beanFactory"));
        }
        return (SimpleEvaluationContext)ExpressionUtils.doCreateContext(beanFactory, true);
    }

    private static EvaluationContext doCreateContext(BeanFactory beanFactory, boolean simple) {
        ConversionService conversionService = null;
        SimpleEvaluationContext evaluationContext = null;
        if (beanFactory != null) {
            Object object = evaluationContext = simple ? IntegrationContextUtils.getSimpleEvaluationContext(beanFactory) : IntegrationContextUtils.getEvaluationContext(beanFactory);
        }
        if (evaluationContext == null) {
            if (beanFactory != null) {
                conversionService = IntegrationUtils.getConversionService(beanFactory);
            }
            evaluationContext = ExpressionUtils.createEvaluationContext(conversionService, beanFactory, simple);
        }
        return evaluationContext;
    }

    private static EvaluationContext createEvaluationContext(ConversionService conversionService, BeanFactory beanFactory, boolean simple) {
        if (simple) {
            SimpleEvaluationContext.Builder ecBuilder = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{new MapAccessor(), DataBindingPropertyAccessor.forReadOnlyAccess()}).withInstanceMethods();
            if (conversionService != null) {
                ecBuilder.withConversionService(conversionService);
            }
            return ecBuilder.build();
        }
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        if (conversionService != null) {
            evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        if (beanFactory != null) {
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        return evaluationContext;
    }

    public static File expressionToFile(Expression expression, EvaluationContext evaluationContext, @Nullable Message<?> message, String name) {
        File file;
        Object value;
        Object object = value = message == null ? expression.getValue(evaluationContext) : expression.getValue(evaluationContext, message);
        if (value == null) {
            throw new IllegalStateException(String.format("The provided %s expression (%s) must not evaluate to null.", name, expression.getExpressionString()));
        }
        if (value instanceof File) {
            file = (File)value;
        } else if (value instanceof String) {
            String path = (String)value;
            Assert.hasText((String)path, (String)String.format("Unable to resolve %s for the provided Expression '%s'.", name, expression.getExpressionString()));
            file = new File(path);
        } else {
            throw new IllegalStateException(String.format("The provided %s expression (%s) must evaluate to type java.io.File or String, not %s.", name, expression.getExpressionString(), value.getClass().getName()));
        }
        return file;
    }

    public static Expression intExpression(String expression) {
        try {
            return new ValueExpression<Integer>(Integer.parseInt(expression));
        }
        catch (NumberFormatException numberFormatException) {
            return EXPRESSION_PARSER.parseExpression(expression);
        }
    }

    public static Expression longExpression(String expression) {
        try {
            return new ValueExpression<Long>(Long.parseLong(expression));
        }
        catch (NumberFormatException numberFormatException) {
            return EXPRESSION_PARSER.parseExpression(expression);
        }
    }
}

