# Violations

The analyzer rule engine creates a _Violation_ for every rule that matches except for rules that create tags. A _Violation_ provides details about a match. It also contains information inherited from the rule itself.

### Violation Fields

* **description**: Text description about the match. 

* **category**: Pre-defined category string that indicates impact / severity of the problem. It can be either one of following values:
  * **mandatory**: Indicates a problem that rule author deemed as a blocker for modernization efforts and must be addressed.
  * **optional**: Indicates a problem that rule author doesn't consider a blocker and can be fixed later.
  * **potential**: Indicates a problem that rule author cannot certainly tell if it affects modernization efforts.

* **labels**: A list of string labels inherited from rules. These are useful in filtering / identifying violations.

* **links**: A list of hyperlinks provided by the rule author. Each item in the list is a struct with following fields:
  * **url**: URL string.
  * **title**: Title string.

* **incidents**: A list of incident structs that each give detailed information about the match.
  * **uri**: File uri in the source code where the rule was matched.
  * **message**: A string that provides more information about the incident.
  * **codeSnip**: Relevant lines from the source code where the rule was matched.
  * **variables**: Raw structured information about the match generated by a provider.

* **effort**: Integer value indicating story points for each incident as determined by the rule author.

See [Violation struct](../output/v1/konveyor/violations.go) for more details.

### Output Structure

The overall output of an analysis run is organized by Rulesets. It is a list of Rulesets with each item containing a map of Violations that maps RuleID with its respective generated violation. See following example output generated when using 2 Rulesets as input to the analyzer:

```yaml
- name: ruleset-00
  tags:
  - License=Apache
  violations:
    chain-pom-001:
      description: ""
      category: potential
      effort: 3
      incidents:
      - uri: file:///analyzer-lsp/examples/customers-tomcat-legacy/pom.xml
        message: "Found expected content in pom"
        variables:
          data: dependency
          innerText: "\n\t\t\t\tcom.fasterxml.jackson\n\t\t\t\tjackson-bom\n\t\t\t\t${jackson.version}\n\t\t\t\timport\n\t\t\t\tpom\n\t\t\t"
          matchingXML: <groupId>com.fasterxml.jackson</groupId><artifactId>jackson-bom</artifactId><version>${jackson.version}</version><scope>import</scope><type>pom</type>
- name: ruleset-01
  tags:
  - License=Apache
  violations:
    chain-pom-001:
      description: ""
      category: potential
      effort: 3
      incidents:
      - uri: file:///analyzer-lsp/examples/customers-tomcat-legacy/pom.xml
        message: "Found expected content in pom"
        variables:
          data: dependency
          innerText: "\n\t\t\t\tcom.fasterxml.jackson\n\t\t\t\tjackson-bom\n\t\t\t\t${jackson.version}\n\t\t\t\timport\n\t\t\t\tpom\n\t\t\t"
          matchingXML: <groupId>com.fasterxml.jackson</groupId><artifactId>jackson-bom</artifactId><version>${jackson.version}</version><scope>import</scope><type>pom</type>
```

