// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.18.1
// source: google/cloud/paymentgateway/issuerswitch/v1/common_fields.proto

package issuerswitch

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The API type for a transaction. Every transaction processed by the issuer
// switch will be one of these API types.
type ApiType int32

const (
	// Unspecified API type.
	ApiType_API_TYPE_UNSPECIFIED ApiType = 0
	// Balance API. Maps to UPI's `BalEnq` API. This is a metadata
	// transaction API.
	ApiType_BALANCE ApiType = 1
	// Check transaction status API. Maps to UPI's `ChkTxn` API. This is a
	// metadata transaction API.
	ApiType_CHECK_STATUS ApiType = 2
	// Complaint API. Maps to UPI's `Complaint` API. This is a dispute and issue
	// resolution API.
	ApiType_COMPLAINT ApiType = 3
	// Heart beat API. Maps to UPI's `Hbt` API. This is a metadata transaction
	// API.
	ApiType_HEART_BEAT ApiType = 4
	// Initiate registration API. Maps to UPI's `Otp` API. This is a metadata
	// transaction API.
	ApiType_INITIATE_REGISTRATION ApiType = 5
	// List accounts API. Maps to UPI's `ListAccount` API. This is a metadata
	// transaction API.
	ApiType_LIST_ACCOUNTS ApiType = 6
	// Mandate API. Maps to UPI's `Mandate` API. This is a metadata transaction
	// API.
	ApiType_MANDATE ApiType = 7
	// Mandate confirmation API. Maps to UPI's `MandateConfirmation` API. This is
	// a metadata transaction API.
	ApiType_MANDATE_CONFIRMATION ApiType = 8
	// Payment settlement API. Maps to UPI's `Pay` API. This is a financial
	// transaction API.
	ApiType_SETTLE_PAYMENT ApiType = 9
	// Update credentials API. Maps to UPI's `SetCre` API. This is a metadata
	// transaction API.
	ApiType_UPDATE_CREDENTIALS ApiType = 10
	// Validate registration API. Maps to UPI's `RegMob` API. This is a metadata
	// transaction API.
	ApiType_VALIDATE_REGISTRATION ApiType = 11
	// Validate customer API. Maps to UPI's `ValCust` API. This is a validation
	// API.
	ApiType_VALIDATE_CUSTOMER ApiType = 12
	// Voucher API. Maps to UPI's `Voucher` API.
	ApiType_VOUCHER ApiType = 13
	// Voucher confirmation API. Maps to UPI's `VoucherConfirmation` API.
	ApiType_VOUCHER_CONFIRMATION ApiType = 14
)

// Enum value maps for ApiType.
var (
	ApiType_name = map[int32]string{
		0:  "API_TYPE_UNSPECIFIED",
		1:  "BALANCE",
		2:  "CHECK_STATUS",
		3:  "COMPLAINT",
		4:  "HEART_BEAT",
		5:  "INITIATE_REGISTRATION",
		6:  "LIST_ACCOUNTS",
		7:  "MANDATE",
		8:  "MANDATE_CONFIRMATION",
		9:  "SETTLE_PAYMENT",
		10: "UPDATE_CREDENTIALS",
		11: "VALIDATE_REGISTRATION",
		12: "VALIDATE_CUSTOMER",
		13: "VOUCHER",
		14: "VOUCHER_CONFIRMATION",
	}
	ApiType_value = map[string]int32{
		"API_TYPE_UNSPECIFIED":  0,
		"BALANCE":               1,
		"CHECK_STATUS":          2,
		"COMPLAINT":             3,
		"HEART_BEAT":            4,
		"INITIATE_REGISTRATION": 5,
		"LIST_ACCOUNTS":         6,
		"MANDATE":               7,
		"MANDATE_CONFIRMATION":  8,
		"SETTLE_PAYMENT":        9,
		"UPDATE_CREDENTIALS":    10,
		"VALIDATE_REGISTRATION": 11,
		"VALIDATE_CUSTOMER":     12,
		"VOUCHER":               13,
		"VOUCHER_CONFIRMATION":  14,
	}
)

func (x ApiType) Enum() *ApiType {
	p := new(ApiType)
	*p = x
	return p
}

func (x ApiType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApiType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[0].Descriptor()
}

func (ApiType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[0]
}

func (x ApiType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApiType.Descriptor instead.
func (ApiType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{0}
}

// The type of a transaction. Every transaction processed by the issuer switch
// will be one of these transaction types. Transaction types are associated with
// a particular API type. This associated is documented with each value.
type TransactionType int32

const (
	// Unspecified transaction type.
	TransactionType_TRANSACTION_TYPE_UNSPECIFIED TransactionType = 0
	// Autoupdate transaction type. This is associated with the `CHECK_STATUS`
	// API type. Maps to UPI's `AUTOUPDATE` type.
	TransactionType_TRANSACTION_TYPE_AUTOUPDATE TransactionType = 1
	// Balance check transaction type. This is associated with the
	// `BALANCE_ENQUIRY` API type. Maps to UPI's `BalChk` type.
	TransactionType_TRANSACTION_TYPE_BALANCE_CHECK TransactionType = 2
	// Balance enquiry transaction type. This is associated with the
	// `BALANCE_ENQUIRY` API type. Maps to UPI's `BalEnq` type.
	TransactionType_TRANSACTION_TYPE_BALANCE_ENQUIRY TransactionType = 3
	// Check status transaction type. This is associated with the `COMPLAINT` API
	// type. Maps to UPI's `CHECKSTATUS` type.
	TransactionType_TRANSACTION_TYPE_CHECK_STATUS TransactionType = 4
	// Check transaction type. This is associated with the `CHECK_STATUS` API
	// type. Maps to UPI's `ChkTxn` type.
	TransactionType_TRANSACTION_TYPE_CHECK_TRANSACTION TransactionType = 5
	// Complaint transaction type. This is associated with the `COMPLAINT` API
	// type. Maps to UPI's `COMPLAINT` type.
	TransactionType_TRANSACTION_TYPE_COMPLAINT TransactionType = 6
	// Create transaction type. This is associated with the `MANDATE` API type.
	// Maps to UPI's `CREATE` type.
	TransactionType_TRANSACTION_TYPE_CREATE TransactionType = 7
	// Credit transaction type. This is associated with the `SETTLE_PAYMENT` API
	// type. Maps to UPI's `CREDIT` type.
	TransactionType_TRANSACTION_TYPE_CREDIT TransactionType = 8
	// Debit transaction type. This is associated with the `SETTLE_PAYMENT` API
	// type. Maps to UPI's `DEBIT` type.
	TransactionType_TRANSACTION_TYPE_DEBIT TransactionType = 9
	// Dispute transaction type. This is associated with the `COMPLAINT` API
	// type. Maps to UPI's `DISPUTE` type.
	TransactionType_TRANSACTION_TYPE_DISPUTE TransactionType = 10
	// Heart beat transaction type. This is associated with `HEART_BEAT` API type.
	// Maps to UPI's `Hbt` type.
	TransactionType_TRANSACTION_TYPE_HEART_BEAT TransactionType = 11
	// List accounts transaction type. This is associated with `LIST_ACCOUNTS` API
	// type. Maps to UPI's `ListAccount` type.
	TransactionType_TRANSACTION_TYPE_LIST_ACCOUNTS TransactionType = 12
	// Mandate notification transaction type. This is associated with the
	// `VALIDATE_CUSTOMER` API type. Maps to UPI's `MandateNotification` type.
	TransactionType_TRANSACTION_TYPE_MANDATE_NOTIFICATION TransactionType = 13
	// OTP transaction type. This is associated with the `INITIATE_REGISTRATION`
	// API type. Maps to UPI's `Otp` type.
	TransactionType_TRANSACTION_TYPE_OTP TransactionType = 14
	// Pause transaction type. This is associated with the `MANDATE` API type.
	// Maps to UPI's `PAUSE` type.
	TransactionType_TRANSACTION_TYPE_PAUSE TransactionType = 15
	// Redeem transaction type. This is associated with the `VOUCHER_CONFIRMATION`
	// API type. Maps to UPI's `REDEEM` type.
	TransactionType_TRANSACTION_TYPE_REDEEM TransactionType = 16
	// Refund transaction type. This is associated with the `COMPLAINT` API
	// type. Maps to UPI's `REFUND` type.
	TransactionType_TRANSACTION_TYPE_REFUND TransactionType = 17
	// Register mobile transaction type. This is associated with the
	// `VALIDATE_REGISTRATION` API type. Maps to UPI's `RegMob` type.
	TransactionType_TRANSACTION_TYPE_REGISTER_MOBILE TransactionType = 18
	// Reversal transaction type. This is associated with the `SETTLE_PAYMENT` and
	// `COMPLAINT` API types. Maps to UPI's `REVERSAL` type.
	TransactionType_TRANSACTION_TYPE_REVERSAL TransactionType = 19
	// Revoke transaction type. This is associated with the `MANDATE` API type.
	// Maps to UPI's `REVOKE` type.
	TransactionType_TRANSACTION_TYPE_REVOKE TransactionType = 20
	// Status update transaction type. This is associated with the `COMPLAINT` API
	// type. Maps to UPI's `STATUSUPDATE` type.
	TransactionType_TRANSACTION_TYPE_STATUS_UPDATE TransactionType = 21
	// Update transaction type. This is associated with the `MANDATE` API type.
	// Maps to UPI's `UNPAUSE` type.
	TransactionType_TRANSACTION_TYPE_UNPAUSE TransactionType = 22
	// Update transaction type. This is associated with the `MANDATE` API type.
	// Maps to UPI's `UPDATE` type.
	TransactionType_TRANSACTION_TYPE_UPDATE TransactionType = 23
	// Update credentials transaction type. This is associated with
	// `UPDATE_CREDENTIALS` API type. Maps to UPI's `SetCre` type.
	TransactionType_TRANSACTION_TYPE_UPDATE_CREDENTIALS TransactionType = 24
	// Validate customer transaction type. This is associated with
	// `VALIDATE_CUSTOMER` API type. Maps to UPI's `ValCust` type.
	TransactionType_TRANSACTION_TYPE_VALIDATE_CUSTOMER TransactionType = 25
)

// Enum value maps for TransactionType.
var (
	TransactionType_name = map[int32]string{
		0:  "TRANSACTION_TYPE_UNSPECIFIED",
		1:  "TRANSACTION_TYPE_AUTOUPDATE",
		2:  "TRANSACTION_TYPE_BALANCE_CHECK",
		3:  "TRANSACTION_TYPE_BALANCE_ENQUIRY",
		4:  "TRANSACTION_TYPE_CHECK_STATUS",
		5:  "TRANSACTION_TYPE_CHECK_TRANSACTION",
		6:  "TRANSACTION_TYPE_COMPLAINT",
		7:  "TRANSACTION_TYPE_CREATE",
		8:  "TRANSACTION_TYPE_CREDIT",
		9:  "TRANSACTION_TYPE_DEBIT",
		10: "TRANSACTION_TYPE_DISPUTE",
		11: "TRANSACTION_TYPE_HEART_BEAT",
		12: "TRANSACTION_TYPE_LIST_ACCOUNTS",
		13: "TRANSACTION_TYPE_MANDATE_NOTIFICATION",
		14: "TRANSACTION_TYPE_OTP",
		15: "TRANSACTION_TYPE_PAUSE",
		16: "TRANSACTION_TYPE_REDEEM",
		17: "TRANSACTION_TYPE_REFUND",
		18: "TRANSACTION_TYPE_REGISTER_MOBILE",
		19: "TRANSACTION_TYPE_REVERSAL",
		20: "TRANSACTION_TYPE_REVOKE",
		21: "TRANSACTION_TYPE_STATUS_UPDATE",
		22: "TRANSACTION_TYPE_UNPAUSE",
		23: "TRANSACTION_TYPE_UPDATE",
		24: "TRANSACTION_TYPE_UPDATE_CREDENTIALS",
		25: "TRANSACTION_TYPE_VALIDATE_CUSTOMER",
	}
	TransactionType_value = map[string]int32{
		"TRANSACTION_TYPE_UNSPECIFIED":          0,
		"TRANSACTION_TYPE_AUTOUPDATE":           1,
		"TRANSACTION_TYPE_BALANCE_CHECK":        2,
		"TRANSACTION_TYPE_BALANCE_ENQUIRY":      3,
		"TRANSACTION_TYPE_CHECK_STATUS":         4,
		"TRANSACTION_TYPE_CHECK_TRANSACTION":    5,
		"TRANSACTION_TYPE_COMPLAINT":            6,
		"TRANSACTION_TYPE_CREATE":               7,
		"TRANSACTION_TYPE_CREDIT":               8,
		"TRANSACTION_TYPE_DEBIT":                9,
		"TRANSACTION_TYPE_DISPUTE":              10,
		"TRANSACTION_TYPE_HEART_BEAT":           11,
		"TRANSACTION_TYPE_LIST_ACCOUNTS":        12,
		"TRANSACTION_TYPE_MANDATE_NOTIFICATION": 13,
		"TRANSACTION_TYPE_OTP":                  14,
		"TRANSACTION_TYPE_PAUSE":                15,
		"TRANSACTION_TYPE_REDEEM":               16,
		"TRANSACTION_TYPE_REFUND":               17,
		"TRANSACTION_TYPE_REGISTER_MOBILE":      18,
		"TRANSACTION_TYPE_REVERSAL":             19,
		"TRANSACTION_TYPE_REVOKE":               20,
		"TRANSACTION_TYPE_STATUS_UPDATE":        21,
		"TRANSACTION_TYPE_UNPAUSE":              22,
		"TRANSACTION_TYPE_UPDATE":               23,
		"TRANSACTION_TYPE_UPDATE_CREDENTIALS":   24,
		"TRANSACTION_TYPE_VALIDATE_CUSTOMER":    25,
	}
)

func (x TransactionType) Enum() *TransactionType {
	p := new(TransactionType)
	*p = x
	return p
}

func (x TransactionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[1].Descriptor()
}

func (TransactionType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[1]
}

func (x TransactionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionType.Descriptor instead.
func (TransactionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{1}
}

// XmlApiType specifies the API type of the request or response as specified in
// the XML payload.
type XmlApiType int32

const (
	// Unspecified API type.
	XmlApiType_XML_API_TYPE_UNSPECIFIED XmlApiType = 0
	// Balance enquiry request API type. Maps to UPI's `ReqBalEnq` API.
	XmlApiType_REQ_BAL_ENQ XmlApiType = 1
	// Check transaction request API type. Maps to UPI's `ReqChkTxn` API.
	XmlApiType_REQ_CHK_TXN XmlApiType = 2
	// Complaint request API type. Maps to UPI's `ReqComplaint` API.
	XmlApiType_REQ_COMPLAINT XmlApiType = 3
	// Heart beat request API type. Maps to UPI's `ReqHbt` API.
	XmlApiType_REQ_HBT XmlApiType = 4
	// List accounts request API type. Maps to UPI's `ReqListAccount` API.
	XmlApiType_REQ_LIST_ACCOUNT XmlApiType = 5
	// Mandate request  API. Maps to UPI's `ReqMandate` API.
	XmlApiType_REQ_MANDATE XmlApiType = 6
	// Mandate confirmation request API type. Maps to UPI's
	// `ReqMandateConfirmation` API.
	XmlApiType_REQ_MANDATE_CONFIRMATION XmlApiType = 7
	// OTP request API. Maps to UPI's `ReqOtp` API.
	XmlApiType_REQ_OTP XmlApiType = 8
	// Payment settlement request API type. Maps to UPI's `ReqPay` API.
	XmlApiType_REQ_PAY XmlApiType = 9
	// Register mobile request API type. Maps to UPI's `ReqRegMob` API.
	XmlApiType_REQ_REG_MOB XmlApiType = 10
	// Update credentials request API type. Maps to UPI's `ReqSetCre` API.
	XmlApiType_REQ_SET_CRE XmlApiType = 11
	// Validate customer request API type. Maps to UPI's `ReqValCust`.
	XmlApiType_REQ_VAL_CUST XmlApiType = 12
	// Create voucher request API type. Maps to UPI's `ReqVoucher`.
	XmlApiType_REQ_VOUCHER XmlApiType = 13
	// Voucher confirmation request API type. Maps to UPI's
	// `ReqVoucherConfirmation` API.
	XmlApiType_REQ_VOUCHER_CONFIRMATION XmlApiType = 14
	// Transaction confirmation request API type. Maps to UPI's
	// `ReqTxnConfirmation` API.
	XmlApiType_REQ_TXN_CONFIRMATION XmlApiType = 15
	// Balance enquiry response API type. Maps to UPI's `RespBalEnq` API.
	XmlApiType_RESP_BAL_ENQ XmlApiType = 16
	// Check transaction response API type. Maps to UPI's `RespChkTxn` API.
	XmlApiType_RESP_CHK_TXN XmlApiType = 17
	// Complaint response API type. Maps to UPI's `RespComplaint` API.
	XmlApiType_RESP_COMPLAINT XmlApiType = 18
	// Heart beat response API type. Maps to UPI's `RespHbt` API.
	XmlApiType_RESP_HBT XmlApiType = 19
	// List accounts response API type. Maps to UPI's `RespListAccount` API.
	XmlApiType_RESP_LIST_ACCOUNT XmlApiType = 20
	// Mandate response API type. Maps to UPI's `RespMandate` API.
	XmlApiType_RESP_MANDATE XmlApiType = 21
	// Mandate confirmation response API type. Maps to UPI's
	// `RespMandateConfirmation` API.
	XmlApiType_RESP_MANDATE_CONFIRMATION XmlApiType = 22
	// OTP response API. Maps to UPI's `RespOtp` API.
	XmlApiType_RESP_OTP XmlApiType = 23
	// Payment settlement response API type. Maps to UPI's `RespPay` API.
	XmlApiType_RESP_PAY XmlApiType = 24
	// Register mobile response API type. Maps to UPI's `RespRegMob` API.
	XmlApiType_RESP_REG_MOB XmlApiType = 25
	// Update credentials response API type. Maps to UPI's `RespSetCre` API.
	XmlApiType_RESP_SET_CRE XmlApiType = 26
	// Validate customer response API type. Maps to UPI's `RespValCust`.
	XmlApiType_RESP_VAL_CUST XmlApiType = 27
	// Create voucher response API type. Maps to UPI's `RespVoucher`.
	XmlApiType_RESP_VOUCHER XmlApiType = 28
	// Voucher confirmation responseAPI type. Maps to UPI's
	// `RespVoucherConfirmation` API.
	XmlApiType_RESP_VOUCHER_CONFIRMATION XmlApiType = 29
	// Transaction confirmation response API type. Maps to UPI's
	// `RespTxnConfirmation` API.
	XmlApiType_RESP_TXN_CONFIRMATION XmlApiType = 30
)

// Enum value maps for XmlApiType.
var (
	XmlApiType_name = map[int32]string{
		0:  "XML_API_TYPE_UNSPECIFIED",
		1:  "REQ_BAL_ENQ",
		2:  "REQ_CHK_TXN",
		3:  "REQ_COMPLAINT",
		4:  "REQ_HBT",
		5:  "REQ_LIST_ACCOUNT",
		6:  "REQ_MANDATE",
		7:  "REQ_MANDATE_CONFIRMATION",
		8:  "REQ_OTP",
		9:  "REQ_PAY",
		10: "REQ_REG_MOB",
		11: "REQ_SET_CRE",
		12: "REQ_VAL_CUST",
		13: "REQ_VOUCHER",
		14: "REQ_VOUCHER_CONFIRMATION",
		15: "REQ_TXN_CONFIRMATION",
		16: "RESP_BAL_ENQ",
		17: "RESP_CHK_TXN",
		18: "RESP_COMPLAINT",
		19: "RESP_HBT",
		20: "RESP_LIST_ACCOUNT",
		21: "RESP_MANDATE",
		22: "RESP_MANDATE_CONFIRMATION",
		23: "RESP_OTP",
		24: "RESP_PAY",
		25: "RESP_REG_MOB",
		26: "RESP_SET_CRE",
		27: "RESP_VAL_CUST",
		28: "RESP_VOUCHER",
		29: "RESP_VOUCHER_CONFIRMATION",
		30: "RESP_TXN_CONFIRMATION",
	}
	XmlApiType_value = map[string]int32{
		"XML_API_TYPE_UNSPECIFIED":  0,
		"REQ_BAL_ENQ":               1,
		"REQ_CHK_TXN":               2,
		"REQ_COMPLAINT":             3,
		"REQ_HBT":                   4,
		"REQ_LIST_ACCOUNT":          5,
		"REQ_MANDATE":               6,
		"REQ_MANDATE_CONFIRMATION":  7,
		"REQ_OTP":                   8,
		"REQ_PAY":                   9,
		"REQ_REG_MOB":               10,
		"REQ_SET_CRE":               11,
		"REQ_VAL_CUST":              12,
		"REQ_VOUCHER":               13,
		"REQ_VOUCHER_CONFIRMATION":  14,
		"REQ_TXN_CONFIRMATION":      15,
		"RESP_BAL_ENQ":              16,
		"RESP_CHK_TXN":              17,
		"RESP_COMPLAINT":            18,
		"RESP_HBT":                  19,
		"RESP_LIST_ACCOUNT":         20,
		"RESP_MANDATE":              21,
		"RESP_MANDATE_CONFIRMATION": 22,
		"RESP_OTP":                  23,
		"RESP_PAY":                  24,
		"RESP_REG_MOB":              25,
		"RESP_SET_CRE":              26,
		"RESP_VAL_CUST":             27,
		"RESP_VOUCHER":              28,
		"RESP_VOUCHER_CONFIRMATION": 29,
		"RESP_TXN_CONFIRMATION":     30,
	}
)

func (x XmlApiType) Enum() *XmlApiType {
	p := new(XmlApiType)
	*p = x
	return p
}

func (x XmlApiType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XmlApiType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[2].Descriptor()
}

func (XmlApiType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[2]
}

func (x XmlApiType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XmlApiType.Descriptor instead.
func (XmlApiType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{2}
}

// The type of the participant.
type Participant_Persona int32

const (
	// Unspecified persona.
	Participant_PERSONA_UNSPECIFIED Participant_Persona = 0
	// Participant is an entity.
	Participant_ENTITY Participant_Persona = 1
	// Participant is a person.
	Participant_PERSON Participant_Persona = 2
)

// Enum value maps for Participant_Persona.
var (
	Participant_Persona_name = map[int32]string{
		0: "PERSONA_UNSPECIFIED",
		1: "ENTITY",
		2: "PERSON",
	}
	Participant_Persona_value = map[string]int32{
		"PERSONA_UNSPECIFIED": 0,
		"ENTITY":              1,
		"PERSON":              2,
	}
)

func (x Participant_Persona) Enum() *Participant_Persona {
	p := new(Participant_Persona)
	*p = x
	return p
}

func (x Participant_Persona) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Participant_Persona) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[3].Descriptor()
}

func (Participant_Persona) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[3]
}

func (x Participant_Persona) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Participant_Persona.Descriptor instead.
func (Participant_Persona) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{2, 0}
}

// Indicates the merchant's type as a small or large merchant.
type MerchantAdditionalInfo_Type int32

const (
	// Unspecified merchant type.
	MerchantAdditionalInfo_TYPE_UNSPECIFIED MerchantAdditionalInfo_Type = 0
	// Large merchant.
	MerchantAdditionalInfo_LARGE MerchantAdditionalInfo_Type = 1
	// Small merchant.
	MerchantAdditionalInfo_SMALL MerchantAdditionalInfo_Type = 2
)

// Enum value maps for MerchantAdditionalInfo_Type.
var (
	MerchantAdditionalInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LARGE",
		2: "SMALL",
	}
	MerchantAdditionalInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LARGE":            1,
		"SMALL":            2,
	}
)

func (x MerchantAdditionalInfo_Type) Enum() *MerchantAdditionalInfo_Type {
	p := new(MerchantAdditionalInfo_Type)
	*p = x
	return p
}

func (x MerchantAdditionalInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantAdditionalInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[4].Descriptor()
}

func (MerchantAdditionalInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[4]
}

func (x MerchantAdditionalInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantAdditionalInfo_Type.Descriptor instead.
func (MerchantAdditionalInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{5, 0}
}

// Indicates whether the merchant is an online or offline merchant.
type MerchantAdditionalInfo_Genre int32

const (
	// Unspecified merchant genre.
	MerchantAdditionalInfo_GENRE_UNSPECIFIED MerchantAdditionalInfo_Genre = 0
	// Offline merchant
	MerchantAdditionalInfo_OFFLINE MerchantAdditionalInfo_Genre = 1
	// Online merchant.
	MerchantAdditionalInfo_ONLINE MerchantAdditionalInfo_Genre = 2
)

// Enum value maps for MerchantAdditionalInfo_Genre.
var (
	MerchantAdditionalInfo_Genre_name = map[int32]string{
		0: "GENRE_UNSPECIFIED",
		1: "OFFLINE",
		2: "ONLINE",
	}
	MerchantAdditionalInfo_Genre_value = map[string]int32{
		"GENRE_UNSPECIFIED": 0,
		"OFFLINE":           1,
		"ONLINE":            2,
	}
)

func (x MerchantAdditionalInfo_Genre) Enum() *MerchantAdditionalInfo_Genre {
	p := new(MerchantAdditionalInfo_Genre)
	*p = x
	return p
}

func (x MerchantAdditionalInfo_Genre) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantAdditionalInfo_Genre) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[5].Descriptor()
}

func (MerchantAdditionalInfo_Genre) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[5]
}

func (x MerchantAdditionalInfo_Genre) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantAdditionalInfo_Genre.Descriptor instead.
func (MerchantAdditionalInfo_Genre) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{5, 1}
}

// Indicates whether the merchant has been onboarded by a bank or an
// aggregator.
type MerchantAdditionalInfo_OnboardingType int32

const (
	// Unspecified merchant onboarding type.
	MerchantAdditionalInfo_ONBOARDING_TYPE_UNSPECIFIED MerchantAdditionalInfo_OnboardingType = 0
	// Onboarded by aggreagator.
	MerchantAdditionalInfo_AGGREGATOR MerchantAdditionalInfo_OnboardingType = 1
	// Onboarded by bank.
	MerchantAdditionalInfo_BANK MerchantAdditionalInfo_OnboardingType = 2
	// Onboarded by the UPI network.
	MerchantAdditionalInfo_NETWORK MerchantAdditionalInfo_OnboardingType = 3
	// Onboarded by the TPAP.
	MerchantAdditionalInfo_TPAP MerchantAdditionalInfo_OnboardingType = 4
)

// Enum value maps for MerchantAdditionalInfo_OnboardingType.
var (
	MerchantAdditionalInfo_OnboardingType_name = map[int32]string{
		0: "ONBOARDING_TYPE_UNSPECIFIED",
		1: "AGGREGATOR",
		2: "BANK",
		3: "NETWORK",
		4: "TPAP",
	}
	MerchantAdditionalInfo_OnboardingType_value = map[string]int32{
		"ONBOARDING_TYPE_UNSPECIFIED": 0,
		"AGGREGATOR":                  1,
		"BANK":                        2,
		"NETWORK":                     3,
		"TPAP":                        4,
	}
)

func (x MerchantAdditionalInfo_OnboardingType) Enum() *MerchantAdditionalInfo_OnboardingType {
	p := new(MerchantAdditionalInfo_OnboardingType)
	*p = x
	return p
}

func (x MerchantAdditionalInfo_OnboardingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantAdditionalInfo_OnboardingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[6].Descriptor()
}

func (MerchantAdditionalInfo_OnboardingType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[6]
}

func (x MerchantAdditionalInfo_OnboardingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantAdditionalInfo_OnboardingType.Descriptor instead.
func (MerchantAdditionalInfo_OnboardingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{5, 2}
}

// Indicates the ownership type of the merchant.
type MerchantAdditionalInfo_OwnershipType int32

const (
	// Unspecified merchant ownership type.
	MerchantAdditionalInfo_OWNERSHIP_TYPE_UNSPECIFIED MerchantAdditionalInfo_OwnershipType = 0
	// Properietary ownership.
	MerchantAdditionalInfo_PROPRIETARY MerchantAdditionalInfo_OwnershipType = 1
	// Partnership ownership.
	MerchantAdditionalInfo_PARTNERSHIP MerchantAdditionalInfo_OwnershipType = 2
	// Public ownership.
	MerchantAdditionalInfo_PUBLIC MerchantAdditionalInfo_OwnershipType = 3
	// Private ownership.
	MerchantAdditionalInfo_PRIVATE MerchantAdditionalInfo_OwnershipType = 4
	// Other ownership model.
	MerchantAdditionalInfo_OTHERS MerchantAdditionalInfo_OwnershipType = 5
)

// Enum value maps for MerchantAdditionalInfo_OwnershipType.
var (
	MerchantAdditionalInfo_OwnershipType_name = map[int32]string{
		0: "OWNERSHIP_TYPE_UNSPECIFIED",
		1: "PROPRIETARY",
		2: "PARTNERSHIP",
		3: "PUBLIC",
		4: "PRIVATE",
		5: "OTHERS",
	}
	MerchantAdditionalInfo_OwnershipType_value = map[string]int32{
		"OWNERSHIP_TYPE_UNSPECIFIED": 0,
		"PROPRIETARY":                1,
		"PARTNERSHIP":                2,
		"PUBLIC":                     3,
		"PRIVATE":                    4,
		"OTHERS":                     5,
	}
)

func (x MerchantAdditionalInfo_OwnershipType) Enum() *MerchantAdditionalInfo_OwnershipType {
	p := new(MerchantAdditionalInfo_OwnershipType)
	*p = x
	return p
}

func (x MerchantAdditionalInfo_OwnershipType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MerchantAdditionalInfo_OwnershipType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[7].Descriptor()
}

func (MerchantAdditionalInfo_OwnershipType) Type() protoreflect.EnumType {
	return &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes[7]
}

func (x MerchantAdditionalInfo_OwnershipType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MerchantAdditionalInfo_OwnershipType.Descriptor instead.
func (MerchantAdditionalInfo_OwnershipType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{5, 3}
}

// A reference to uniquely identify an account according to India's UPI
// standards.
type AccountReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IFSC code of a bank's branch.
	IfscCode string `protobuf:"bytes,1,opt,name=ifsc_code,json=ifscCode,proto3" json:"ifsc_code,omitempty"`
	// Type of account. Examples include SAVINGS, CURRENT, etc.
	AccountType string `protobuf:"bytes,2,opt,name=account_type,json=accountType,proto3" json:"account_type,omitempty"`
	// Unique number for an account in a bank and branch.
	AccountNumber string `protobuf:"bytes,3,opt,name=account_number,json=accountNumber,proto3" json:"account_number,omitempty"`
}

func (x *AccountReference) Reset() {
	*x = AccountReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountReference) ProtoMessage() {}

func (x *AccountReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountReference.ProtoReflect.Descriptor instead.
func (*AccountReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{0}
}

func (x *AccountReference) GetIfscCode() string {
	if x != nil {
		return x.IfscCode
	}
	return ""
}

func (x *AccountReference) GetAccountType() string {
	if x != nil {
		return x.AccountType
	}
	return ""
}

func (x *AccountReference) GetAccountNumber() string {
	if x != nil {
		return x.AccountNumber
	}
	return ""
}

// A participant in a payment settlement transaction processed by the issuer
// switch. The participant could either be the payer or the payee in the
// transaction.
type SettlementParticipant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The participant information.
	Participant *Participant `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Unique identification of an account according to India's UPI standards.
	Account *AccountReference `protobuf:"bytes,2,opt,name=account,proto3" json:"account,omitempty"`
	// Information about a merchant who is a participant in the payment. This
	// field will be specified only if the participant is a merchant.
	MerchantInfo *MerchantInfo `protobuf:"bytes,3,opt,name=merchant_info,json=merchantInfo,proto3" json:"merchant_info,omitempty"`
	// Output only. The mobile number of the participant.
	Mobile string `protobuf:"bytes,4,opt,name=mobile,proto3" json:"mobile,omitempty"`
	// Output only. The device id of the participant.
	DeviceId string `protobuf:"bytes,5,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
}

func (x *SettlementParticipant) Reset() {
	*x = SettlementParticipant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettlementParticipant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettlementParticipant) ProtoMessage() {}

func (x *SettlementParticipant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettlementParticipant.ProtoReflect.Descriptor instead.
func (*SettlementParticipant) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{1}
}

func (x *SettlementParticipant) GetParticipant() *Participant {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *SettlementParticipant) GetAccount() *AccountReference {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *SettlementParticipant) GetMerchantInfo() *MerchantInfo {
	if x != nil {
		return x.MerchantInfo
	}
	return nil
}

func (x *SettlementParticipant) GetMobile() string {
	if x != nil {
		return x.Mobile
	}
	return ""
}

func (x *SettlementParticipant) GetDeviceId() string {
	if x != nil {
		return x.DeviceId
	}
	return ""
}

// A participant in a transaction processed by the issuer switch.
type Participant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The virtual payment address (VPA) of the participant.
	VirtualPaymentAddress string `protobuf:"bytes,1,opt,name=virtual_payment_address,json=virtualPaymentAddress,proto3" json:"virtual_payment_address,omitempty"`
	// The persona of the participant.
	Persona Participant_Persona `protobuf:"varint,2,opt,name=persona,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.Participant_Persona" json:"persona,omitempty"`
	// The name of the participant.
	User string `protobuf:"bytes,3,opt,name=user,proto3" json:"user,omitempty"`
}

func (x *Participant) Reset() {
	*x = Participant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Participant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Participant) ProtoMessage() {}

func (x *Participant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Participant.ProtoReflect.Descriptor instead.
func (*Participant) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{2}
}

func (x *Participant) GetVirtualPaymentAddress() string {
	if x != nil {
		return x.VirtualPaymentAddress
	}
	return ""
}

func (x *Participant) GetPersona() Participant_Persona {
	if x != nil {
		return x.Persona
	}
	return Participant_PERSONA_UNSPECIFIED
}

func (x *Participant) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

// A merchant entity participating in a payment settlement transaction.
type MerchantInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the merchant.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the merchant who is a party in the payment. Includes multiple
	// possible names for the merchant.
	Merchant *MerchantName `protobuf:"bytes,2,opt,name=merchant,proto3" json:"merchant,omitempty"`
	// Additional information about the merchant.
	AdditionalInfo *MerchantAdditionalInfo `protobuf:"bytes,3,opt,name=additional_info,json=additionalInfo,proto3" json:"additional_info,omitempty"`
}

func (x *MerchantInfo) Reset() {
	*x = MerchantInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantInfo) ProtoMessage() {}

func (x *MerchantInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantInfo.ProtoReflect.Descriptor instead.
func (*MerchantInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{3}
}

func (x *MerchantInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *MerchantInfo) GetMerchant() *MerchantName {
	if x != nil {
		return x.Merchant
	}
	return nil
}

func (x *MerchantInfo) GetAdditionalInfo() *MerchantAdditionalInfo {
	if x != nil {
		return x.AdditionalInfo
	}
	return nil
}

// The name of a merchant who is a participant in a payment settlement
// transaction. Includes multiple possible names for the merchant.
type MerchantName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The brand name of the merchant.
	Brand string `protobuf:"bytes,1,opt,name=brand,proto3" json:"brand,omitempty"`
	// The merchant's legal name.
	Legal string `protobuf:"bytes,2,opt,name=legal,proto3" json:"legal,omitempty"`
	// The franchise name under which the merchant operates.
	Franchise string `protobuf:"bytes,3,opt,name=franchise,proto3" json:"franchise,omitempty"`
}

func (x *MerchantName) Reset() {
	*x = MerchantName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantName) ProtoMessage() {}

func (x *MerchantName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantName.ProtoReflect.Descriptor instead.
func (*MerchantName) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{4}
}

func (x *MerchantName) GetBrand() string {
	if x != nil {
		return x.Brand
	}
	return ""
}

func (x *MerchantName) GetLegal() string {
	if x != nil {
		return x.Legal
	}
	return ""
}

func (x *MerchantName) GetFranchise() string {
	if x != nil {
		return x.Franchise
	}
	return ""
}

// Additional merchant information specific to India's UPI requirements.
type MerchantAdditionalInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Merchant Category Code (MCC) as specified by UPI. This is a four-digit
	// number listed in ISO 18245 for retail financial services.
	CategoryCode string `protobuf:"bytes,1,opt,name=category_code,json=categoryCode,proto3" json:"category_code,omitempty"`
	// A unique identifier for the merchant store where the payment settlement
	// transaction occurred.
	StoreId string `protobuf:"bytes,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	// A unique identifier for the POS terminal in the store where the payment
	// settlement transaction occurred.
	TerminalId string `protobuf:"bytes,3,opt,name=terminal_id,json=terminalId,proto3" json:"terminal_id,omitempty"`
	// Indicates the type of merchant.
	Type MerchantAdditionalInfo_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo_Type" json:"type,omitempty"`
	// Indicates the genre of the merchant.
	Genre MerchantAdditionalInfo_Genre `protobuf:"varint,5,opt,name=genre,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo_Genre" json:"genre,omitempty"`
	// Indicates the merchant's onboarding type.
	OnboardingType MerchantAdditionalInfo_OnboardingType `protobuf:"varint,6,opt,name=onboarding_type,json=onboardingType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo_OnboardingType" json:"onboarding_type,omitempty"`
	// Indicates the merchant's owner type.
	OwnershipType MerchantAdditionalInfo_OwnershipType `protobuf:"varint,7,opt,name=ownership_type,json=ownershipType,proto3,enum=google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo_OwnershipType" json:"ownership_type,omitempty"`
}

func (x *MerchantAdditionalInfo) Reset() {
	*x = MerchantAdditionalInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MerchantAdditionalInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantAdditionalInfo) ProtoMessage() {}

func (x *MerchantAdditionalInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantAdditionalInfo.ProtoReflect.Descriptor instead.
func (*MerchantAdditionalInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP(), []int{5}
}

func (x *MerchantAdditionalInfo) GetCategoryCode() string {
	if x != nil {
		return x.CategoryCode
	}
	return ""
}

func (x *MerchantAdditionalInfo) GetStoreId() string {
	if x != nil {
		return x.StoreId
	}
	return ""
}

func (x *MerchantAdditionalInfo) GetTerminalId() string {
	if x != nil {
		return x.TerminalId
	}
	return ""
}

func (x *MerchantAdditionalInfo) GetType() MerchantAdditionalInfo_Type {
	if x != nil {
		return x.Type
	}
	return MerchantAdditionalInfo_TYPE_UNSPECIFIED
}

func (x *MerchantAdditionalInfo) GetGenre() MerchantAdditionalInfo_Genre {
	if x != nil {
		return x.Genre
	}
	return MerchantAdditionalInfo_GENRE_UNSPECIFIED
}

func (x *MerchantAdditionalInfo) GetOnboardingType() MerchantAdditionalInfo_OnboardingType {
	if x != nil {
		return x.OnboardingType
	}
	return MerchantAdditionalInfo_ONBOARDING_TYPE_UNSPECIFIED
}

func (x *MerchantAdditionalInfo) GetOwnershipType() MerchantAdditionalInfo_OwnershipType {
	if x != nil {
		return x.OwnershipType
	}
	return MerchantAdditionalInfo_OWNERSHIP_TYPE_UNSPECIFIED
}

var File_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto protoreflect.FileDescriptor

var file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x79, 0x0a, 0x10, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x66, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x66, 0x73, 0x63, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0xeb, 0x02, 0x0a, 0x15, 0x53,
	0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77,
	0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x12, 0x57, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x0d, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x6f, 0x62,
	0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x22, 0xf1, 0x01, 0x0a, 0x0b, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x76, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x76, 0x69, 0x72, 0x74, 0x75,
	0x61, 0x6c, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x5a, 0x0a, 0x07, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x61, 0x52, 0x07, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x12, 0x12, 0x0a, 0x04,
	0x75, 0x73, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72,
	0x22, 0x3a, 0x0a, 0x07, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x12, 0x17, 0x0a, 0x13, 0x50,
	0x45, 0x52, 0x53, 0x4f, 0x4e, 0x41, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xe3, 0x01, 0x0a,
	0x0c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x55, 0x0a,
	0x08, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x22, 0x58, 0x0a, 0x0c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x67, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x12, 0x1c,
	0x0a, 0x09, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69, 0x73, 0x65, 0x22, 0xf8, 0x06, 0x0a,
	0x16, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x41, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5f, 0x0a, 0x05, 0x67, 0x65, 0x6e, 0x72, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x47, 0x65, 0x6e, 0x72, 0x65,
	0x52, 0x05, 0x67, 0x65, 0x6e, 0x72, 0x65, 0x12, 0x7b, 0x0a, 0x0f, 0x6f, 0x6e, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x6f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x78, 0x0a, 0x0e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0d, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x22, 0x32,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4d, 0x41, 0x4c, 0x4c,
	0x10, 0x02, 0x22, 0x37, 0x0a, 0x05, 0x47, 0x65, 0x6e, 0x72, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x47,
	0x45, 0x4e, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x22, 0x62, 0x0a, 0x0e, 0x4f,
	0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x4f, 0x4e, 0x42, 0x4f, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x42, 0x41, 0x4e, 0x4b, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x50, 0x41, 0x50, 0x10, 0x04, 0x22,
	0x76, 0x0a, 0x0d, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x50, 0x52, 0x49, 0x45, 0x54, 0x41, 0x52, 0x59, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x4f,
	0x54, 0x48, 0x45, 0x52, 0x53, 0x10, 0x05, 0x2a, 0xbb, 0x02, 0x0a, 0x07, 0x41, 0x70, 0x69, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x50, 0x49, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x48,
	0x45, 0x41, 0x52, 0x54, 0x5f, 0x42, 0x45, 0x41, 0x54, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x49,
	0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x4e,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45, 0x54, 0x54, 0x4c, 0x45, 0x5f, 0x50, 0x41, 0x59, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x09, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x43,
	0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x0a, 0x12, 0x19, 0x0a, 0x15,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x41, 0x54, 0x45, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x10, 0x0c, 0x12, 0x0b,
	0x0a, 0x07, 0x56, 0x4f, 0x55, 0x43, 0x48, 0x45, 0x52, 0x10, 0x0d, 0x12, 0x18, 0x0a, 0x14, 0x56,
	0x4f, 0x55, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x0e, 0x2a, 0xef, 0x06, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x41, 0x55, 0x54, 0x4f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x02,
	0x12, 0x24, 0x0a, 0x20, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x45, 0x4e, 0x51,
	0x55, 0x49, 0x52, 0x59, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x04, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x54, 0x10,
	0x06, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x07, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x49, 0x54, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x44, 0x45, 0x42, 0x49, 0x54, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x50,
	0x55, 0x54, 0x45, 0x10, 0x0a, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x45, 0x41, 0x52, 0x54, 0x5f,
	0x42, 0x45, 0x41, 0x54, 0x10, 0x0b, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f,
	0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x10, 0x0c, 0x12, 0x29, 0x0a, 0x25, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d,
	0x41, 0x4e, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x54, 0x50, 0x10, 0x0e, 0x12,
	0x1a, 0x0a, 0x16, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x50, 0x41, 0x55, 0x53, 0x45, 0x10, 0x0f, 0x12, 0x1b, 0x0a, 0x17, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x44, 0x45, 0x45, 0x4d, 0x10, 0x10, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x46,
	0x55, 0x4e, 0x44, 0x10, 0x11, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54,
	0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x42, 0x49, 0x4c, 0x45, 0x10, 0x12, 0x12, 0x1d, 0x0a, 0x19, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x52, 0x45, 0x56, 0x45, 0x52, 0x53, 0x41, 0x4c, 0x10, 0x13, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52,
	0x45, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x14, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x15, 0x12, 0x1c, 0x0a, 0x18, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x50, 0x41, 0x55, 0x53, 0x45, 0x10, 0x16, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x45, 0x10, 0x17, 0x12, 0x27, 0x0a, 0x23, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x18, 0x12,
	0x26, 0x0a, 0x22, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x45, 0x52, 0x10, 0x19, 0x2a, 0xf5, 0x04, 0x0a, 0x0a, 0x58, 0x6d, 0x6c, 0x41,
	0x70, 0x69, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x58, 0x4d, 0x4c, 0x5f, 0x41, 0x50,
	0x49, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x51, 0x5f, 0x42, 0x41, 0x4c, 0x5f,
	0x45, 0x4e, 0x51, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x51, 0x5f, 0x43, 0x48, 0x4b,
	0x5f, 0x54, 0x58, 0x4e, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x51, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x51,
	0x5f, 0x48, 0x42, 0x54, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x51, 0x5f, 0x4c, 0x49,
	0x53, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b,
	0x52, 0x45, 0x51, 0x5f, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12, 0x1c, 0x0a,
	0x18, 0x52, 0x45, 0x51, 0x5f, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x51, 0x5f, 0x4f, 0x54, 0x50, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x51, 0x5f,
	0x50, 0x41, 0x59, 0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x51, 0x5f, 0x52, 0x45, 0x47,
	0x5f, 0x4d, 0x4f, 0x42, 0x10, 0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x51, 0x5f, 0x53, 0x45,
	0x54, 0x5f, 0x43, 0x52, 0x45, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x5f, 0x56,
	0x41, 0x4c, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x10, 0x0c, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x51,
	0x5f, 0x56, 0x4f, 0x55, 0x43, 0x48, 0x45, 0x52, 0x10, 0x0d, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45,
	0x51, 0x5f, 0x56, 0x4f, 0x55, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52,
	0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0e, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x51, 0x5f,
	0x54, 0x58, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x0f, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x42, 0x41, 0x4c, 0x5f, 0x45,
	0x4e, 0x51, 0x10, 0x10, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x43, 0x48, 0x4b,
	0x5f, 0x54, 0x58, 0x4e, 0x10, 0x11, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x12, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45,
	0x53, 0x50, 0x5f, 0x48, 0x42, 0x54, 0x10, 0x13, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x53, 0x50,
	0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x14, 0x12,
	0x10, 0x0a, 0x0c, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x15, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x16,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x4f, 0x54, 0x50, 0x10, 0x17, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x50, 0x41, 0x59, 0x10, 0x18, 0x12, 0x10, 0x0a, 0x0c,
	0x52, 0x45, 0x53, 0x50, 0x5f, 0x52, 0x45, 0x47, 0x5f, 0x4d, 0x4f, 0x42, 0x10, 0x19, 0x12, 0x10,
	0x0a, 0x0c, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x10, 0x1a,
	0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x56, 0x41, 0x4c, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x10, 0x1b, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x56, 0x4f, 0x55, 0x43,
	0x48, 0x45, 0x52, 0x10, 0x1c, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x56, 0x4f,
	0x55, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x1d, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x50, 0x5f, 0x54, 0x58, 0x4e,
	0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x1e, 0x42,
	0xad, 0x02, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x42, 0x11, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x77, 0x69, 0x74, 0x63,
	0x68, 0xaa, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5c, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50,
	0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x3a, 0x3a, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescOnce sync.Once
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescData = file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDesc
)

func file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescGZIP() []byte {
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescOnce.Do(func() {
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescData)
	})
	return file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDescData
}

var file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_goTypes = []interface{}{
	(ApiType)(0),                               // 0: google.cloud.paymentgateway.issuerswitch.v1.ApiType
	(TransactionType)(0),                       // 1: google.cloud.paymentgateway.issuerswitch.v1.TransactionType
	(XmlApiType)(0),                            // 2: google.cloud.paymentgateway.issuerswitch.v1.XmlApiType
	(Participant_Persona)(0),                   // 3: google.cloud.paymentgateway.issuerswitch.v1.Participant.Persona
	(MerchantAdditionalInfo_Type)(0),           // 4: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.Type
	(MerchantAdditionalInfo_Genre)(0),          // 5: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.Genre
	(MerchantAdditionalInfo_OnboardingType)(0), // 6: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.OnboardingType
	(MerchantAdditionalInfo_OwnershipType)(0),  // 7: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.OwnershipType
	(*AccountReference)(nil),                   // 8: google.cloud.paymentgateway.issuerswitch.v1.AccountReference
	(*SettlementParticipant)(nil),              // 9: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant
	(*Participant)(nil),                        // 10: google.cloud.paymentgateway.issuerswitch.v1.Participant
	(*MerchantInfo)(nil),                       // 11: google.cloud.paymentgateway.issuerswitch.v1.MerchantInfo
	(*MerchantName)(nil),                       // 12: google.cloud.paymentgateway.issuerswitch.v1.MerchantName
	(*MerchantAdditionalInfo)(nil),             // 13: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo
}
var file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_depIdxs = []int32{
	10, // 0: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant.participant:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Participant
	8,  // 1: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant.account:type_name -> google.cloud.paymentgateway.issuerswitch.v1.AccountReference
	11, // 2: google.cloud.paymentgateway.issuerswitch.v1.SettlementParticipant.merchant_info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantInfo
	3,  // 3: google.cloud.paymentgateway.issuerswitch.v1.Participant.persona:type_name -> google.cloud.paymentgateway.issuerswitch.v1.Participant.Persona
	12, // 4: google.cloud.paymentgateway.issuerswitch.v1.MerchantInfo.merchant:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantName
	13, // 5: google.cloud.paymentgateway.issuerswitch.v1.MerchantInfo.additional_info:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo
	4,  // 6: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.Type
	5,  // 7: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.genre:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.Genre
	6,  // 8: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.onboarding_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.OnboardingType
	7,  // 9: google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.ownership_type:type_name -> google.cloud.paymentgateway.issuerswitch.v1.MerchantAdditionalInfo.OwnershipType
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init() }
func file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_init() {
	if File_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettlementParticipant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Participant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MerchantAdditionalInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_goTypes,
		DependencyIndexes: file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_depIdxs,
		EnumInfos:         file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_enumTypes,
		MessageInfos:      file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_msgTypes,
	}.Build()
	File_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto = out.File
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_rawDesc = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_goTypes = nil
	file_google_cloud_paymentgateway_issuerswitch_v1_common_fields_proto_depIdxs = nil
}
