/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.symbol.CustomASTVisitor;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class ConstructorCallSymbolProvider
implements SymbolProvider,
WithQuery {
    public String query;

    @Override
    public List<SymbolInformation> get(SearchMatch match) throws CoreException {
        Location location;
        SymbolInformation symbol;
        IMethod mod;
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        JavaElement el = (JavaElement)match.getElement();
        try {
            MethodReferenceMatch m = (MethodReferenceMatch)match;
            mod = (IMethod)m.getElement();
            symbol = new SymbolInformation();
            location = this.getLocation((IJavaElement)mod, match);
            symbol.setName(mod.getElementName());
            if (!m.isConstructor()) {
                JavaLanguageServerPlugin.logInfo((String)"Method reference was not a constructor, skipping");
                return null;
            }
            symbol.setKind(SymbolKind.Constructor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("unable to get constructor: " + e));
            return null;
        }
        symbol.setContainerName(mod.getParent().getElementName());
        symbol.setLocation(location);
        if (this.query.contains(".")) {
            IClassFile cls;
            ICompilationUnit unit = mod.getCompilationUnit();
            if (unit == null && (cls = (IClassFile)mod.getAncestor(6)) != null) {
                unit = cls.becomeWorkingCopy(null, null, null);
            }
            if (this.queryQualificationMatches(this.query, unit, location)) {
                ASTParser astParser = ASTParser.newParser((int)AST.getJLSLatest());
                astParser.setSource(unit);
                astParser.setResolveBindings(true);
                CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
                CustomASTVisitor visitor = new CustomASTVisitor(this.query, match, CustomASTVisitor.QueryLocation.CONSTRUCTOR_CALL);
                cu.accept((ASTVisitor)visitor);
                if (visitor.symbolMatches()) {
                    symbols.add(symbol);
                }
            }
        } else {
            symbols.add(symbol);
        }
        return symbols;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }
}

