/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.query.AnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithAnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class MethodDeclarationSymbolProvider
implements SymbolProvider,
WithQuery,
WithAnnotationQuery {
    private String query;
    private AnnotationQuery annotationQuery;

    @Override
    public List<SymbolInformation> get(SearchMatch match) {
        SymbolKind k = this.convertSymbolKind((IJavaElement)match.getElement());
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        try {
            MethodDeclarationMatch m = (MethodDeclarationMatch)match;
            IMethod e = (IMethod)m.getElement();
            SymbolInformation symbol = new SymbolInformation();
            symbol.setName(e.getElementName());
            symbol.setKind(this.convertSymbolKind((IJavaElement)e));
            symbol.setContainerName(e.getParent().getElementName());
            symbol.setLocation(this.getLocation((IJavaElement)e, match));
            ArrayList<Class<? extends SourceRefElement>> classes = new ArrayList<Class<? extends SourceRefElement>>();
            classes.add(ResolvedSourceMethod.class);
            if (this.matchesAnnotationQuery(match, classes)) {
                symbols.add(symbol);
            }
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("unable to convert for variable: " + String.valueOf(e)));
        }
        return symbols;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public AnnotationQuery getAnnotationQuery() {
        return this.annotationQuery;
    }

    @Override
    public void setAnnotationQuery(AnnotationQuery annotationQuery) {
        this.annotationQuery = annotationQuery;
    }
}

