/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.query.AnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithAnnotationQuery;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeParameterDeclarationMatch;
import org.eclipse.jdt.core.search.TypeParameterReferenceMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class TypeSymbolProvider
implements SymbolProvider,
WithQuery,
WithAnnotationQuery {
    private String query;
    private AnnotationQuery annotationQuery;

    @Override
    public List<SymbolInformation> get(SearchMatch match) {
        SymbolKind kind = this.convertSymbolKind((IJavaElement)match.getElement());
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        if (!(match instanceof TypeReferenceMatch || match instanceof TypeDeclarationMatch || match instanceof TypeParameterDeclarationMatch || match instanceof TypeParameterReferenceMatch)) {
            return null;
        }
        if (match instanceof TypeReferenceMatch && this.query.contains(".")) {
            try {
                IClassFile cls;
                IJavaElement element;
                ICompilationUnit compilationUnit;
                String qualification = "";
                int dotIndex = this.query.lastIndexOf(46);
                if (dotIndex > 0) {
                    qualification = this.query.substring(0, dotIndex);
                }
                if ((compilationUnit = (ICompilationUnit)(element = (IJavaElement)match.getElement()).getAncestor(5)) == null && (cls = (IClassFile)element.getAncestor(6)) != null) {
                    compilationUnit = cls.becomeWorkingCopy(null, null, null);
                }
                boolean isAccurate = false;
                Location location = this.getLocation((IJavaElement)match.getElement(), match);
                if (qualification != "" && location.getUri().contains(qualification.replaceAll(".", "/"))) {
                    isAccurate = true;
                }
                if (compilationUnit != null && !isAccurate) {
                    IPackageDeclaration[] iPackageDeclarationArray = compilationUnit.getPackageDeclarations();
                    int n = iPackageDeclarationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageDeclaration packageDecl = iPackageDeclarationArray[n2];
                        if (qualification != "" && packageDecl.getElementName().matches(qualification)) {
                            isAccurate = true;
                        }
                        ++n2;
                    }
                    if (!isAccurate) {
                        iPackageDeclarationArray = compilationUnit.getImports();
                        n = iPackageDeclarationArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            IPackageDeclaration importDecl = iPackageDeclarationArray[n2];
                            String importElement = importDecl.getElementName();
                            if (importElement.matches(this.query)) {
                                isAccurate = true;
                            }
                            if (qualification != "" && importElement.replaceAll(".*", "").matches(qualification)) {
                                isAccurate = true;
                            }
                            ++n2;
                        }
                    }
                }
                if (!isAccurate) {
                    return null;
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logInfo((String)("failed to determine accuracy of TypeReferenceMatch accepting.." + String.valueOf(match)));
            }
        }
        ArrayList<Class<? extends SourceRefElement>> classes = new ArrayList<Class<? extends SourceRefElement>>();
        classes.add(ResolvedSourceType.class);
        classes.add(ResolvedSourceMethod.class);
        if (!this.matchesAnnotationQuery(match, classes)) {
            return null;
        }
        try {
            IJavaElement mod = (IJavaElement)match.getElement();
            SymbolInformation symbol = new SymbolInformation();
            symbol.setName(mod.getElementName());
            symbol.setKind(this.convertSymbolKind(mod));
            symbol.setContainerName(mod.getParent().getElementName());
            symbol.setLocation(this.getLocation((IJavaElement)match.getElement(), match));
            symbols.add(symbol);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("Unable to convert for TypeSymbolProvider: " + String.valueOf(e)));
            return null;
        }
        return symbols;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public AnnotationQuery getAnnotationQuery() {
        return this.annotationQuery;
    }

    @Override
    public void setAnnotationQuery(AnnotationQuery annotationQuery) {
        this.annotationQuery = annotationQuery;
    }
}

