/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Properties;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.impl.DefaultMutableEntityIndexBinding;
import org.hibernate.search.engine.impl.DynamicShardingEntityIndexBinding;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class EntityIndexBindingFactory {
    private static final Log log = LoggerFactory.make();

    private EntityIndexBindingFactory() {
    }

    public static MutableEntityIndexBinding buildEntityIndexBinding(Class<?> type, IndexManager[] providers, IndexShardingStrategy shardingStrategy, ShardIdentifierProvider shardIdentifierProvider, Similarity similarity, EntityIndexingInterceptor interceptor, boolean isDynamicSharding, Properties properties, String rootDirectoryProviderName, WorkerBuildContext context, IndexManagerHolder indexManagerHolder) {
        if (!isDynamicSharding && providers.length == 0) {
            throw log.entityWithNoShard(type);
        }
        EntityIndexingInterceptor safeInterceptor = interceptor;
        if (isDynamicSharding) {
            return new DynamicShardingEntityIndexBinding(shardIdentifierProvider, similarity, safeInterceptor, properties, context.getUninitializedSearchIntegrator(), indexManagerHolder, rootDirectoryProviderName);
        }
        return new DefaultMutableEntityIndexBinding(shardingStrategy, similarity, providers, interceptor);
    }
}

