package org.jboss.windup.rules.java;

import java.nio.file.Path;

import org.jboss.windup.graph.model.resource.FileModel;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.util.Iterators;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.jboss.windup.exec.configuration.WindupConfiguration;

@RunWith(Arquillian.class)
public class JavaClassTestFile1 {
    @Deployment
    @Dependencies({
            @AddonDependency(name = "org.jboss.windup.config:windup-config"),
            @AddonDependency(name = "org.jboss.windup.exec:windup-exec"),
            @AddonDependency(name = "org.jboss.windup.rules.apps:windup-rules-java"),
            @AddonDependency(name = "org.jboss.windup.reporting:windup-reporting"),
            @AddonDependency(name = "org.jboss.forge.furnace.container:cdi")
    })
    public static ForgeArchive getDeployment() {
        final ForgeArchive archive = ShrinkWrap.create(ForgeArchive.class)
                .addBeansXML()
                .addClass(TestJavaClassTestRuleProvider.class)
                .addClass(JavaClassTest.class)
                .addAsAddonDependencies(
                        AddonDependencyEntry.create("org.jboss.windup.config:windup-config"),
                        AddonDependencyEntry.create("org.jboss.windup.exec:windup-exec"),
                        AddonDependencyEntry.create("org.jboss.windup.rules.apps:windup-rules-java"),
                        AddonDependencyEntry.create("org.jboss.windup.reporting:windup-reporting"),
                        AddonDependencyEntry.create("org.jboss.forge.furnace.container:cdi")
                );

        return archive;
    }

    @Inject
    TestJavaClassTestRuleProvider provider;

    @Inject
    private WindupProcessor processor;

    @Inject
    private GraphContextFactory factory;

    @Test
    public void testJavaClassCondition() throws IOException, InstantiationException, IllegalAccessException {
        try (GraphContext context = factory.create(getDefaultPath())) {
            final String inputDir = "src/test/resources/org/jboss/windup/rules/java";

            final Path outputPath = Paths.get(FileUtils.getTempDirectory().toString(),
                    "windup_" + RandomStringUtils.randomAlphanumeric(6));
            FileUtils.deleteDirectory(outputPath.toFile());
            Files.createDirectories(outputPath);

            // Fill the graph with test data.
            ProjectModel pm = context.getFramed().addFramedVertex(ProjectModel.class);
            pm.setName("Main Project");

            // Create FileModel for $inputDir
            FileModel inputPathFrame = context.getFramed().addFramedVertex(FileModel.class);
            inputPathFrame.setFilePath(inputDir);
            inputPathFrame.setProjectModel(pm);
            pm.addFileModel(inputPathFrame);

            // Set project.rootFileModel to inputPath
            pm.setRootFileModel(inputPathFrame);

            // Create FileModel for $inputDir/HintsClassificationsTest.java
            FileModel fileModel = context.getFramed().addFramedVertex(FileModel.class);
            fileModel.setFilePath(inputDir + "/JavaHintsClassificationsTest.java");
            fileModel.setProjectModel(pm);
            pm.addFileModel(fileModel);

            // Create FileModel for $inputDir/JavaClassTest.java
            fileModel = context.getFramed().addFramedVertex(FileModel.class);
            fileModel.setFilePath(inputDir + "/JavaClassTest.java");
            fileModel.setProjectModel(pm);
            pm.addFileModel(fileModel);

            context.commit();

            final WindupConfiguration processorConfig = new WindupConfiguration().setOutputDirectory(outputPath);
            processorConfig.setRuleProviderFilter(new RuleProviderWithDependenciesPredicate(
                    TestJavaClassTestRuleProvider.class));
            processorConfig.setGraphContext(context).setRuleProviderFilter(
                    new RuleProviderWithDependenciesPredicate(TestJavaClassTestRuleProvider.class));
            processorConfig.setInputPath(Paths.get(inputDir));
            processorConfig.setOutputDirectory(outputPath);
            processorConfig.setOptionValue(ScanPackagesOption.NAME, Collections.singletonList(""));

            processor.execute(processorConfig);

            GraphService<JavaTypeReferenceModel> typeRefService = new GraphService<>(context,
                    JavaTypeReferenceModel.class);
            Iterable<JavaTypeReferenceModel> typeReferences = typeRefService.findAll();
            Assert.assertTrue(typeReferences.iterator().hasNext());

            Assert.assertEquals(3, provider.getFirstRuleMatchCount());
            Assert.assertEquals(1, provider.getSecondRuleMatchCount());
        }
    }

    private Path getDefaultPath() {
        return FileUtils.getTempDirectory().toPath().resolve("Windup")
                .resolve("windupgraph_javaclasstest_" + RandomStringUtils.randomAlphanumeric(6));
    }
}
