/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.type.ManifestMetadata;

public abstract class ManifestDecorator
implements MetaDecorator<ManifestMetadata> {
    protected String extractValue(Manifest mf, List<String> priority) {
        String val = this.findValueInAttribute(mf.getMainAttributes(), priority);
        if (StringUtils.isNotBlank((String)val)) {
            return val;
        }
        ArrayList<String> attributeNames = new ArrayList<String>(mf.getEntries().keySet());
        Collections.sort(attributeNames);
        for (String attributeName : attributeNames) {
            val = this.findValueInAttribute(mf.getAttributes(attributeName), priority);
            if (!StringUtils.isNotBlank((String)val)) continue;
            return val;
        }
        return null;
    }

    protected String cleanseValue(String value) {
        value = StringUtils.trim((String)value);
        value = StringUtils.removeStart((String)value, (String)"'");
        value = StringUtils.removeStart((String)value, (String)"\"");
        value = StringUtils.removeEnd((String)value, (String)"\"");
        value = StringUtils.removeEnd((String)value, (String)"'");
        value = StringUtils.trim((String)value);
        return value;
    }

    private String findValueInAttribute(Attributes attribute, List<String> priority) {
        if (priority != null) {
            for (String key : priority) {
                String val = attribute.getValue(key);
                if (!StringUtils.isNotBlank((String)val)) continue;
                return val;
            }
        }
        return null;
    }
}

