/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class AddContactToAnnuityHolderEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            contact.setConfiguration(this.getConfiguration());
            String contactId = (String)this.getStackMap().get("contactId");
            if (contactId == null || contactId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute contactId in the stack but found null or empty.  found: " + contactId + ".  Make sure that you use this EU in a correct order.");
            }
            contact.setId(contactId);
            this.logger.fine("ready to find contact: " + contact);
            IContact contactReadResult = this.getServerAdapter().findContactById(contact);
            this.logger.fine("found Contact: " + contactReadResult);
            if (this.enableVerify && !((String)contact.getId()).equals(contactReadResult.getId())) {
                throw new ExecutionUnitVerificationException("the client contact id: " + contactId + " did not match the server contactId: " + (String)contactReadResult.getId());
            }
            String annuityHolderId = (String)this.getStackMap().get("annuityHolderId");
            if (annuityHolderId == null || annuityHolderId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute annuityHolderId in the stack but found null or empty.  found: " + annuityHolderId + ".  Make sure that you use this EU in a correct order.");
            }
            IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            holder.setConfiguration(this.getConfiguration());
            holder.setId(annuityHolderId);
            this.logger.fine("ready to read holder");
            IAnnuityHolder holderReadResult = this.getServerAdapter().findHolderById(holder);
            if (this.enableVerify && !((String)holderReadResult.getId()).equals(annuityHolderId)) {
                throw new ExecutionUnitVerificationException("the client annuity holder id: " + annuityHolderId + " did not match the server annuityHolderId: " + (String)holderReadResult.getId());
            }
            holderReadResult.setConfiguration(this.getConfiguration());
            holderReadResult.setContact(contactReadResult);
            IAnnuityHolder updatedHolder = this.getServerAdapter().updateAnnuityHolder(holderReadResult);
            if (this.enableVerify) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, holderReadResult, updatedHolder, "", "");
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contactReadResult, updatedHolder.getContact(), "", "");
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

