/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class RemoveContactFromAnnuityHolderEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IAnnuityHolder holder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
            holder.setConfiguration(this.getConfiguration());
            String annuityHolderId = (String)this.getStackMap().get("annuityHolderId");
            if (annuityHolderId == null || annuityHolderId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute contactId in the stack but found null or empty.  found: " + annuityHolderId + ".  Make sure that you use this EU in a correct order.");
            }
            holder.setId(annuityHolderId);
            this.logger.fine("ready to find holder: " + holder);
            IAnnuityHolder readResult = this.getServerAdapter().findHolderById(holder);
            this.logger.fine("found holder : " + readResult);
            if (this.enableVerify) {
                if (!annuityHolderId.equals(readResult.getId())) {
                    throw new ExecutionUnitVerificationException("the client contact id: " + annuityHolderId + " did not match the server contactId: " + (String)readResult.getId());
                }
                if (readResult.getContact() == null) {
                    throw new ExecutionUnitVerificationException("This holder does not have a contact associated with it.  This test should be executed on a a holder that has a contact.  holder id: " + (String)readResult.getId());
                }
            }
            readResult.setContact(null);
            readResult.setConfiguration(this.getConfiguration());
            this.logger.fine("ready to update holder: " + readResult);
            IAnnuityHolder updateResult = this.getServerAdapter().updateAnnuityHolder(readResult);
            this.logger.fine("updated holder: " + updateResult);
            if (this.enableVerify) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, readResult, updateResult, "AnnuityHolder Client Value did not match Server Contact Value.", "Mismatch was found");
                if (updateResult.getContact() != null) {
                    throw new ExecutionUnitVerificationException("Updated the holder contact to null, when the holder was re-read, the contact was there.  Contact is: " + updateResult.getContact() + " holder id is: " + (String)updateResult.getId() + " contact id is: " + (String)updateResult.getContact().getId());
                }
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

