/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxrpc2ejb3jaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.jaxrpc2ejb3jaxws.JAXRPC2Ejb3JAXWSClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.beanconverter.jaxrpc2ejb3jaxws.JavaBeanToJAXRPC2Ejb3JAXWSClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.AnnuityMgmtSvcEJB30JAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AnnuityJAXRPCToEjb3JAXWSServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcEJB30JAXWS webService;

    public AnnuityJAXRPCToEjb3JAXWSServiceProxy(AnnuityMgmtSvcEJB30JAXWS webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerInternalErrorException {
        if (e instanceof com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.InvalidArgumentException) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException) {
            throw new com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException(e);
        }
        if (e instanceof RemoteException) {
            throw new ServerInternalErrorException("Remote Exception was thrown.  Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuity(ann));
            result = this.webService.createAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayout(payout));
            result = this.webService.createPayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuity(annuity));
            this.webService.deleteAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteContact(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deletePayor(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayout(payout));
            this.webService.deletePayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteRider(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getRider(rider));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityById(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuity(annuity));
            result = this.webService.findAnnuityHolder(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getContact(contact));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findHolderAnnuities(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject[] result = null;
        try {
            result = this.webService.findPayorAnnuities(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return this.getAnnuityListFromAnnuityVOList(result);
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayor(payor));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayout(payout));
            result = this.webService.findPayoutById(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayout(result.getPayout());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getRider(rider));
        }
        catch (com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.EntityNotFoundException e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuity(ann));
            result = this.webService.updateAnnuity(annuityValueObject);
            annuityValueObject.getAnnuityData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject payoutValueObject = new PayoutValueObject();
            payoutValueObject.setPayout(JavaBeanToJAXRPC2Ejb3JAXWSClientBean.getPayout(payout));
            result = this.webService.updatePayout(payoutValueObject);
            payoutValueObject.getPayoutData();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        if (result == null) {
            return null;
        }
        return JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    private List<IAnnuity> getAnnuityListFromAnnuityVOList(AnnuityValueObject[] result) {
        if (result == null) {
            return null;
        }
        ArrayList<IAnnuity> list = new ArrayList<IAnnuity>();
        for (int i = 0; i < result.length; ++i) {
            AnnuityValueObject o = result[i];
            list.add(JAXRPC2Ejb3JAXWSClientBeanToJavaBean.getAnnuity(o.getAnnuityData()));
        }
        return list;
    }
}

