/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2pojojaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2pojojaxrpc.JAXWS2PojoJAXRPCClientBeanToJavaBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.beanconverter.jaxws2pojojaxrpc.JavaBeanToJAXWS2PojoJAXRPCClientBean;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.AnnuityMgmtSvcPojoJAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.ArrayOfTns2NillableAnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Contact;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.EntityAlreadyExistsException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.EntityNotFoundException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.InvalidArgumentException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Payor;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.Rider;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.ServerBusinessModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2pojojaxrpcimpl.ServerPersistenceModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.util.ArrayList;
import java.util.List;

public class AnnuityJAXWSToPojoJAXRPCServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcPojoJAXRPCSEI webService;

    public AnnuityJAXWSToPojoJAXRPCServiceProxy(AnnuityMgmtSvcPojoJAXRPCSEI webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        if (e instanceof InvalidArgumentException_Exception) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException_Exception) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException_Exception) {
            throw new ServerPersistenceModuleException(e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(ann);
            result = this.webService.createAnnuity(annuityValueObject);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.findAnnuityById(annuityValueObject);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.findAnnuityHolder(annuityValueObject);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById(JavaBeanToJAXWS2PojoJAXRPCClientBean.getContact(contact));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            ArrayOfTns2NillableAnnuityValueObject result = this.webService.findHolderAnnuities(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuityHolder(annuityHolder));
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject avo : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(avo.getAnnuityData()));
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return returnData;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuityHolder(annuityHolder));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> returnData = new ArrayList<IAnnuity>();
        try {
            ArrayOfTns2NillableAnnuityValueObject result = this.webService.findPayorAnnuities(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayor(payor));
            if (result == null || result.getAnnuityValueObject() == null) {
                return null;
            }
            for (AnnuityValueObject object : result.getAnnuityValueObject()) {
                returnData.add(JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(object.getAnnuityData()));
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return returnData;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayor(payor));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayout(payout));
            result = this.webService.findPayoutById(in);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById(JavaBeanToJAXWS2PojoJAXRPCClientBean.getRider(rider));
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getRider(result);
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact(JavaBeanToJAXWS2PojoJAXRPCClientBean.getContact(contact));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayor(payor));
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayout(payout));
            result = this.webService.createPayout(in);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            this.webService.deleteAnnuity(annuityValueObject);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteContact(JavaBeanToJAXWS2PojoJAXRPCClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deletePayor(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayout(payout));
            this.webService.deletePayout(in);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteRider(JavaBeanToJAXWS2PojoJAXRPCClientBean.getRider(rider));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = this.getAnnuityValueObject(annuity);
            result = this.webService.updateAnnuity(annuityValueObject);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuity(result.getAnnuityData());
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuityHolder(annHolder));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getAnnuityHolder(result);
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact(JavaBeanToJAXWS2PojoJAXRPCClientBean.getContact(contact));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getContact(result);
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayor(payor));
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayor(result);
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(JavaBeanToJAXWS2PojoJAXRPCClientBean.getPayout(payout));
            result = this.webService.updatePayout(in);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : JAXWS2PojoJAXRPCClientBeanToJavaBean.getPayout(result.getPayoutData());
    }

    private AnnuityValueObject getAnnuityValueObject(IAnnuity annuity) {
        if (annuity == null) {
            return null;
        }
        AnnuityValueObject out = new AnnuityValueObject();
        out.setAnnuity(JavaBeanToJAXWS2PojoJAXRPCClientBean.getAnnuity(annuity));
        return out;
    }
}

