/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejb30.AnnuityMgmtSvcEJB30;
import com.ibm.wssvt.acme.annuity.common.business.ejb30.AnnuityMgmtSvcEJB30Local;
import com.ibm.wssvt.acme.annuity.common.client.adapter.AbstractAnnuityServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3.EJB3ServiceLookup;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import javax.naming.NamingException;

public class EJB30ServerAdapter
extends AbstractAnnuityServerAdapter {
    private static final long serialVersionUID = -7761738176018995756L;

    @Override
    protected IAnnuityService getAnnuityService() throws ServerAdapterCommunicationException {
        IAnnuityService proxy = null;
        AcmeLogger logger = this.getLogger(this.getClass().getName());
        AnnuityMgmtSvcEJB30 svcRemote = null;
        AnnuityMgmtSvcEJB30Local svcLocal = null;
        if ("injectionWithRemote".equalsIgnoreCase((String)this.getConfiguration().getParameterValue((Object)"connectionMode"))) {
            logger.fine("EJB Adapter - Using Injection");
            svcRemote = (AnnuityMgmtSvcEJB30)this.getClientContext().getInjectedObjects().get("AnnuityMgmtSvcEJB30");
            if (svcRemote == null) {
                logger.severe("EJB Adapter was configured to use injection (annotations).  However the injected value is null.  Object is: AnnuityMgmtSvcEJB30");
                throw new ServerAdapterCommunicationException("Failed to get the Server Service Interface.  The injected value of annuityMgmtSvcRemote is null.  Make sure that the injection configuration for annuityMgmtSvcRemote is accurate.");
            }
            logger.finer("svcRemote via injection was found.  value is: " + svcRemote);
        } else if ("injectionWithLocal".equalsIgnoreCase((String)this.getConfiguration().getParameterValue((Object)"connectionMode"))) {
            logger.fine("EJB Adapter - Using Injection with Local");
            svcLocal = (AnnuityMgmtSvcEJB30Local)this.getClientContext().getInjectedObjects().get("AnnuityMgmtSvcEJB30Local");
            if (svcLocal == null) {
                logger.severe("EJB Adapter was configured to use injection.  However the injected value is null.  Object is: AnnuityMgmtSvcEJB30Local");
                throw new ServerAdapterCommunicationException("Failed to get the Server Service Interface.  The injected value of AnnuityMgmtSvcEJB30Local is null.  Make sure that the injection configuration for AnnuityMgmtSvcEJB30Local is accurate.");
            }
            logger.finer("svcLocal via injection was found.  value is: " + svcLocal);
        }
        try {
            proxy = EJB3ServiceLookup.getAnnuityEJB3Service(svcRemote, svcLocal, (Configrable<String, String>)this, logger);
        }
        catch (InvalidConfigurationException e) {
            throw new ServerAdapterCommunicationException(e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            throw new ServerAdapterCommunicationException(e.getMessage(), (Throwable)e);
        }
        catch (AnnuitySecurityException e) {
            throw new ServerAdapterCommunicationException(e.getMessage(), (Throwable)((Object)e));
        }
        return proxy;
    }
}

