/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.persistence;

import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.AnnuityPersistenceType;
import com.ibm.wssvt.acme.annuity.common.persistence.PolicyPersistence;
import com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa.PolicyPersistenceJPASAImpl;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.util.StringUtils;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PolicyPersistenceFactory {
    public static PolicyPersistence<IPersisteble<?>, String, String> getPolicyPersistence(Configrable<String, String> configrable, AcmeLogger logger) throws ServerPersistenceModuleException {
        AnnuityPersistenceType type = PolicyPersistenceFactory.getPersistenceType(configrable, logger);
        logger.fine("using persistence type: " + (Object)((Object)type));
        if (AnnuityPersistenceType.JPA_SA.equals((Object)type)) {
            return new PolicyPersistenceJPASAImpl(logger);
        }
        if (AnnuityPersistenceType.JPA_EJB.equals((Object)type)) {
            try {
                InitialContext ic = new InitialContext();
                Object ref = ic.lookup((String)configrable.getConfiguration().getParameterValue((Object)"jpaPolicyEjbLocalJndi"));
                return (PolicyPersistence)ref;
            }
            catch (NamingException e) {
                logger.log(Level.WARNING, "Failed to locate the JPA EJB Persience Implementaion.", (Throwable)e);
                throw new ServerPersistenceModuleException("Failed to locate the JPA EJB Persience Implementaion. Error: " + e);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Failed to locate the JPA EJB Persience Implementaion.", e);
                throw new ServerPersistenceModuleException("Failed to locate the JPA EJB Persience Implementaion. Error: " + e);
            }
        }
        logger.info("Failed to locate the Persience Implementaion - Could not find the type: " + (String)configrable.getConfiguration().getParameterValue((Object)"persistenceType"));
        throw new ServerPersistenceModuleException("Failed to locate the Persience Implementaion - Could not find the type: " + (String)configrable.getConfiguration().getParameterValue((Object)"persistenceType"));
    }

    private static AnnuityPersistenceType getPersistenceType(Configrable<String, String> configrable, AcmeLogger logger) throws ServerPersistenceModuleException {
        AnnuityPersistenceType type;
        try {
            type = (AnnuityPersistenceType)StringUtils.toEnum(AnnuityPersistenceType.class, (String)((String)configrable.getConfiguration().getParameterValue((Object)"persistenceType")));
        }
        catch (IllegalArgumentException e) {
            logger.warning("Failed to get the PersistenceType.  Configrable: " + configrable.getClass().getName() + "Configrable values: " + configrable.getConfiguration().getParameters().toString());
            throw new ServerPersistenceModuleException("Invalid Server Configuration.  Unable to find the Persistence Implementaion for the persistence type: " + (String)configrable.getConfiguration().getParameterValue((Object)"persistenceType"));
        }
        return type;
    }
}

