/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.util;

import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityKerberosProperties;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class AnnuityKerberosCredential
implements PrivilegedExceptionAction {
    private AcmeLogger logger;
    private GSSManager gssManager;
    private AnnuityKerberosProperties annuityKerberosProperties;
    private Oid kerb5MechOid;
    private Oid spnegoMechOid;

    public AnnuityKerberosCredential(GSSManager mgr, Oid kerb5MechOid, Oid spnegoMechOid, AcmeLogger logger, AnnuityKerberosProperties annuityKerberosProperties) {
        this.logger = logger;
        this.gssManager = mgr;
        this.annuityKerberosProperties = annuityKerberosProperties;
        this.kerb5MechOid = kerb5MechOid;
        this.spnegoMechOid = spnegoMechOid;
    }

    public Object run() throws AnnuitySecurityException {
        try {
            this.logger.fine("getting Client GSSCredentials");
            GSSName gssName = this.gssManager.createName(this.annuityKerberosProperties.getKerbUserId(), GSSName.NT_USER_NAME, this.kerb5MechOid);
            GSSCredential gssCred = this.gssManager.createCredential(gssName.canonicalize(this.kerb5MechOid), Integer.MAX_VALUE, this.kerb5MechOid, 1);
            if (this.spnegoMechOid != null) {
                gssCred.add(gssName, Integer.MAX_VALUE, Integer.MAX_VALUE, this.spnegoMechOid, 1);
            }
            this.logger.fine("Got Client GSSCredentials");
            return gssCred;
        }
        catch (GSSException e) {
            this.logger.log(Level.INFO, "got GSSException when trying to execute a doAs method. Error: " + e.getMessage() + this.logger.getAllLogs(), (Throwable)e);
            throw new AnnuitySecurityException("got GSSException when trying to execute a doAs method. Error: " + e.getMessage(), e);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "got GSSException when trying to execute a doAs method. Error: " + e.getMessage() + this.logger.getAllLogs(), (Throwable)e);
            throw new AnnuitySecurityException("got Exception when trying to execute a doAs method. Error: " + e.getMessage(), e);
        }
    }
}

