/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class MultivaluedMapImpl<K, V>
implements MultivaluedMap<K, V> {
    private final Map<K, List<V>> map = new LinkedHashMap<K, List<V>>();

    public MultivaluedMapImpl() {
    }

    public MultivaluedMapImpl(Map<K, V> map) {
        this();
        for (K key : map.keySet()) {
            this.add(key, map.get(key));
        }
    }

    public void add(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.add(value);
    }

    public V getFirst(K key) {
        Object list = this.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (V)list.get(0);
    }

    public void putSingle(K key, V value) {
        List<V> list = this.getOrCreate(key);
        list.clear();
        list.add(value);
    }

    private List<V> getOrCreate(K key) {
        List<V> list = this.get(key);
        if (list == null) {
            list = this.createValueList(key);
            this.put(key, list);
        }
        return list;
    }

    private List<V> createValueList(K key) {
        return new ArrayList();
    }

    public MultivaluedMapImpl<K, V> clone() {
        return MultivaluedMapImpl.clone(this);
    }

    public static <K, V> MultivaluedMapImpl<K, V> clone(MultivaluedMap<K, V> src) {
        MultivaluedMapImpl<K, V> clone = new MultivaluedMapImpl<K, V>();
        MultivaluedMapImpl.copy(src, clone);
        return clone;
    }

    public static <K, V> void copy(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List value = (List)src.get(key);
            ArrayList newValue = new ArrayList();
            newValue.addAll(value);
            dest.put(key, newValue);
        }
    }

    public static <K, V> void addAll(MultivaluedMap<K, V> src, MultivaluedMap<K, V> dest) {
        for (Object key : src.keySet()) {
            List srcList = (List)src.get(key);
            ArrayList destList = (ArrayList)dest.get(key);
            if (destList == null) {
                destList = new ArrayList(srcList.size());
                dest.put(key, destList);
            }
            destList.addAll(srcList);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    public List<V> get(Object key) {
        return this.map.get(key);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends List<V>> t) {
        this.map.putAll(t);
    }

    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<List<V>> values() {
        return this.map.values();
    }
}

