/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.util;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;

public class UsernameTokenPropagationVerification {
    public void verifyUsernameToken(Configrable<String, String> configurable, String untToVerify) {
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(configurable, this.getClass().getName());
        logger.info(untToVerify + " is enabled");
        UsernameToken usernameToken = null;
        String username = null;
        String callerPrincipalName = null;
        String callerPrincipalShortName = null;
        ArrayList<String> principalNames = new ArrayList<String>();
        try {
            Set<Principal> principals;
            Subject callerSubject;
            Subject runAsSubject = this.getRunAsSubject(configurable);
            if (runAsSubject != null) {
                logger.info("calling getUsernameTokenFromSubject ...");
                usernameToken = this.getUsernameTokenFromSubject(runAsSubject, configurable);
                if (usernameToken != null) {
                    username = usernameToken.getUsername();
                    if (username != null) {
                        logger.info("username from usernameToken.getUsername()is: " + username);
                    } else {
                        logger.info("username from userNameID.getValue() is null");
                    }
                }
            } else {
                logger.info(" runAsSubject returns null ...");
            }
            if ((callerSubject = this.getCallerSubject(configurable)) != null && (principals = callerSubject.getPrincipals()) != null && principals.size() > 0) {
                for (Principal principal : principals) {
                    if (principal == null || !(principal instanceof WSPrincipal) || (callerPrincipalName = ((WSPrincipal)principal).getName()) == null) continue;
                    logger.info("callerPrincipalName is: " + callerPrincipalName);
                    int indexOfSlahs = callerPrincipalName.indexOf("/");
                    callerPrincipalShortName = callerPrincipalName.substring(indexOfSlahs + 1);
                    principalNames.add(callerPrincipalShortName);
                    logger.info("callerPrincipalShortName is: " + callerPrincipalShortName);
                }
            }
            if (username != null && principalNames.size() > 0) {
                for (int i = 0; i < principalNames.size(); ++i) {
                    if (!username.equalsIgnoreCase((String)principalNames.get(i))) continue;
                    logger.info("userName and callerPrincipalName matches. Username token propagation test succeeded.");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception verifying Username token: " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private UsernameToken getUsernameTokenFromSubject(final Subject subject, Configrable<String, String> configrable) throws WSSecurityException {
        final AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
        UsernameToken usernameToken = null;
        logger.info("getUsernameTokenFromSubject() entry... " + subject);
        if (subject == null) {
            return null;
        }
        try {
            usernameToken = (UsernameToken)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Iterator<UsernameToken> authIterator = subject.getPrivateCredentials(UsernameToken.class).iterator();
                    if (authIterator.hasNext()) {
                        UsernameToken token = authIterator.next();
                        if (token != null) {
                            logger.info("Found UsernameToken, ID is: " + token.getId());
                        } else {
                            logger.info("NO Usernmae Token is found to be processed...");
                        }
                        return token;
                    }
                    return null;
                }
            });
            if (usernameToken == null) {
                logger.info("Could not find UsernameToken.");
            } else {
                logger.info("Found UsernameToken from runAsSubject: " + usernameToken);
            }
            logger.info("getUsernameTokenFromSubject() exits... ");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception getting username token from subject: " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return usernameToken;
    }

    private Subject getRunAsSubject(Configrable<String, String> configrable) {
        Subject runAsSubject = null;
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
        try {
            runAsSubject = WSSubject.getRunAsSubject();
            if (runAsSubject != null) {
                logger.info("runAsSubject NOT null: " + runAsSubject);
            }
        }
        catch (WSSecurityException e) {
            logger.log(Level.WARNING, "No getRunAsSubject exists. The call WSSubject.getRunAsSubject() returned WSSecurityException." + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return runAsSubject;
    }

    private Subject getCallerSubject(Configrable<String, String> configrable) {
        Subject callerSubject = null;
        AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
        try {
            callerSubject = WSSubject.getCallerSubject();
            if (callerSubject != null) {
                logger.info("callerSubject NOT null: " + callerSubject);
            }
        }
        catch (WSSecurityException e) {
            logger.log(Level.WARNING, "No getRunAsSubject exists. The call WSSubject.getCallerSubject() returned WSSecurityException." + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return callerSubject;
    }
}

