/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.exception;

import com.ibm.wssvt.acme.common.envconfig.ExceptionHandlerConfiguration;
import com.ibm.wssvt.acme.common.exception.ExceptionAction;
import com.ibm.wssvt.acme.common.exception.ExceptionHandlerResult;
import com.ibm.wssvt.acme.common.exception.IExceptionHandler;
import com.ibm.wssvt.acme.common.exception.IExceptionHandlerResult;
import com.ibm.wssvt.acme.common.exception.IExecutionUnitExceptionProcessor;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import java.util.Map;
import java.util.StringTokenizer;

public class ExecutionUnitExceptionProcessor
implements IExecutionUnitExceptionProcessor {
    @Override
    public IExceptionHandlerResult processException(Map<String, ExceptionHandlerConfiguration> exceptionHandlerConfigMap, Exception exception, IExecutionUnit executionUnit) {
        ExceptionHandlerResult result = new ExceptionHandlerResult();
        ExceptionHandlerConfiguration exceptionHandlerConfiguration = ExecutionUnitExceptionProcessor.getExceptionHandlerConfig(exceptionHandlerConfigMap, exception);
        if (exceptionHandlerConfiguration == null) {
            result.setAction(ExceptionAction.STOP);
            result.setMessage("*** POSSIBLE DEFECT *** The client encountered an error that it did not expect. Make sure that the Client Config Env contains all expected errors. No configuration for exception class: " + exception.getClass().getName() + ".  Error Message is:" + exception.getMessage());
            return result;
        }
        try {
            IExceptionHandler exceptionHandler = (IExceptionHandler)Thread.currentThread().getContextClassLoader().loadClass(exceptionHandlerConfiguration.getHandlerClassName()).newInstance();
            return exceptionHandler.handleException(exceptionHandlerConfiguration, exception);
        }
        catch (IllegalAccessException e) {
            result.setAction(ExceptionAction.STOP);
            result.setMessage("Failed to load the Exception Handler: " + exceptionHandlerConfiguration.getExceptionClassName() + " with error: " + e);
            return result;
        }
        catch (InstantiationException e) {
            result.setAction(ExceptionAction.STOP);
            result.setMessage("Failed to load the Exception Handler: " + exceptionHandlerConfiguration.getExceptionClassName() + " with error: " + e);
            return result;
        }
        catch (ClassNotFoundException e) {
            result.setAction(ExceptionAction.STOP);
            result.setMessage("Failed to load the Exception Handler: " + exceptionHandlerConfiguration.getExceptionClassName() + " with error: " + e);
            return result;
        }
    }

    private static ExceptionHandlerConfiguration getExceptionHandlerConfig(Map<String, ExceptionHandlerConfiguration> exceptionHandlerConfigMap, Exception error) {
        ExceptionHandlerConfiguration exHandlerConfig = exceptionHandlerConfigMap.get(error.getClass().getName());
        if (exHandlerConfig == null) {
            StringTokenizer st = new StringTokenizer(error.getClass().getName(), ".");
            String partialName = "";
            String multiPartialName = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                partialName = (multiPartialName = multiPartialName + token + ".") + "*";
                exHandlerConfig = exceptionHandlerConfigMap.get(partialName);
                if (exHandlerConfig == null) continue;
                break;
            }
        }
        return exHandlerConfig;
    }
}

