/*******************************************************************************
 * Copyright (c) 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/* Generated By:JavaCC: Do not edit this line. MatchParserImpl.java */
package com.ibm.ws.sib.matchspace.selector.impl;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.tools.MatchParser;
import java.util.List;
import java.util.ArrayList;
import java.io.StringReader;

/** The MatchParser class provides parsing support for a superset of the JMS selector
 * syntax, returning a Selector tree.  Except for the superset features, the language
 * accepted is that of the JMS specification.
 *
 * MatchParser language features not in JMS:
 *
 * (1) Identifiers can be quoted with " and may contain any character except unescaped ".
 *
 * (2) Identifiers (unquoted) may contain the field separator character '.'.
 *
 * (3) Set predicates allow an arbitrary expression on the left (not restricted to
 * identifier) and a list of arbitrary expressions on the right (not restricted to string
 * literals).
 *
 * The superset features can be turned off by setting the 'strict' flag, causing the
 * parser to recognize only the JMS syntax.
 **/

public class MatchParserImpl implements MatchParser, MatchParserImplConstants {

  // Strict mode flag
  private boolean strict;


  /** Prime a MatchParser object with a String form selector so that its QueryExpr method
   * will return the corresponding Selector tree.
   *
   * @param parser an existing MatchParser object to be reused, or null if a new one is to
   * be created.
   *
   * @param selector the String-form selector to be parsed
   *
   * @param strict true if only the JMS standard syntax is to be accepted, false if the
   * extended syntax for identifiers, and set expressions, is to be accepted.
   *
   * @return a parser, primed with the supplied selector.  This is the same parser object
   * that was supplied as an argument, if one was supplied.
   **/

  public static MatchParser prime(MatchParser parser, String selector, boolean strict) {
    CharStream inStream = new IBMUnicodeCharStream(new StringReader(selector),1,1);
    if (parser == null)
      parser =  new MatchParserImpl(inStream);
    else
      ((MatchParserImpl)parser).ReInit(inStream);
    ((MatchParserImpl)parser).strict = strict;
    return parser;
  }

  /** Return the Selector tree associated with a primed parser.
   *
   * @return a selector tree.  If the parse was successful, the top node of the tree will
   * be of BOOLEAN type; otherwise, it will be of INVALID type.
   **/

  public Selector getSelector(String selector) {
    Selector ans;
    try {
      ans = QueryExpr();
      if (!ans.mayBeBoolean())
        ans.setType(Selector.INVALID);
    } catch (ParseException e) {
      // No FFDC code needed
      Object obj = null;
      ans = new LiteralImpl(obj);
      ans.setType(Selector.INVALID);
    }
    return ans;
  }

// QueryExpr ::= BooleanExpr <EOF>
  final public Selector QueryExpr() throws ParseException {
                         Selector ans;
    ans = BooleanExpr();
    jj_consume_token(0);
                              {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// BooleanExpr  ::=  BooleanTerm
//               | BooleanTerm <OR> BooleanExpr
  final public Selector BooleanExpr() throws ParseException {
                           Selector left, right=null;
    left = BooleanTerm();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      right = BooleanExpr();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new OperatorImpl(Operator.OR, left, right);}
    throw new Error("Missing return statement in function");
  }

// BooleanTerm ::= BooleanFactor
//              | BooleanFactor <AND> BooleanTerm
  final public Selector BooleanTerm() throws ParseException {
                           Selector left, right=null;
    left = BooleanFactor();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      right = BooleanTerm();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new OperatorImpl(Operator.AND, left, right);}
    throw new Error("Missing return statement in function");
  }

// BooleanFactor ::= ( <NOT> Predicate ) | Predicate
  final public Selector BooleanFactor() throws ParseException {
                             Selector child; boolean neg=false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
             neg = true;
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    child = Predicate();
    if (neg) {if (true) return new OperatorImpl(Operator.NOT, child);}
    else {if (true) return child;}
    throw new Error("Missing return statement in function");
  }

// Predicate ::= SetPredicate
//            | NullPredicate
//            | ComparisonPredicate
//            | BetweenPredicate
//            | LikePredicate
//            | EmptyPredicate
//            | Expression
// SetPredicate ::= JMSSetPredicate
//               | GeneralSetPredicate
  final public Selector Predicate() throws ParseException {
                         Selector ans;
    if (jj_2_1(2147483647)) {
      ans = ComparisonPredicate();
    } else if (jj_2_2(2147483647)) {
      ans = NullPredicate();
    } else if (jj_2_3(2147483647)) {
      ans = BetweenPredicate();
    } else if (jj_2_4(2147483647)) {
      ans = LikePredicate();
    } else if (jj_2_5(2147483647)) {
      ans = JMSSetPredicate();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 7:
      case 8:
      case 11:
      case TRUE:
      case FALSE:
      case IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
        ans = Expression();
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// ComparisonPredicate ::= ( Expression ( "<" | ">" | "<=" | ">=" ) Expression
//                      | Expression ( "<>" | "=" ) Expression )
  final public Selector ComparisonPredicate() throws ParseException {
                                   Selector left, right; int op;
    left = Expression();
    op = ComparisonOperator();
    right = Expression();
    {if (true) return new OperatorImpl(op, left, right);}
    throw new Error("Missing return statement in function");
  }

  final public int ComparisonOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 1:
      jj_consume_token(1);
        {if (true) return Operator.LT;}
      break;
    case 2:
      jj_consume_token(2);
          {if (true) return Operator.GT;}
      break;
    case 3:
      jj_consume_token(3);
           {if (true) return Operator.LE;}
      break;
    case 4:
      jj_consume_token(4);
           {if (true) return Operator.GE;}
      break;
    case 5:
      jj_consume_token(5);
           {if (true) return Operator.NE;}
      break;
    case 6:
      jj_consume_token(6);
          {if (true) return Operator.EQ;}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Expression ::= Term
//             | Term PlusMinus Expression
  final public Selector Expression() throws ParseException {
                          Selector left, right=null; int op = -1;
    left = Term();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
    case 8:
      op = PlusMinus();
      right = Expression();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new OperatorImpl(op, left, right);}
    throw new Error("Missing return statement in function");
  }

// PlusMinus ::= "+" | "-"
  final public int PlusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
      jj_consume_token(7);
        {if (true) return Operator.PLUS;}
      break;
    case 8:
      jj_consume_token(8);
          {if (true) return Operator.MINUS;}
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Term ::= Primary
//       | Primary TimesDiv Term
  final public Selector Term() throws ParseException {
                    Selector left, right=null; int op = -1;
    left = Primary(false);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 9:
    case 10:
      op = TimesDiv();
      right = Term();
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    if (right == null) {if (true) return left;}
    else {if (true) return new OperatorImpl(op, left, right);}
    throw new Error("Missing return statement in function");
  }

// TimesDiv ::= "*" | "/"
  final public int TimesDiv() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 9:
      jj_consume_token(9);
        {if (true) return Operator.TIMES;}
      break;
    case 10:
      jj_consume_token(10);
          {if (true) return Operator.DIV;}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Primary ::= PlusMinus Primary
//          | PrimaryNotPlusMinus
  final public Selector Primary(boolean negated) throws ParseException {
                                      Selector ans; int op = Operator.PLUS;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 11:
    case TRUE:
    case FALSE:
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
      ans = PrimaryNotPlusMinus(negated);
      break;
    case 7:
    case 8:
      op = PlusMinus();
                         negated ^= (op == Operator.MINUS);
      ans = Primary(negated);
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// PrimaryNotPlusMinus ::= <TRUE>
//                   | <FALSE>
//                   | "(" BooleanExpr ")"
//                   | <INTEGER_LITERAL>
//                   | <FLOATING_POINT_LITERAL>
//                   | <STRING_LITERAL>
//                   | FieldRef
  final public Selector PrimaryNotPlusMinus(boolean negated) throws ParseException {
                                                  Selector ans; Token tok;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             ans = new LiteralImpl(Boolean.TRUE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
              ans = new LiteralImpl(Boolean.FALSE);
      break;
    case 11:
      jj_consume_token(11);
      ans = BooleanExpr();
      jj_consume_token(12);
      break;
    case INTEGER_LITERAL:
      tok = jj_consume_token(INTEGER_LITERAL);
    ans = ParseUtil.parseIntegerLiteral(((negated) ? "-" : "") + tok.image);
    negated = false;
      break;
    case FLOATING_POINT_LITERAL:
      tok = jj_consume_token(FLOATING_POINT_LITERAL);
    ans = ParseUtil.parseFloatingLiteral(((negated) ? "-" : "") + tok.image);
    negated = false;
      break;
    case STRING_LITERAL:
      tok = jj_consume_token(STRING_LITERAL);
                             ans = ParseUtil.parseStringLiteral(tok.image);
      break;
    case IDENTIFIER:
    case QUOTED_IDENTIFIER:
      ans = FieldRef();

      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (negated) {if (true) return new OperatorImpl(Operator.NEG, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// NullPredicate ::= FieldRef <IS> ( <NOT> )? <NULL>
  final public Selector NullPredicate() throws ParseException {
                             boolean not=false; Selector ans;
    ans = FieldRef();
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                    not = true;
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(NULL);
    ans = new OperatorImpl(Operator.ISNULL, ans);
    if (not) {if (true) return new OperatorImpl(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// JMSSetPredicate ::= FieldRef ( <NOT> )? <IN> SetString
  final public Selector JMSSetPredicate() throws ParseException {
                               Selector id; List set; boolean neg=false;
    id = FieldRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                              neg = true;
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    set = SetString();
    Selector ans = ParseUtil.convertSet(id, set);
    if (neg) {if (true) return new OperatorImpl(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// GeneralSetPredicate ::= Expression ( <NOT> )? <IN> SetExpr
  final public Selector GeneralSetPredicate() throws ParseException {
                                   Selector expr; List set; boolean neg=false;
    if (strict) {if (true) throw generateParseException();}
    expr = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                  neg = true;
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    set = SetExpr();
    Selector ans = ParseUtil.convertSet(expr, set);
    if (neg) ans = new OperatorImpl(Operator.NOT, ans);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// SetExpr ::= "(" Expression ( "," Expression )* ")"
  final public List SetExpr() throws ParseException {
                   List ans = new ArrayList(); Selector elem;
    jj_consume_token(11);
    elem = Expression();
                              ans.add(elem);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 13:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_1;
      }
      jj_consume_token(13);
      elem = Expression();
                                ans.add(elem);
    }
    jj_consume_token(12);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// SetString ::= "(" <STRING_LITERAL> ( "," <STRING_LITERAL> )* ")"
  final public List SetString() throws ParseException {
                     List ans = new ArrayList(); Token tok;
    jj_consume_token(11);
    tok = jj_consume_token(STRING_LITERAL);
      ans.add(ParseUtil.parseStringLiteral(tok.image));
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 13:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_2;
      }
      jj_consume_token(13);
      tok = jj_consume_token(STRING_LITERAL);
        ans.add(ParseUtil.parseStringLiteral(tok.image));
    }
    jj_consume_token(12);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// BetweenPredicate ::= Expression ( <NOT> )? <BETWEEN> Expression <AND> Expression
  final public Selector BetweenPredicate() throws ParseException {
                                Selector expr1, expr2, expr3; boolean neg=false;
    expr1 = Expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                                   neg = true;
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    expr2 = Expression();
    jj_consume_token(AND);
    expr3 = Expression();
    Selector ans = ParseUtil.convertRange(expr1, expr2, expr3);
    if (neg) {if (true) return new OperatorImpl(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// LikePredicate ::= FieldRef ( <NOT> )? <LIKE> <STRING_LITERAL>
//   ( <ESCAPE> <STRING_LITERAL> )?
  final public Selector LikePredicate() throws ParseException {
                             Selector id; Token pat; Token esc=null; boolean neg=false;
    id = FieldRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                              neg = true;
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(LIKE);
    pat = jj_consume_token(STRING_LITERAL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
      jj_consume_token(ESCAPE);
      esc = jj_consume_token(STRING_LITERAL);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    Selector ans = ParseUtil.convertLike(id, pat.image, (esc==null) ? null : esc.image);
    if (ans == null) generateParseException();
    if (neg) {if (true) return new OperatorImpl(Operator.NOT, ans);}
    else {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

// FieldRef ::=  <IDENTIFIER>
//             |  <QUOTED_IDENTIFIER>
  final public Selector FieldRef() throws ParseException {
                        Token tok; String id;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
                         id = tok.image;
                         // Identifiers with '.' in their name are not JMS conformant
                         if (strict && id.indexOf('.') != -1)
                         {if (true) throw generateParseException();}
      break;
    case QUOTED_IDENTIFIER:
      tok = jj_consume_token(QUOTED_IDENTIFIER);
                                  if (strict) {if (true) throw generateParseException();}
                                  id = tok.image.substring(1, tok.image.length()-1);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    Selector ans = new IdentifierImpl(id);
    {if (true) return ans;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_3R_7() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_5()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_3() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_4()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_3()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_4() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_11()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_5()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_4()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_3()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(11)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(12)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_17()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_6() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_14()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(10)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(9)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_5() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_12()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(13)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(11)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_27()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(12)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(8)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(7)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_3R_17()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(6)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(5)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(4)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(3)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(2)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(1)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public MatchParserImplTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[20];
  final private int[] jj_la1_0 = {0x1000000,0x2000000,0x4000000,0xf0000980,0x7e,0x180,0x180,0x600,0x600,0xf0000980,0xf0000800,0x4000000,0x4000000,0x4000000,0x2000,0x2000,0x4000000,0x4000000,0x800000,0xc0000000,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x58,0x0,0x0,0x0,0x0,0x0,0x58,0x58,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private JJCalls[] jj_2_rtns = new JJCalls[5];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public MatchParserImpl(CharStream stream) {
    token_source = new MatchParserImplTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MatchParserImpl(MatchParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(MatchParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration vEnum = jj_expentries.elements(); vEnum.hasMoreElements();) {
        int[] oldentry = (int[])(vEnum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[39];
    for (int i = 0; i < 39; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 20; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 39; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 5; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }
  
  /* (non-Javadoc)
   * @see com.ibm.ws.sib.matchspace.tools.MatchParser#setMatching(com.ibm.ws.sib.matchspace.Matching)
   */
  public void setMatching(Matching matching) 
  {
    // A noop in this parser implementation
  }
}
