/*******************************************************************************
 * Copyright (c) 2001, 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.rsadapter.impl;

/**
 * <p>The base class for reusable keys for statement caching. Each type of statement which may
 * be cached should have its own cache key class inheriting from StatementCacheKey, with a
 * unique <code>statementType</code> constant.</p>
 */
public abstract class StatementCacheKey {
    /**
     * <code>sql</code> is the SQL string this object is holding.
     */
    public String sql; 

    /**
     * <code>type</code> is the ResultSet type.
     */
    public int type; 

    /**
     * <code>concurrency</code> is the ResultSet concurrecy.
     */
    public int concurrency; 

    /** The ResultSet holdability. */
    public int holdability; 

    /** The section number for DB2 SQLJ statements. */
    public int sectionNumber; 

    /** The package name for DB2 SQLJ statements. */
    public String packageName; 

    /** The consistency token for DB2 SQLJ statements. */
    public long consistencyToken; 

    /** Indicates the type of statement this key is used for. */
    public int statementType; 

    /**
     * <code>hCode</code> is the cached value of the hashCode for this object.
     */
    public int hCode; 

    /** The auto generated key flag */
    public int autoGeneratedKeys; 

    /**
     * 
     */
    public int statementIsoLevel; 
    
    /**
     * Indicates the scheam used by the database.
     * @since JDBC-4.1
     */
    public String schema;
    
    /**
     * This portion of the key is provided by the JCC driver to represent the contents
     * of the Object[] parameter. WAS compares the cacheKeySuffix instead of
     * comparing the array contents.
     * 
     */
    public String cacheKeySuffix; 

    /**
     * @return the hashcode for this object.
     */
    @Override
    public final int hashCode() {
        return hCode;
    }

    /**
     * @param b an array of 8 bytes. This value cannot be a null.
     * 
     * @return a unique long value representing the first 8 bytes of the byte array.
     * 
     */
    public static final long toLong(byte[] b) {
        long x = 0;
        for (int i = b.length; i > 0; x |= (b[--i] & 0xffL) << (i << 3));
        return x;
    }

}
