/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbdeploy.JGSEJB.DB2UDBNT_V82_1;

public class RdbRuntimeUpdateTemplate {
    private static final String AND = " AND ";
    private static final String ISNULL = " IS NULL ";
    private static final String EQUALMARKER = " = ? ";
    private int maxQueryBufferSize;
    private String fRootFragment;
    private String fWhereKeyFragment;
    private String fWhereKeyAndPredicateFragment;
    private String[] fAssignmentColumns;
    private String[] fPredicateColumns;
    private boolean fHasNullablePredicates;
    private int[] fCmpFieldMap;

    public RdbRuntimeUpdateTemplate(String rootFragment, String keyFragment, String[] assignmentFragments, int maxQuerySize, boolean nullbalePredicates) {
        this.fRootFragment = rootFragment;
        this.fWhereKeyFragment = keyFragment;
        this.maxQueryBufferSize = maxQuerySize;
        this.fAssignmentColumns = assignmentFragments;
        this.fHasNullablePredicates = nullbalePredicates;
    }

    public boolean isNullablePredicates() {
        return this.fHasNullablePredicates;
    }

    public void setPredicateColumns(String[] predicateColumns, int maxQuerySize) {
        this.maxQueryBufferSize = maxQuerySize;
        if (this.isNullablePredicates()) {
            this.fPredicateColumns = predicateColumns;
        } else {
            StringBuffer buf = new StringBuffer(this.fWhereKeyFragment);
            int j = 0;
            while (j < predicateColumns.length) {
                buf.append(AND).append(predicateColumns[j]).append(EQUALMARKER);
                ++j;
            }
            this.fWhereKeyAndPredicateFragment = buf.toString();
        }
    }

    public void cmpFieldMap(int[] cmpFieldMap) {
        this.fCmpFieldMap = cmpFieldMap;
    }

    public int[] cmpFieldMap() {
        return this.fCmpFieldMap;
    }

    public String nativeQuery(boolean[] dirtyFlags) {
        CodeBuffer aBuffer = new CodeBuffer(this.maxQueryBufferSize);
        aBuffer.append(this.fRootFragment);
        if (!this.assignmentsOn(aBuffer, dirtyFlags)) {
            return null;
        }
        aBuffer.append(this.fWhereKeyFragment);
        return aBuffer.toString();
    }

    public String nativeOptimisticQuery(boolean[] dirtyFlags) {
        CodeBuffer aBuffer = new CodeBuffer(this.maxQueryBufferSize);
        aBuffer.append(this.fRootFragment);
        if (!this.assignmentsOn(aBuffer, dirtyFlags)) {
            return null;
        }
        aBuffer.append(this.fWhereKeyAndPredicateFragment);
        return aBuffer.toString();
    }

    public String nativeOptimisticQuery(boolean[] dirtyFlags, Object[] values) {
        CodeBuffer aBuffer = new CodeBuffer(this.maxQueryBufferSize);
        aBuffer.append(this.fRootFragment);
        if (!this.assignmentsOn(aBuffer, dirtyFlags)) {
            return null;
        }
        aBuffer.append(this.fWhereKeyFragment);
        this.predicatesOn(aBuffer, values);
        return aBuffer.toString();
    }

    private boolean assignmentsOn(CodeBuffer aBuffer, boolean[] dirtyFlags) {
        boolean touched = false;
        int numColumns = this.fAssignmentColumns.length;
        int i = 0;
        while (i < numColumns) {
            if (dirtyFlags[this.fCmpFieldMap[i]]) {
                aBuffer.append(this.fAssignmentColumns[i]);
                touched = true;
            }
            ++i;
        }
        if (touched) {
            aBuffer.deleteLastChars(2);
        }
        return touched;
    }

    private void predicatesOn(CodeBuffer buf, Object[] values) {
        int i = 0;
        while (i < this.fPredicateColumns.length) {
            buf.append(AND).append(this.fPredicateColumns[i]);
            if (values[i] != null) {
                buf.append(EQUALMARKER);
            } else {
                buf.append(ISNULL);
            }
            ++i;
        }
    }

    private class CodeBuffer {
        private char[] value;
        private int count;

        public CodeBuffer(int capacity) {
            this.value = new char[capacity];
        }

        public int length() {
            return this.count;
        }

        public CodeBuffer append(String str) {
            int len = str.length();
            int newcount = this.count + len;
            str.getChars(0, len, this.value, this.count);
            this.count = newcount;
            return this;
        }

        public void deleteLastChars(int numChars) {
            this.count -= numChars;
        }

        public String toString() {
            return new String(this.value, 0, this.count);
        }
    }
}

