/*******************************************************************************
 * Copyright (c) 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.producers;

import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;

import com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.NonNullBean;
import com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.NullBean;
import com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.NullBeanFour;
import com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.NullBeanThree;
import com.ibm.ws.cdi.annotations.fat.apps.dependentScopedProducer.beans.NullBeanTwo;

@ApplicationScoped
public class IllegalNullBeanProducer {
	
	private static boolean hasProduced = false;
	
	@ApplicationScoped
	@Produces
	public NullBean produceNull(){
		hasProduced = true;
		return null;
	}
	
	@ApplicationScoped
	@Produces
	public NullBeanTwo produceNullTwo(){
		hasProduced = true;
		return null;
	}
	
	@ApplicationScoped
	@Produces
	public NullBeanThree produceNullThree(){
		hasProduced = true;
		return null;
	}
	
	@ApplicationScoped
	@Produces
	public NullBeanFour produceNullFour(){
		hasProduced = true;
		return null;
	}
	
	@ApplicationScoped
	@Produces
	public NonNullBean produceNullFive(){
		hasProduced = true;
		return null;
	}

	public static boolean hasProduced() {
		return hasProduced;
	}

}
