/*******************************************************************************
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
// Stub class generated by rmic, do not edit.
// Contents subject to change without notice.

package com.ibm.ws.clientcontainer.remote.common;

import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import java.lang.String;
import java.lang.Throwable;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class _ClientSupport_Stub extends Stub implements ClientSupport {
    
    private static final String[] _type_ids = {
        "RMI:com.ibm.ws.clientcontainer.remote.common.ClientSupport:0000000000000000"
    };
    
    public String[] _ids() { 
        return (String [] )  _type_ids.clone();
    }
    
    public RemoteObjectInstance getRemoteObjectInstance(String arg0, String arg1, String arg2, String arg3, String arg4) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("getRemoteObjectInstance", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        out.write_value(arg3,String.class);
                        out.write_value(arg4,String.class);
                        in = (InputStream)_invoke(out);
                        return (RemoteObjectInstance) in.read_value(RemoteObjectInstance.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("getRemoteObjectInstance",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    RemoteObjectInstance result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).getRemoteObjectInstance(arg0, arg1, arg2, arg3, arg4);
                    return (RemoteObjectInstance)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public boolean hasRemoteObjectWithPrefix(String arg0, String arg1, String arg2, String arg3, String arg4) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("hasRemoteObjectWithPrefix", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        out.write_value(arg3,String.class);
                        out.write_value(arg4,String.class);
                        in = (InputStream)_invoke(out);
                        return in.read_boolean();
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("hasRemoteObjectWithPrefix",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    return ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).hasRemoteObjectWithPrefix(arg0, arg1, arg2, arg3, arg4);
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public Collection listRemoteInstances(String arg0, String arg1, String arg2, String arg3, String arg4) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("listRemoteInstances", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        out.write_value(arg3,String.class);
                        out.write_value(arg4,String.class);
                        in = (InputStream)_invoke(out);
                        return (Collection) in.read_value(Collection.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("listRemoteInstances",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    Collection result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).listRemoteInstances(arg0, arg1, arg2, arg3, arg4);
                    return (Collection)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public Set getEJBRmicCompatibleClasses(String arg0) throws RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("getEJBRmicCompatibleClasses", true);
                        out.write_value(arg0,String.class);
                        in = (InputStream)_invoke(out);
                        return (Set) in.read_value(Set.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("getEJBRmicCompatibleClasses",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    Set result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).getEJBRmicCompatibleClasses(arg0);
                    return (Set)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public RemoteObjectInstance createEJB(String arg0, String arg1, String arg2) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("createEJB__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        in = (InputStream)_invoke(out);
                        return (RemoteObjectInstance) in.read_value(RemoteObjectInstance.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("createEJB__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    RemoteObjectInstance result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).createEJB(arg0, arg1, arg2);
                    return (RemoteObjectInstance)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public RemoteObjectInstance createEJB(String arg0, String arg1, String arg2, String arg3) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("createEJB__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        out.write_value(arg3,String.class);
                        in = (InputStream)_invoke(out);
                        return (RemoteObjectInstance) in.read_value(RemoteObjectInstance.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("createEJB__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue__CORBA_WStringValue",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    RemoteObjectInstance result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).createEJB(arg0, arg1, arg2, arg3);
                    return (RemoteObjectInstance)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public RemoteObjectInstance findEJBByBeanName(String arg0, String arg1, String arg2) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("findEJBByBeanName", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        out.write_value(arg2,String.class);
                        in = (InputStream)_invoke(out);
                        return (RemoteObjectInstance) in.read_value(RemoteObjectInstance.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("findEJBByBeanName",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    RemoteObjectInstance result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).findEJBByBeanName(arg0, arg1, arg2);
                    return (RemoteObjectInstance)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
    
    public RemoteObjectInstance findEJBByInterface(String arg0, String arg1) throws NamingException, RemoteException {
        while(true) {
            if (!Util.isLocal(this)) {
                InputStream in = null;
                try {
                    try {
                        OutputStream out = 
                            (OutputStream)
                            _request("findEJBByInterface", true);
                        out.write_value(arg0,String.class);
                        out.write_value(arg1,String.class);
                        in = (InputStream)_invoke(out);
                        return (RemoteObjectInstance) in.read_value(RemoteObjectInstance.class);
                    } catch (ApplicationException ex) {
                        in = (InputStream) ex.getInputStream();
                        String id = in.read_string();
                        if (id.equals("IDL:javax/naming/NamingEx:1.0")) {
                            throw (NamingException) in.read_value(NamingException.class);
                        }
                        throw new UnexpectedException(id);
                    } catch (RemarshalException ex) {
                        continue;
                    }
                } catch (SystemException ex) {
                    throw Util.mapSystemException(ex);
                } finally {
                    _releaseReply(in);
                }
            } else {
                ServantObject so = _servant_preinvoke("findEJBByInterface",com.ibm.ws.clientcontainer.remote.common.ClientSupport.class);
                if (so == null) {
                    continue;
                }
                try {
                    RemoteObjectInstance result = ((com.ibm.ws.clientcontainer.remote.common.ClientSupport)so.servant).findEJBByInterface(arg0, arg1);
                    return (RemoteObjectInstance)Util.copyObject(result,_orb());
                } catch (Throwable ex) {
                    Throwable exCopy = (Throwable)Util.copyObject(ex,_orb());
                    if (exCopy instanceof NamingException) {
                        throw (NamingException)exCopy;
                    }
                    throw Util.wrapException(exCopy);
                } finally {
                    _servant_postinvoke(so);
                }
            }
        }
    }
}
