/*******************************************************************************
 * Copyright (c) 2019,2021 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jaxws.test.wsr.server.stub;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6 in JDK 6
 * Generated source version: 2.1
 *
 */
@WebServiceClient(name = "PeopleService", targetNamespace = "http://server.wsr.test.jaxws.ws.ibm.com", wsdlLocation = "PeopleService.wsdl")
public class PeopleService extends Service {

    private final static URL PEOPLESERVICE_WSDL_LOCATION;
    private final static Logger logger = Logger.getLogger(com.ibm.ws.jaxws.test.wsr.server.stub.PeopleService.class.getName());

    static {
        URL url = null;
        try {
            URL baseUrl;
            baseUrl = com.ibm.ws.jaxws.test.wsr.server.stub.PeopleService.class.getResource(".");
            url = new URL(baseUrl, "PeopleService.wsdl");
        } catch (MalformedURLException e) {
            logger.warning("Failed to create URL for the wsdl Location: 'PeopleService.wsdl', retrying as a local file");
            logger.warning(e.getMessage());
        }
        PEOPLESERVICE_WSDL_LOCATION = url;
    }

    public PeopleService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public PeopleService() {
        this(PEOPLESERVICE_WSDL_LOCATION);
    }

    public PeopleService(URL wsdlLocation) {
        super(wsdlLocation, new QName("http://server.wsr.test.jaxws.ws.ibm.com", "PeopleService"));
    }

    /**
     *
     * @return
     *         returns People
     */
    @WebEndpoint(name = "BillPort")
    public People getBillPort() {
        return super.getPort(new QName("http://server.wsr.test.jaxws.ws.ibm.com", "BillPort"), People.class);
    }

    /**
     *
     * @param features
     *                     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy. Supported features not in the <code>features</code> parameter will have their
     *                     default
     *                     values.
     * @return
     *         returns People
     */
    @WebEndpoint(name = "BillPort")
    public People getBillPort(WebServiceFeature... features) {
        return super.getPort(new QName("http://server.wsr.test.jaxws.ws.ibm.com", "BillPort"), People.class, features);
    }

}
