/*******************************************************************************
 * Copyright (c) 2003, 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.adapter.spi;

import java.io.Serializable;

import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

/**
 * Implementation class of ManagedConnectionFactory
 */
public class ManagedConnectionFactoryXATranImpl extends ManagedConnectionFactoryImpl implements ManagedConnectionFactory, Serializable, ResourceAdapterAssociation, ValidatingManagedConnectionFactory, TransactionSupport {

    private static final TraceComponent tc = Tr.register(ManagedConnectionFactoryLocTranImpl.class);

    /**
     * Constructor.<p>
     */
    public ManagedConnectionFactoryXATranImpl() {

        super();
        if (tc.isDebugEnabled())
            Tr.debug(tc, "<init>");
        System.out.println("ManagedConnectionFactoryXATranImpl constructor " + this);

    }

    @Override
    public TransactionSupportLevel getTransactionSupport() {
        Tr.entry(tc, "getTransactionSupport");

        if (tc.isEntryEnabled())
            Tr.exit(tc, "getTransactionSupport", TransactionSupportLevel.XATransaction);

        return TransactionSupportLevel.XATransaction;

    }
}