/*******************************************************************************
 * Copyright (c) 2011, 2024 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.jpa.diagnostics.puparser;

public enum JPA_Schema {
    JPA_10(Constants.SUN_NAMESPACE, Constants.SCHEMA_LOCATION_10, "1.0", Constants.JPA_10_JAXB_PACKAGE),
    JPA_20(Constants.SUN_NAMESPACE, Constants.SCHEMA_LOCATION_20, "2.0", Constants.JPA_20_JAXB_PACKAGE),
    JPA_21(Constants.JCP_NAMESPACE, Constants.SCHEMA_LOCATION_21, "2.1", Constants.JPA_21_JAXB_PACKAGE),
    JPA_22(Constants.JCP_NAMESPACE, Constants.SCHEMA_LOCATION_22, "2.2", Constants.JPA_22_JAXB_PACKAGE),
    JPA_30(Constants.JAKARTA_NAMESPACE, Constants.SCHEMA_LOCATION_30, "3.0", Constants.JPA_30_JAXB_PACKAGE),
    JPA_32(Constants.JAKARTA_NAMESPACE, Constants.SCHEMA_LOCATION_32, "3.2", Constants.JPA_32_JAXB_PACKAGE);

    private String namespace;
    private String schema;
    private String version;
    private String jaxbPackage;

    private JPA_Schema(String namespace, String schema, String version, String jaxbPackage) {
        this.namespace = namespace;
        this.schema = schema;
        this.jaxbPackage = jaxbPackage;
        this.version = version;
    }

    public final String getNamespace() {
        return namespace;
    }

    public final String getSchema() {
        return schema;
    }

    public final String getVersion() {
        return version;
    }

    public final String getJaxbPackage() {
        return jaxbPackage;
    }

    public static JPA_Schema resolveByNameAndSchema(String namespace, String schema) {
        if (namespace == null || schema == null) {
            return null;
        }

        for (JPA_Schema j : JPA_Schema.values()) {
            if (j.getNamespace().equals(namespace) && j.getSchema().equals(schema)) {
                return j;
            }
        }

        return null;
    }

    public static JPA_Schema resolveByVersion(String version) {
        if (version == null) {
            return null;
        }

        for (JPA_Schema j : JPA_Schema.values()) {
            if (j.getVersion().equals(version)) {
                return j;
            }
        }

        return null;
    }

}
