CREATE TABLE ${schemaname}.JPA2Address (street VARCHAR(30) NOT NULL, city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5), PRIMARY KEY (street)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPA2Person (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPACustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPADeptBean (deptno INTEGER NOT NULL, budget REAL, name VARCHAR(40), charityAmount DOUBLE, charityName VARCHAR(40), MGR_EMPID INTEGER, REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAEmpBean (empid INTEGER NOT NULL, bonus DOUBLE, execLevel CHAR, hireDate DATE, hireTime TIME, hireTimestamp DATETIME, isManager BIT, name VARCHAR(40), rating INTEGER, salary DOUBLE, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPALineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE, quantity INTEGER, ORDER_OID INTEGER, PRODUCT_PID INTEGER, PRIMARY KEY (lid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE, delivered BIT, CUSTOMER_ID INTEGER, PRIMARY KEY (oid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAPartTab (partno INTEGER NOT NULL, name VARCHAR(40), PARTTYPE VARCHAR(31), assemblyCost DOUBLE, massIncrement DOUBLE, cost DOUBLE, mass DOUBLE, PRIMARY KEY (partno)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAProjectBean (projid INTEGER NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths TINYINT, startTime BIGINT, DEPT_DEPTNO INTEGER, PRIMARY KEY (projid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPASupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPATaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID INTEGER, PRIMARY KEY (taskid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID INTEGER) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPATypeTestBean (id INTEGER NOT NULL, ageofUniverse BIGINT, bigbytes BLOB, busPass BLOB, deficitUSA NUMERIC, i1 TINYINT, i2 SMALLINT, i4 INTEGER, i8 BIGINT, iboolean BIT, ibytes BLOB, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE, ifloat REAL, name VARCHAR(255), o1 TINYINT, o2 SMALLINT, o4 INTEGER, o8 BIGINT, oboolean BIT, obytes BLOB, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE, ofloat REAL, payScale VARCHAR(20), sdate DATE, status SMALLINT, stime TIME, stimestamp DATETIME, ucalendar DATETIME, udate DATETIME, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAUsagePartTab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.Person_residences (PERSON_ID INTEGER, street VARCHAR(30), city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5)) ENGINE = innodb;

CREATE TABLE ${schemaname}.JPAXMLAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLCustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLDeptBean (deptno INTEGER NOT NULL, budget REAL, name VARCHAR(40), MGR_EMPID integer, charityAmount DOUBLE, charityName VARCHAR(40), REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLEmpBean (empid integer NOT NULL, bonus DOUBLE, execLevel CHAR, hireDate DATE, hireTime TIME, hireTimestamp DATETIME, isManager BIT, name VARCHAR(40), rating INTEGER, salary DOUBLE, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLLineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE, quantity INTEGER, PRODUCT_PID INTEGER, ORDER_OID INTEGER, PRIMARY KEY (lid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE, delivered BIT, CUSTOMER_ID INTEGER, PRIMARY KEY (oid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLPartTab (partno INTEGER NOT NULL, name VARCHAR(40), XMLPARTTYPE VARCHAR(255), assemblyCost DOUBLE, massIncrement DOUBLE, cost DOUBLE, mass DOUBLE, PRIMARY KEY (partno)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLProjectBean (projid integer NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths TINYINT, startTime BIGINT, DEPT_DEPTNO INTEGER, PRIMARY KEY (projid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLTaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID integer, PRIMARY KEY (taskid)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID integer) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLTypeTestBean (id INTEGER NOT NULL, ageofUniverse BIGINT, bigbytes BLOB, busPass BLOB, deficitUSA NUMERIC, i1 TINYINT, i2 SMALLINT, i4 INTEGER, i8 BIGINT, iboolean BIT, ibytes BLOB, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE, ifloat REAL, name VARCHAR(255), o1 TINYINT, o2 SMALLINT, o4 INTEGER, o8 BIGINT, oboolean BIT, obytes BLOB, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE, ofloat REAL, payScale VARCHAR(20), sdate DATE, status SMALLINT, stime TIME, stimestamp DATETIME, ucalendar DATETIME, udate DATETIME, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLUsageparttab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id)) ENGINE = innodb;
CREATE TABLE ${schemaname}.JPAXMLXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) ENGINE = innodb;

CREATE INDEX ${schemaname}.I_JPDPTBN_MGR ON ${schemaname}.JPADeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPDPTBN_REPORTSTO ON ${schemaname}.JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_DEPT ON ${schemaname}.JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_HOME ON ${schemaname}.JPAEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPMPBEN_WORK ON ${schemaname}.JPAEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPLNTTB_ORDER ON ${schemaname}.JPALineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPLNTTB_PRODUCT ON ${schemaname}.JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPRDTTB_CUSTOMER ON ${schemaname}.JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPPRTTB_DTYPE ON ${schemaname}.JPAPartTab (PARTTYPE);
CREATE INDEX ${schemaname}.I_JPPRTTB_SUPPLIER ON ${schemaname}.JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPPRTBN_DEPT ON ${schemaname}.JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_ELEMENT ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_SUPPLIERS_SID ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPTSKBN_PROJECT ON ${schemaname}.JPATaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPTSPBN_ELEMENT ON ${schemaname}.JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPTSPBN_TASKS_TASKID ON ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPSGTTB_CHILD ON ${schemaname}.JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPSGTTB_PARENT ON ${schemaname}.JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX ${schemaname}.I_PRSNNCS_PERSON_ID ON ${schemaname}.Person_residences (PERSON_ID);

CREATE INDEX ${schemaname}.I_JPXMTBN_MGR ON ${schemaname}.JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPXMTBN_REPORTSTO ON ${schemaname}.JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_DEPT ON ${schemaname}.JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_HOME ON ${schemaname}.JPAXMLEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPXMPBN_WORK ON ${schemaname}.JPAXMLEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPXMTTB_ORDER ON ${schemaname}.JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPXMTTB_PRODUCT ON ${schemaname}.JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CUSTOMER ON ${schemaname}.JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPXMTTB_DTYPE ON ${schemaname}.JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIER ON ${schemaname}.JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPXMTBN_DEPT ON ${schemaname}.JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_ELEMENT ON ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIERS_SID ON ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPXMKBN_PROJECT ON ${schemaname}.JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPXMPBN_ELEMENT ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPXMPBN_TASKS_TASKID ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CHILD ON ${schemaname}.JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_PARENT ON ${schemaname}.JPAXMLUsageparttab (PARENT_PARTNO);
