/*******************************************************************************
 * Copyright (c) 2022 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.jpa.tests.spec10.query;

import com.ibm.ws.testtooling.jpaprovider.JPAPersistenceProvider;

import componenttest.custom.junit.runner.Mode.TestMode;
import componenttest.rules.repeater.EE8FeatureReplacementAction;

public class RepeatWithJPA22OpenJPA extends EE8FeatureReplacementAction {
    public static final String ID = "JPA22_OPENJPA";

    /**
     * Restrict OpenJPA tests to run on FULL mode
     */
    public RepeatWithJPA22OpenJPA() {
        // Used in componenttest.rules.repeater.RepeatTestAction.isEnabled() to determine if the test should run
        withTestMode(TestMode.FULL);
    }

    @Override
    public String toString() {
        return "Switch to JPA Container 2.2 feature and use OpenJPA for JPA persistence provider";
    }

    @Override
    public void setup() throws Exception {
        FATSuite.repeatPhase = "openjpa22-cfg.xml";
        FATSuite.provider = JPAPersistenceProvider.OPENJPA;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public boolean isEnabled() {
        // Disable testing against OpenJPA for time constraints
        if (!Boolean.getBoolean("jpa.enable.repeat.openjpa"))
            return false;

        return super.isEnabled();
    }
}
