/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.uow;

/** 
 * An interface for components which support sending callback EVENTS to interested listeners.
 * Listeners can register using the registerCallback method.  Maybe this should be called
 * addListener ????
 */
public interface UOWScopeCallbackAgent
{
    void registerCallback(UOWScopeCallback callback);
    void unregisterCallback(UOWScopeCallback callback);
}
