/*******************************************************************************
 * Copyright (c) 2014, 2021 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.javaee.ddmodel.client;

import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.AltDDEntryGetter;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;

public final class ApplicationClientAdapter implements ContainerAdapter<ApplicationClient> {

    @Override
    public ApplicationClient adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        NonPersistentCache cache = containerToAdapt.adapt(NonPersistentCache.class);
        ApplicationClient appClient = (ApplicationClient)
            cache.getFromCache(ApplicationClient.class);
        if ( appClient != null ) {
            return appClient;
        }

        Entry ddEntry = null;
        AltDDEntryGetter altDDGetter = (AltDDEntryGetter)
            cache.getFromCache(AltDDEntryGetter.class);
        if ( altDDGetter != null ) {
            ddEntry = altDDGetter.getAltDDEntry(ContainerInfo.Type.CLIENT_MODULE);
        }
        if ( ddEntry == null ) {
            ddEntry = containerToAdapt.getEntry(ApplicationClient.DD_NAME);
        }
        if ( ddEntry == null ) {
            return null;
        }

        return ddEntry.adapt(ApplicationClient.class);
    }

}
