/*******************************************************************************
 * Copyright (c) 2017, 2023 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jaxrs20.clientconfig;

/**
 *
 */
public class JAXRSClientConstants {

    public final static String TR_GROUP = "com.ibm.ws.jaxrs20.client";
    public final static String TR_RESOURCE_BUNDLE = "com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages";
    public final static String SSL_REFKEY = "com.ibm.ws.jaxrs.client.ssl.config";
    public final static String CONNECTION_TIMEOUT = "com.ibm.ws.jaxrs.client.connection.timeout";
    public final static String RECEIVE_TIMEOUT = "com.ibm.ws.jaxrs.client.receive.timeout";
    public final static long TIMEOUT_DEFAULT = 30000;
    public final static String PROXY_HOST = "com.ibm.ws.jaxrs.client.proxy.host";
    public final static String PROXY_PORT = "com.ibm.ws.jaxrs.client.proxy.port";
    public final static String PROXY_TYPE = "com.ibm.ws.jaxrs.client.proxy.type";
    public final static String PROXY_AUTH_TYPE = "com.ibm.ws.jaxrs.client.proxy.authType";
    public final static String PROXY_AUTH_TYPE_DEFAULT = "Basic";
    public final static String PROXY_USERNAME = "com.ibm.ws.jaxrs.client.proxy.username";
    public final static String PROXY_PASSWORD = "com.ibm.ws.jaxrs.client.proxy.password";
    public final static int PROXY_PORT_DEFAULT = 80;
    public final static String LTPA_HANDLER = "com.ibm.ws.jaxrs.client.ltpa.handler";
    public static final String OAUTH_HANDLER = "com.ibm.ws.jaxrs.client.oauth.sendToken";
    public static final String JWT_HANDLER = "com.ibm.ws.jaxrs.client.oidc.sendJwtToken";
    public static final String MPJWT_HANDLER = "com.ibm.ws.jaxrs.client.mpjwt.sendToken";
    public static final String DISABLE_CN_CHECK = "com.ibm.ws.jaxrs.client.disableCNCheck";
    public final static String SAML_HANDLER = "com.ibm.ws.jaxrs.client.saml.sendToken";
    public final static String KEEP_ALIVE_CONNECTION = "com.ibm.ws.jaxrs.client.keepalive.connection"; // valid values are "keep-alive" and "close"
    public final static String USE_HTTPS_URL_CONNECTION_DEFAULT_SSLSOCKETFACTORY = "com.ibm.ws.jaxrs.client.useHttpsURLConnectionDefaultSslSocketFactory";
}