
package hello;

import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.ws.Holder;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.10
 * Generated source version: 2.2
 * wsdlLocation = "/WEB-INF/wsdl/HelloIF.wsdl"
 *
 * @javax.xml.ws.BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
 */
@WebService(portName = "HelloIF", serviceName = "HelloIF", targetNamespace = "http://hello", endpointInterface = "hello.HelloIF")
@HandlerChain(file = "handler-chain.xml")
public class HelloIF_HelloIFImpl implements HelloIF {

    public HelloIF_HelloIFImpl() {
    }

    /**
     * This method receives to Holder of type Address both of which are both marked as WebParam.Mode.INOUT
     *
     * @param address
     * @param address2
     */
    @Override
    public void updateAddress(Holder<Address> address, Holder<Address> address2) {

        // For different address tests set Address to same value as expected when returned tp client
        if (address.value.getCity() == null) {
            address.value = createAddress("EN", "Bap Bow", "S Bap St", 421, 84104, StateType.IN);
        } else if (!address.value.getCity().equals(("Bap Bow"))) {
            address.value = createAddress("EN", "Bap Bow", "S Bap St", 421, 84104, StateType.IN);
        }
        if (address2.value.getStreetName() == null) {
            address2.value = createAddress("EN", "Skippity Bow", "N Fresh St", 1, 84132, StateType.TX);
        } else if (!address2.value.getCity().equals(("Skippity Bow"))) {
            address2.value = createAddress("EN", "Skippity Bow", "N Fresh St", 1, 84132, StateType.TX);
        }

        /*
         * Comment these out these lines if you need to debug the Address values
         *
         * System.out.println("**** HelloIF Impl printing Address 1 ***");
         * printAddress(address.value);
         *
         * System.out.println("**** HelloIF Impl printing Address 2 ***");
         * printAddress(address2.value);
         *
         */
    }

    /**
     *
     * @param address
     * @param address2
     */
    @Override
    public void sayHelloHeader(Holder<Address> address, Holder<Header> header) {

        // For Empty Addresses will have a 0 set by default for integers
        if (address.value == null) {
            address.value = createAddress("EN", "Bap Bow", "S Bap St", 421, 84104, StateType.IN);
        }
        if (header.value.getAddress().getStreetNum() == 0) {
            System.out.println("We Are here");
            Location<Address> location = new Location<Address>();
            Header headerType = new Header();
            location.setAddress(createAddress("EN", "Cram City", "W Cram Circle", 7, 84132, StateType.TX));
            headerType.setAddress(createAddress("EN", "Skippity Bow", "N Fresh St", 1, 84132, StateType.TX));
            headerType.setLocation(location);
            header.value = headerType;
        }

        // For null values in paramters sent from the client, update addresses to have expected values
        if (address.value.getCity() == null) {
            address.value.setCity("Bap Bow");
        }
        if (header.value.getAddress().getStreetName() == null) {
            header.value.getAddress().setStreetName("N Fresh St");
        }
        if (header.value.getLocation().getAddress().getState() == null) {
            header.value.getLocation().getAddress().setState(StateType.TX);
        }

        /*
         * Comment these out these lines if you need to debug the Address values
         *
         * System.out.println("**** HelloIF Impl printing Address 1 ***");
         * printAddress(address.value);
         *
         * System.out.println("**** HelloIF Impl printing Address 2 ***");
         * printAddress(address2.value);
         *
         */
    }

    /*
     * Method for instantating a new address with given values
     */
    private Address createAddress(String lang, String city, String streetName, int streetNum, int zip, StateType state) {
        Address add = new Address();
        add.setCity(city);
        add.setLang(lang);
        add.setStreetName(streetName);
        add.setStreetNum(streetNum);
        add.setZip(zip);
        add.setState(state);
        return add;
    }

    /**
     * Test method that can be used to check the values of the test
     *
     * @param value
     */
    private void printAddress(Address address) {
        System.out.println("Address = \n"
                           + "\n " + address.getStreetNum() + " " + address.getStreetName()
                           + "\n" + address.getCity()
                           + "\n" + address.getZip()
                           + "\n" + address.getState()
                           + "\n" + address.getLang());
    }

}
