/*******************************************************************************
 * Copyright (c) 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jaxws.support;

import java.util.Map;

import com.ibm.ws.jaxws.support.JaxWsInstanceManager.InstanceInterceptor;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager.InterceptException;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager.InterceptorContext;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.injectionengine.InjectionTarget;

/**
 *
 */
public class ReferenceContextInjectionInstanceInterceptor implements InstanceInterceptor {

    private final Map<Class<?>, ReferenceContext> referenceContextMap;

    public ReferenceContextInjectionInstanceInterceptor(Map<Class<?>, ReferenceContext> referenceContextMap) {
        this.referenceContextMap = referenceContextMap;
    }

    @Override
    public void postNewInstance(InterceptorContext ctx) throws InterceptException {
        try {
            Object instance = ctx.getInstance();
            ReferenceContext referenceContext = referenceContextMap.get(instance.getClass());

            if (referenceContext != null) {

                InjectionTarget[] injectionTargets = referenceContext.getInjectionTargets(instance.getClass());

                if (injectionTargets == null || injectionTargets.length == 0) {
                    return;
                }

                for (InjectionTarget injectionTarget : injectionTargets) {
                    injectionTarget.inject(instance, null);
                }
            }
        } catch (InjectionException e) {
            throw new InterceptException(e);
        }
    }

    @Override
    public void postInjectInstance(InterceptorContext ctx) {
    }

    @Override
    public void preDestroyInstance(InterceptorContext ctx) throws InterceptException {
    }

}
