/*******************************************************************************
 * Copyright (c) 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jaxws.ejbwsprovider;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 *
 */
public class StaticUserRepository {

    private static final Map<String, User> nameUserMap = new HashMap<String, User>();

    static {
        nameUserMap.put("Arugal", new User("Arugal", new Date(System.currentTimeMillis())));
        nameUserMap.put("Illidan Stormrage", new User("Illidan Stormrage", new Date(System.currentTimeMillis() - 24 * 3600 * 1000 * 15L)));
        nameUserMap.put("Hakkar", new User("Hakkar", new Date(System.currentTimeMillis() - 24 * 3600 * 1000 * 30L)));
    }

    public static User getUser(String userName) throws UserNotFoundException_Exception {
        User user = nameUserMap.get(userName);
        if (user == null) {
            UserNotFoundException userNotFoundExceptionInfo = new UserNotFoundException();
            userNotFoundExceptionInfo.setUserName(userName);
            throw new UserNotFoundException_Exception("User " + userName + " could not be found", userNotFoundExceptionInfo);
        }
        return user;
    }

    public static User[] listUsers() {
        return nameUserMap.values().toArray(new User[] {});
    }
}
