/*******************************************************************************
 * Copyright (c) 2012, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jca.utils.xml.wlp.ra;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import com.ibm.websphere.ras.annotation.Trivial;

/**
 * ra.xml inbound-resourceadapter element
 */
@Trivial
@XmlType
public class WlpRaInboundResourceAdapter {
    private WlpRaMessageAdapter messageAdapter;

    @XmlElement(name = "messageadapter")
    public void setMessageAdapter(WlpRaMessageAdapter messageAdapter) {
        this.messageAdapter = messageAdapter;
    }

    public WlpRaMessageAdapter getMessageAdapter() {
        return messageAdapter;
    }

    @Override
    public String toString() {
        return "WlpRaInboundResourceAdapter{" + messageAdapter.toString() + "}";
    }
}
