CREATE TABLE ${schemaname}.JPA2Address (street VARCHAR(30) NOT NULL, city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5), PRIMARY KEY (street)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPA2Person (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPACustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPADeptBean (deptno INTEGER NOT NULL, budget REAL, name VARCHAR(40), charityAmount DOUBLE PRECISION, charityName VARCHAR(40), MGR_EMPID INTEGER, REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAEmpBean (empid INTEGER NOT NULL, bonus DOUBLE PRECISION, execLevel INTEGER, hireDate DATE, hireTime DATETIME HOUR TO SECOND, hireTimestamp DATETIME YEAR TO FRACTION(3), isManager BOOLEAN, name VARCHAR(40), rating INTEGER, salary DOUBLE PRECISION, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPALineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE PRECISION, quantity INTEGER, ORDER_OID INTEGER, PRODUCT_PID INTEGER, PRIMARY KEY (lid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE PRECISION, delivered BOOLEAN, CUSTOMER_ID INTEGER, PRIMARY KEY (oid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAPartTab (partno INTEGER NOT NULL, name VARCHAR(40), PARTTYPE VARCHAR(31), assemblyCost DOUBLE PRECISION, massIncrement DOUBLE PRECISION, cost DOUBLE PRECISION, mass DOUBLE PRECISION, PRIMARY KEY (partno)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAProjectBean (projid INTEGER NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays INT8, name VARCHAR(40), personMonths INT8, startTime NUMERIC(32,0), DEPT_DEPTNO INTEGER, PRIMARY KEY (projid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPASupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPATaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID INTEGER, PRIMARY KEY (taskid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID INTEGER) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPATypeTestBean (id INTEGER NOT NULL, ageofUniverse NUMERIC(32,0), bigbytes BYTE, busPass BYTE, deficitUSA NUMERIC, i1 INT8, i2 INT8, i4 INTEGER, i8 NUMERIC(32,0), iboolean BOOLEAN, ibytes BYTE, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE PRECISION, ifloat REAL, name VARCHAR(255), o1 INT8, o2 INT8, o4 INTEGER, o8 NUMERIC(32,0), oboolean BOOLEAN, obytes BYTE, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE PRECISION, ofloat REAL, payScale VARCHAR(20), sdate DATE, status INT8, stime DATETIME HOUR TO SECOND, stimestamp DATETIME YEAR TO FRACTION(3), ucalendar DATETIME YEAR TO FRACTION(3), udate DATETIME YEAR TO FRACTION(3), PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAUsagePartTab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.Person_residences (PERSON_ID INTEGER, street VARCHAR(30), city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5)) LOCK MODE ROW;

CREATE TABLE ${schemaname}.JPAXMLAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLCustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLDeptBean (deptno INTEGER NOT NULL, budget REAL, name VARCHAR(40), MGR_EMPID integer, charityAmount DOUBLE PRECISION, charityName VARCHAR(40), REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLEmpBean (empid integer NOT NULL, bonus DOUBLE PRECISION, execLevel INTEGER, hireDate DATE, hireTime DATETIME HOUR TO SECOND, hireTimestamp DATETIME YEAR TO FRACTION(3), isManager BOOLEAN, name VARCHAR(40), rating INTEGER, salary DOUBLE PRECISION, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLLineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE PRECISION, quantity INTEGER, PRODUCT_PID INTEGER, ORDER_OID INTEGER, PRIMARY KEY (lid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE PRECISION, delivered BOOLEAN, CUSTOMER_ID INTEGER, PRIMARY KEY (oid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLPartTab (partno INTEGER NOT NULL, name VARCHAR(40), XMLPARTTYPE VARCHAR(255), assemblyCost DOUBLE PRECISION, massIncrement DOUBLE PRECISION, cost DOUBLE PRECISION, mass DOUBLE PRECISION, PRIMARY KEY (partno)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLProjectBean (projid integer NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays INT8, name VARCHAR(40), personMonths INT8, startTime NUMERIC(32,0), DEPT_DEPTNO INTEGER, PRIMARY KEY (projid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLTaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID integer, PRIMARY KEY (taskid)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID integer) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLTypeTestBean (id INTEGER NOT NULL, ageofUniverse NUMERIC(32,0), bigbytes BYTE, busPass BYTE, deficitUSA NUMERIC, i1 INT8, i2 INT8, i4 INTEGER, i8 NUMERIC(32,0), iboolean BOOLEAN, ibytes BYTE, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE PRECISION, ifloat REAL, name VARCHAR(255), o1 INT8, o2 INT8, o4 INTEGER, o8 NUMERIC(32,0), oboolean BOOLEAN, obytes BYTE, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE PRECISION, ofloat REAL, payScale VARCHAR(20), sdate DATE, status INT8, stime DATETIME HOUR TO SECOND, stimestamp DATETIME YEAR TO FRACTION(3), ucalendar DATETIME YEAR TO FRACTION(3), udate DATETIME YEAR TO FRACTION(3), PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLUsageparttab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id)) LOCK MODE ROW;
CREATE TABLE ${schemaname}.JPAXMLXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id)) LOCK MODE ROW;

CREATE INDEX ${schemaname}.I_JPDPTBN_MGR ON ${schemaname}.JPADeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPDPTBN_REPORTSTO ON ${schemaname}.JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_DEPT ON ${schemaname}.JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_HOME ON ${schemaname}.JPAEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPMPBEN_WORK ON ${schemaname}.JPAEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPLNTTB_ORDER ON ${schemaname}.JPALineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPLNTTB_PRODUCT ON ${schemaname}.JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPRDTTB_CUSTOMER ON ${schemaname}.JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPPRTTB_DTYPE ON ${schemaname}.JPAPartTab (PARTTYPE);
CREATE INDEX ${schemaname}.I_JPPRTTB_SUPPLIER ON ${schemaname}.JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPPRTBN_DEPT ON ${schemaname}.JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_ELEMENT ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_SUPPLIERS_SID ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPTSKBN_PROJECT ON ${schemaname}.JPATaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPTSPBN_ELEMENT ON ${schemaname}.JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPTSPBN_TASKS_TASKID ON ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPSGTTB_CHILD ON ${schemaname}.JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPSGTTB_PARENT ON ${schemaname}.JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX ${schemaname}.I_PRSNNCS_PERSON_ID ON ${schemaname}.Person_residences (PERSON_ID);

CREATE INDEX ${schemaname}.I_JPXMTBN_MGR ON ${schemaname}.JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPXMTBN_REPORTSTO ON ${schemaname}.JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_DEPT ON ${schemaname}.JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_HOME ON ${schemaname}.JPAXMLEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPXMPBN_WORK ON ${schemaname}.JPAXMLEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPXMTTB_ORDER ON ${schemaname}.JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPXMTTB_PRODUCT ON ${schemaname}.JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CUSTOMER ON ${schemaname}.JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPXMTTB_DTYPE ON ${schemaname}.JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIER ON ${schemaname}.JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPXMTBN_DEPT ON ${schemaname}.JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_ELEMENT ON ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIERS_SID ON ${schemaname}.JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPXMKBN_PROJECT ON ${schemaname}.JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPXMPBN_ELEMENT ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPXMPBN_TASKS_TASKID ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CHILD ON ${schemaname}.JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_PARENT ON ${schemaname}.JPAXMLUsageparttab (PARENT_PARTNO);
