CREATE TABLE JPA2Address (street VARCHAR(30) NOT NULL, city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5), PRIMARY KEY (street));
CREATE TABLE JPA2Person (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));
CREATE TABLE JPAAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street));
CREATE TABLE JPACustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id));
CREATE TABLE JPADeptBean (deptno INTEGER NOT NULL, budget FLOAT4, name VARCHAR(40), charityAmount DOUBLE PRECISION, charityName VARCHAR(40), MGR_EMPID INTEGER, REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno));
CREATE TABLE JPAEmpBean (empid INTEGER NOT NULL, bonus DOUBLE PRECISION, execLevel CHAR, hireDate DATE, hireTime TIME, hireTimestamp TIMESTAMP, isManager BOOL, name VARCHAR(40), rating INTEGER, salary DOUBLE PRECISION, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid));
CREATE TABLE JPALineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE PRECISION, quantity INTEGER, ORDER_OID INTEGER, PRODUCT_PID INTEGER, PRIMARY KEY (lid));
CREATE TABLE JPAOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE PRECISION, delivered BOOL, CUSTOMER_ID INTEGER, PRIMARY KEY (oid));
CREATE TABLE JPAPartTab (partno INTEGER NOT NULL, name VARCHAR(40), PARTTYPE VARCHAR(31), assemblyCost DOUBLE PRECISION, massIncrement DOUBLE PRECISION, cost DOUBLE PRECISION, mass DOUBLE PRECISION, PRIMARY KEY (partno));
CREATE TABLE JPAProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid));
CREATE TABLE JPAProjectBean (projid INTEGER NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths SMALLINT, startTime BIGINT, DEPT_DEPTNO INTEGER, PRIMARY KEY (projid));
CREATE TABLE JPASupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid));
CREATE TABLE JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER);
CREATE TABLE JPATaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID INTEGER, PRIMARY KEY (taskid));
CREATE TABLE JPATaskBean_JPAEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID INTEGER);
CREATE TABLE JPATypeTestBean (id INTEGER NOT NULL, ageofUniverse BIGINT, bigbytes BYTEA, busPass BYTEA, deficitUSA NUMERIC, i1 SMALLINT, i2 SMALLINT, i4 INTEGER, i8 BIGINT, iboolean BOOL, ibytes BYTEA, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE PRECISION, ifloat FLOAT4, name VARCHAR(255), o1 SMALLINT, o2 SMALLINT, o4 INTEGER, o8 BIGINT, oboolean BOOL, obytes BYTEA, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE PRECISION, ofloat FLOAT4, payScale VARCHAR(20), sdate DATE, status SMALLINT, stime TIME, stimestamp TIMESTAMP, ucalendar TIMESTAMP, udate TIMESTAMP, PRIMARY KEY (id));
CREATE TABLE JPAUsagePartTab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id));
CREATE TABLE JPAXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));
CREATE TABLE Person_residences (PERSON_ID INTEGER, street VARCHAR(30), city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5));

CREATE TABLE JPAXMLAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street));
CREATE TABLE JPAXMLCustomerPartTab (id INTEGER NOT NULL, name VARCHAR(40), rating INTEGER, PRIMARY KEY (id));
CREATE TABLE JPAXMLDeptBean (deptno INTEGER NOT NULL, budget FLOAT4, name VARCHAR(40), MGR_EMPID integer, charityAmount DOUBLE PRECISION, charityName VARCHAR(40), REPORTSTO_DEPTNO INTEGER, PRIMARY KEY (deptno));
CREATE TABLE JPAXMLEmpBean (empid integer NOT NULL, bonus DOUBLE PRECISION, execLevel CHAR, hireDate DATE, hireTime TIME, hireTimestamp TIMESTAMP, isManager BOOL, name VARCHAR(40), rating INTEGER, salary DOUBLE PRECISION, DEPT_DEPTNO INTEGER, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid));
CREATE TABLE JPAXMLLineItemPartTab (lid INTEGER NOT NULL, cost DOUBLE PRECISION, quantity INTEGER, PRODUCT_PID INTEGER, ORDER_OID INTEGER, PRIMARY KEY (lid));
CREATE TABLE JPAXMLOrderPartTab (oid INTEGER NOT NULL, amount DOUBLE PRECISION, delivered BOOL, CUSTOMER_ID INTEGER, PRIMARY KEY (oid));
CREATE TABLE JPAXMLPartTab (partno INTEGER NOT NULL, name VARCHAR(40), XMLPARTTYPE VARCHAR(255), assemblyCost DOUBLE PRECISION, massIncrement DOUBLE PRECISION, cost DOUBLE PRECISION, mass DOUBLE PRECISION, PRIMARY KEY (partno));
CREATE TABLE JPAXMLProductPartTab (pid INTEGER NOT NULL, backorder INTEGER, description VARCHAR(40), inventory INTEGER, SUPPLIER_ID INTEGER, PRIMARY KEY (pid));
CREATE TABLE JPAXMLProjectBean (projid integer NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths SMALLINT, startTime BIGINT, DEPT_DEPTNO INTEGER, PRIMARY KEY (projid));
CREATE TABLE JPAXMLSupplierPartTab (sid INTEGER NOT NULL, name VARCHAR(40), PRIMARY KEY (sid));
CREATE TABLE JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID INTEGER, SUPPLIES_PARTNO INTEGER);
CREATE TABLE JPAXMLTaskBean (taskid INTEGER NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID integer, PRIMARY KEY (taskid));
CREATE TABLE JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID INTEGER, EMPS_EMPID integer);
CREATE TABLE JPAXMLTypeTestBean (id INTEGER NOT NULL, ageofUniverse BIGINT, bigbytes BYTEA, busPass BYTEA, deficitUSA NUMERIC, i1 SMALLINT, i2 SMALLINT, i4 INTEGER, i8 BIGINT, iboolean BOOL, ibytes BYTEA, ic INTEGER, ichars VARCHAR(255), idouble DOUBLE PRECISION, ifloat FLOAT4, name VARCHAR(255), o1 SMALLINT, o2 SMALLINT, o4 INTEGER, o8 BIGINT, oboolean BOOL, obytes BYTEA, oc INTEGER, ochars VARCHAR(255), odouble DOUBLE PRECISION, ofloat FLOAT4, payScale VARCHAR(20), sdate DATE, status SMALLINT, stime TIME, stimestamp TIMESTAMP, ucalendar TIMESTAMP, udate TIMESTAMP, PRIMARY KEY (id));
CREATE TABLE JPAXMLUsageparttab (id INTEGER NOT NULL, quantity INTEGER, CHILD_PARTNO INTEGER, PARENT_PARTNO INTEGER, PRIMARY KEY (id));
CREATE TABLE JPAXMLXYZ (id INTEGER NOT NULL, age INTEGER, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));

CREATE INDEX I_JPDPTBN_MGR ON JPADeptBean (MGR_EMPID);
CREATE INDEX I_JPDPTBN_REPORTSTO ON JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX I_JPMPBEN_DEPT ON JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX I_JPMPBEN_HOME ON JPAEmpBean (HOME_STREET);
CREATE INDEX I_JPMPBEN_WORK ON JPAEmpBean (WORK_STREET);
CREATE INDEX I_JPLNTTB_ORDER ON JPALineItemPartTab (ORDER_OID);
CREATE INDEX I_JPLNTTB_PRODUCT ON JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX I_JPRDTTB_CUSTOMER ON JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX I_JPPRTTB_DTYPE ON JPAPartTab (PARTTYPE);
CREATE INDEX I_JPPRTTB_SUPPLIER ON JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX I_JPPRTBN_DEPT ON JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX I_JPSPTTB_ELEMENT ON JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX I_JPSPTTB_SUPPLIERS_SID ON JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX I_JPTSKBN_PROJECT ON JPATaskBean (PROJECT_PROJID);
CREATE INDEX I_JPTSPBN_ELEMENT ON JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX I_JPTSPBN_TASKS_TASKID ON JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX I_JPSGTTB_CHILD ON JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX I_JPSGTTB_PARENT ON JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX I_PRSNNCS_PERSON_ID ON Person_residences (PERSON_ID);

CREATE INDEX I_JPXMTBN_MGR ON JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX I_JPXMTBN_REPORTSTO ON JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX I_JPXMPBN_DEPT ON JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX I_JPXMPBN_HOME ON JPAXMLEmpBean (HOME_STREET);
CREATE INDEX I_JPXMPBN_WORK ON JPAXMLEmpBean (WORK_STREET);
CREATE INDEX I_JPXMTTB_ORDER ON JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX I_JPXMTTB_PRODUCT ON JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX I_JPXMTTB_CUSTOMER ON JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX I_JPXMTTB_DTYPE ON JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX I_JPXMTTB_SUPPLIER ON JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX I_JPXMTBN_DEPT ON JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX I_JPXMTTB_ELEMENT ON JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIES_PARTNO);
CREATE INDEX I_JPXMTTB_SUPPLIERS_SID ON JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID);
CREATE INDEX I_JPXMKBN_PROJECT ON JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX I_JPXMPBN_ELEMENT ON JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX I_JPXMPBN_TASKS_TASKID ON JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX I_JPXMTTB_CHILD ON JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX I_JPXMTTB_PARENT ON JPAXMLUsageparttab (PARENT_PARTNO);
