CREATE TABLE JPA2Address (street VARCHAR(30) NOT NULL, city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5), PRIMARY KEY (street));
CREATE TABLE JPA2Person (id INT NOT NULL, age INT, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));
CREATE TABLE JPAAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street));
CREATE TABLE JPACustomerPartTab (id INT NOT NULL, name VARCHAR(40), rating INT, PRIMARY KEY (id));
CREATE TABLE JPADeptBean (deptno INT NOT NULL, budget REAL, name VARCHAR(40), charityAmount FLOAT(32), charityName VARCHAR(40), MGR_EMPID INT, REPORTSTO_DEPTNO INT, PRIMARY KEY (deptno));
CREATE TABLE JPAEmpBean (empid INT NOT NULL, bonus FLOAT(32), execLevel CHAR, hireDate DATETIME, hireTime DATETIME, hireTimestamp DATETIME, isManager BIT, name VARCHAR(40), rating INT, salary FLOAT(32), DEPT_DEPTNO INT, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid));
CREATE TABLE JPALineItemPartTab (lid INT NOT NULL, cost FLOAT(32), quantity INT, ORDER_OID INT, PRODUCT_PID INT, PRIMARY KEY (lid));
CREATE TABLE JPAOrderPartTab (oid INT NOT NULL, amount FLOAT(32), delivered BIT, CUSTOMER_ID INT, PRIMARY KEY (oid));
CREATE TABLE JPAPartTab (partno INT NOT NULL, name VARCHAR(40), PARTTYPE VARCHAR(31), assemblyCost FLOAT(32), massIncrement FLOAT(32), cost FLOAT(32), mass FLOAT(32), PRIMARY KEY (partno));
CREATE TABLE JPAProductPartTab (pid INT NOT NULL, backorder INT, description VARCHAR(40), inventory INT, SUPPLIER_ID INT, PRIMARY KEY (pid));
CREATE TABLE JPAProjectBean (projid INT NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths TINYINT, startTime BIGINT, DEPT_DEPTNO INT, PRIMARY KEY (projid));
CREATE TABLE JPASupplierPartTab (sid INT NOT NULL, name VARCHAR(40), PRIMARY KEY (sid));
CREATE TABLE JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID INT, SUPPLIES_PARTNO INT);
CREATE TABLE JPATaskBean (taskid INT NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID INT, PRIMARY KEY (taskid));
CREATE TABLE JPATaskBean_JPAEmpBean (TASKS_TASKID INT, EMPS_EMPID INT);
CREATE TABLE JPATypeTestBean (id INT NOT NULL, ageofUniverse BIGINT, bigbytes IMAGE, busPass IMAGE, deficitUSA NUMERIC, i1 TINYINT, i2 SMALLINT, i4 INT, i8 BIGINT, iboolean BIT, ibytes IMAGE, ic INT, ichars VARCHAR(255), idouble FLOAT(32), ifloat REAL, name VARCHAR(255), o1 TINYINT, o2 SMALLINT, o4 INT, o8 BIGINT, oboolean BIT, obytes IMAGE, oc INT, ochars VARCHAR(255), odouble FLOAT(32), ofloat REAL, payScale VARCHAR(20), sdate DATETIME, status SMALLINT, stime DATETIME, stimestamp DATETIME, ucalendar DATETIME, udate DATETIME, PRIMARY KEY (id));
CREATE TABLE JPAUsagePartTab (id INT NOT NULL, quantity INT, CHILD_PARTNO INT, PARENT_PARTNO INT, PRIMARY KEY (id));
CREATE TABLE JPAXYZ (id INT NOT NULL, age INT, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));
CREATE TABLE Person_residences (PERSON_ID INT, street VARCHAR(30), city VARCHAR(255), state VARCHAR(255), plusFour VARCHAR(4), zip VARCHAR(5));

CREATE TABLE JPAXMLAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30), state VARCHAR(20), zip VARCHAR(10), PRIMARY KEY (street));
CREATE TABLE JPAXMLCustomerPartTab (id INT NOT NULL, name VARCHAR(40), rating INT, PRIMARY KEY (id));
CREATE TABLE JPAXMLDeptBean (deptno INT NOT NULL, budget REAL, name VARCHAR(40), MGR_EMPID integer, charityAmount FLOAT(32), charityName VARCHAR(40), REPORTSTO_DEPTNO INT, PRIMARY KEY (deptno));
CREATE TABLE JPAXMLEmpBean (empid integer NOT NULL, bonus FLOAT(32), execLevel CHAR, hireDate DATETIME, hireTime DATETIME, hireTimestamp DATETIME, isManager BIT, name VARCHAR(40), rating INT, salary FLOAT(32), DEPT_DEPTNO INT, HOME_STREET VARCHAR(255), WORK_STREET VARCHAR(255), PRIMARY KEY (empid));
CREATE TABLE JPAXMLLineItemPartTab (lid INT NOT NULL, cost FLOAT(32), quantity INT, PRODUCT_PID INT, ORDER_OID INT, PRIMARY KEY (lid));
CREATE TABLE JPAXMLOrderPartTab (oid INT NOT NULL, amount FLOAT(32), delivered BIT, CUSTOMER_ID INT, PRIMARY KEY (oid));
CREATE TABLE JPAXMLPartTab (partno INT NOT NULL, name VARCHAR(40), XMLPARTTYPE VARCHAR(255), assemblyCost FLOAT(32), massIncrement FLOAT(32), cost FLOAT(32), mass FLOAT(32), PRIMARY KEY (partno));
CREATE TABLE JPAXMLProductPartTab (pid INT NOT NULL, backorder INT, description VARCHAR(40), inventory INT, SUPPLIER_ID INT, PRIMARY KEY (pid));
CREATE TABLE JPAXMLProjectBean (projid integer NOT NULL, budget NUMERIC, cost NUMERIC, description VARCHAR(40), durationDays SMALLINT, name VARCHAR(40), personMonths TINYINT, startTime BIGINT, DEPT_DEPTNO INT, PRIMARY KEY (projid));
CREATE TABLE JPAXMLSupplierPartTab (sid INT NOT NULL, name VARCHAR(40), PRIMARY KEY (sid));
CREATE TABLE JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID INT, SUPPLIES_PARTNO INT);
CREATE TABLE JPAXMLTaskBean (taskid INT NOT NULL, cost NUMERIC, description VARCHAR(40), name VARCHAR(40), PROJECT_PROJID integer, PRIMARY KEY (taskid));
CREATE TABLE JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID INT, EMPS_EMPID integer);
CREATE TABLE JPAXMLTypeTestBean (id INT NOT NULL, ageofUniverse BIGINT, bigbytes IMAGE, busPass IMAGE, deficitUSA NUMERIC, i1 TINYINT, i2 SMALLINT, i4 INT, i8 BIGINT, iboolean BIT, ibytes IMAGE, ic INT, ichars VARCHAR(255), idouble FLOAT(32), ifloat REAL, name VARCHAR(255), o1 TINYINT, o2 SMALLINT, o4 INT, o8 BIGINT, oboolean BIT, obytes IMAGE, oc INT, ochars VARCHAR(255), odouble FLOAT(32), ofloat REAL, payScale VARCHAR(20), sdate DATETIME, status SMALLINT, stime DATETIME, stimestamp DATETIME, ucalendar DATETIME, udate DATETIME, PRIMARY KEY (id));
CREATE TABLE JPAXMLUsageparttab (id INT NOT NULL, quantity INT, CHILD_PARTNO INT, PARENT_PARTNO INT, PRIMARY KEY (id));
CREATE TABLE JPAXMLXYZ (id INT NOT NULL, age INT, firstName VARCHAR(20), lastName VARCHAR(20), PRIMARY KEY (id));

CREATE INDEX I_JPDPTBN_MGR ON JPADeptBean (MGR_EMPID);
CREATE INDEX I_JPDPTBN_REPORTSTO ON JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX I_JPMPBEN_DEPT ON JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX I_JPMPBEN_HOME ON JPAEmpBean (HOME_STREET);
CREATE INDEX I_JPMPBEN_WORK ON JPAEmpBean (WORK_STREET);
CREATE INDEX I_JPLNTTB_ORDER ON JPALineItemPartTab (ORDER_OID);
CREATE INDEX I_JPLNTTB_PRODUCT ON JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX I_JPRDTTB_CUSTOMER ON JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX I_JPPRTTB_DTYPE ON JPAPartTab (PARTTYPE);
CREATE INDEX I_JPPRTTB_SUPPLIER ON JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX I_JPPRTBN_DEPT ON JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX I_JPSPTTB_ELEMENT ON JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX I_JPSPTTB_SUPPLIERS_SID ON JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX I_JPTSKBN_PROJECT ON JPATaskBean (PROJECT_PROJID);
CREATE INDEX I_JPTSPBN_ELEMENT ON JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX I_JPTSPBN_TASKS_TASKID ON JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX I_JPSGTTB_CHILD ON JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX I_JPSGTTB_PARENT ON JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX I_PRSNNCS_PERSON_ID ON Person_residences (PERSON_ID);

CREATE INDEX I_JPXMTBN_MGR ON JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX I_JPXMTBN_REPORTSTO ON JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX I_JPXMPBN_DEPT ON JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX I_JPXMPBN_HOME ON JPAXMLEmpBean (HOME_STREET);
CREATE INDEX I_JPXMPBN_WORK ON JPAXMLEmpBean (WORK_STREET);
CREATE INDEX I_JPXMTTB_ORDER ON JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX I_JPXMTTB_PRODUCT ON JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX I_JPXMTTB_CUSTOMER ON JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX I_JPXMTTB_DTYPE ON JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX I_JPXMTTB_SUPPLIER ON JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX I_JPXMTBN_DEPT ON JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX I_JPXMTTB_ELEMENT ON JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIES_PARTNO);
CREATE INDEX I_JPXMTTB_SUPPLIERS_SID ON JPAXMLSupplierPartTab_JPAXMLPartTab (SUPPLIERS_SID);
CREATE INDEX I_JPXMKBN_PROJECT ON JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX I_JPXMPBN_ELEMENT ON JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX I_JPXMPBN_TASKS_TASKID ON JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX I_JPXMTTB_CHILD ON JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX I_JPXMTTB_PARENT ON JPAXMLUsageparttab (PARENT_PARTNO);
