CREATE TABLE ${schemaname}.JPA2Address (street VARCHAR(30) NOT NULL, city VARCHAR(255) NULL, state VARCHAR(255) NULL, plusFour VARCHAR(4) NULL, zip VARCHAR(5) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPA2Person (id INT NOT NULL, age INT NULL, firstName VARCHAR(20) NULL, lastName VARCHAR(20) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30) NULL, state VARCHAR(20) NULL, zip VARCHAR(10) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPACustomerPartTab (id INT NOT NULL, name VARCHAR(40) NULL, rating INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPADeptBean (deptno INT NOT NULL, budget REAL NULL, name VARCHAR(40) NULL, charityAmount FLOAT(32) NULL, charityName VARCHAR(40) NULL, MGR_EMPID INT NULL, REPORTSTO_DEPTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (deptno));
CREATE TABLE ${schemaname}.JPAEmpBean (empid INT NOT NULL, bonus FLOAT(32) NULL, execLevel INT NULL, hireDate DATETIME NULL, hireTime DATETIME NULL, hireTimestamp DATETIME NULL, isManager TINYINT NULL, name VARCHAR(40) NULL, rating INT NULL, salary FLOAT(32) NULL, DEPT_DEPTNO INT NULL, HOME_STREET VARCHAR(255) NULL, WORK_STREET VARCHAR(255) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (empid));
CREATE TABLE ${schemaname}.JPALineItemPartTab (lid INT NOT NULL, cost FLOAT(32) NULL, quantity INT NULL, ORDER_OID INT NULL, PRODUCT_PID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (lid));
CREATE TABLE ${schemaname}.JPAOrderPartTab (oid INT NOT NULL, amount FLOAT(32) NULL, delivered TINYINT NULL, CUSTOMER_ID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (oid));
CREATE TABLE ${schemaname}.JPAPartTab (partno INT NOT NULL, name VARCHAR(40) NULL, PARTTYPE VARCHAR(31) NULL, assemblyCost FLOAT(32) NULL, massIncrement FLOAT(32) NULL, cost FLOAT(32) NULL, mass FLOAT(32) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (partno));
CREATE TABLE ${schemaname}.JPAProductPartTab (pid INT NOT NULL, backorder INT NULL, description VARCHAR(40) NULL, inventory INT NULL, SUPPLIER_ID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (pid));
CREATE TABLE ${schemaname}.JPAProjectBean (projid INT NOT NULL, budget NUMERIC NULL, cost NUMERIC NULL, description VARCHAR(40) NULL, durationDays SMALLINT NULL, name VARCHAR(40) NULL, personMonths TINYINT NULL, startTime NUMERIC(38) NULL, DEPT_DEPTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (projid));
CREATE TABLE ${schemaname}.JPASupplierPartTab (sid INT NOT NULL, name VARCHAR(40) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (sid));
CREATE TABLE ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID INT NULL, SUPPLIES_PARTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE);
CREATE TABLE ${schemaname}.JPATaskBean (taskid INT NOT NULL, cost NUMERIC NULL, description VARCHAR(40) NULL, name VARCHAR(40) NULL, PROJECT_PROJID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (taskid));
CREATE TABLE ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID INT NULL, EMPS_EMPID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE);
CREATE TABLE ${schemaname}.JPATypeTestBean (id INT NOT NULL, ageofUniverse NUMERIC(38) NULL, bigbytes IMAGE NULL, busPass IMAGE NULL, deficitUSA NUMERIC NULL, i1 TINYINT NULL, i2 SMALLINT NULL, i4 INT NULL, i8 NUMERIC(38) NULL, iboolean TINYINT NULL, ibytes IMAGE NULL, ic INT NULL, ichars VARCHAR(255) NULL, idouble FLOAT(32) NULL, ifloat REAL NULL, name VARCHAR(255) NULL, o1 TINYINT NULL, o2 SMALLINT NULL, o4 INT NULL, o8 NUMERIC(38) NULL, oboolean TINYINT NULL, obytes IMAGE NULL, oc INT NULL, ochars VARCHAR(255) NULL, odouble FLOAT(32) NULL, ofloat REAL NULL, payScale VARCHAR(20) NULL, sdate DATETIME NULL, status SMALLINT NULL, stime DATETIME NULL, stimestamp DATETIME NULL, ucalendar DATETIME NULL, udate DATETIME NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAUsagePartTab (id INT NOT NULL, quantity INT NULL, CHILD_PARTNO INT NULL, PARENT_PARTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXYZ (id INT NOT NULL, age INT NULL, firstName VARCHAR(20) NULL, lastName VARCHAR(20) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.Person_residences (PERSON_ID INT NULL, street VARCHAR(30) NULL, city VARCHAR(255) NULL, state VARCHAR(255) NULL, plusFour VARCHAR(4) NULL, zip VARCHAR(5) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE);

CREATE TABLE ${schemaname}.JPAXMLAddressBean (street VARCHAR(40) NOT NULL, city VARCHAR(30) NULL, state VARCHAR(20) NULL, zip VARCHAR(10) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (street));
CREATE TABLE ${schemaname}.JPAXMLCustomerPartTab (id INT NOT NULL, name VARCHAR(40) NULL, rating INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLDeptBean (deptno INT NOT NULL, budget REAL NULL, name VARCHAR(40) NULL, MGR_EMPID integer NULL, charityAmount FLOAT(32) NULL, charityName VARCHAR(40) NULL, REPORTSTO_DEPTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (deptno));
CREATE TABLE ${schemaname}.JPAXMLEmpBean (empid integer NOT NULL, bonus FLOAT(32) NULL, execLevel INT NULL, hireDate DATETIME NULL, hireTime DATETIME NULL, hireTimestamp DATETIME NULL, isManager TINYINT NULL, name VARCHAR(40) NULL, rating INT NULL, salary FLOAT(32) NULL, DEPT_DEPTNO INT NULL, HOME_STREET VARCHAR(255) NULL, WORK_STREET VARCHAR(255) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (empid));
CREATE TABLE ${schemaname}.JPAXMLLineItemPartTab (lid INT NOT NULL, cost FLOAT(32) NULL, quantity INT NULL, PRODUCT_PID INT NULL, ORDER_OID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (lid));
CREATE TABLE ${schemaname}.JPAXMLOrderPartTab (oid INT NOT NULL, amount FLOAT(32) NULL, delivered TINYINT NULL, CUSTOMER_ID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (oid));
CREATE TABLE ${schemaname}.JPAXMLPartTab (partno INT NOT NULL, name VARCHAR(40) NULL, XMLPARTTYPE VARCHAR(255) NULL, assemblyCost FLOAT(32) NULL, massIncrement FLOAT(32) NULL, cost FLOAT(32) NULL, mass FLOAT(32) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (partno));
CREATE TABLE ${schemaname}.JPAXMLProductPartTab (pid INT NOT NULL, backorder INT NULL, description VARCHAR(40) NULL, inventory INT NULL, SUPPLIER_ID INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (pid));
CREATE TABLE ${schemaname}.JPAXMLProjectBean (projid integer NOT NULL, budget NUMERIC NULL, cost NUMERIC NULL, description VARCHAR(40) NULL, durationDays SMALLINT NULL, name VARCHAR(40) NULL, personMonths TINYINT NULL, startTime NUMERIC(38) NULL, DEPT_DEPTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (projid));
CREATE TABLE ${schemaname}.JPAXMLSupplierPartTab (sid INT NOT NULL, name VARCHAR(40) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (sid));
CREATE TABLE ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIERS_SID INT NULL, SUPPLIES_PARTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE);
CREATE TABLE ${schemaname}.JPAXMLTaskBean (taskid INT NOT NULL, cost NUMERIC NULL, description VARCHAR(40) NULL, name VARCHAR(40) NULL, PROJECT_PROJID integer NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (taskid));
CREATE TABLE ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID INT NULL, EMPS_EMPID integer NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE);
CREATE TABLE ${schemaname}.JPAXMLTypeTestBean (id INT NOT NULL, ageofUniverse NUMERIC(38) NULL, bigbytes IMAGE NULL, busPass IMAGE NULL, deficitUSA NUMERIC NULL, i1 TINYINT NULL, i2 SMALLINT NULL, i4 INT NULL, i8 NUMERIC(38) NULL, iboolean TINYINT NULL, ibytes IMAGE NULL, ic INT NULL, ichars VARCHAR(255) NULL, idouble FLOAT(32) NULL, ifloat REAL NULL, name VARCHAR(255) NULL, o1 TINYINT NULL, o2 SMALLINT NULL, o4 INT NULL, o8 NUMERIC(38) NULL, oboolean TINYINT NULL, obytes IMAGE NULL, oc INT NULL, ochars VARCHAR(255) NULL, odouble FLOAT(32) NULL, ofloat REAL NULL, payScale VARCHAR(20) NULL, sdate DATETIME NULL, status SMALLINT NULL, stime DATETIME NULL, stimestamp DATETIME NULL, ucalendar DATETIME NULL, udate DATETIME NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLUsageparttab (id INT NOT NULL, quantity INT NULL, CHILD_PARTNO INT NULL, PARENT_PARTNO INT NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));
CREATE TABLE ${schemaname}.JPAXMLXYZ (id INT NOT NULL, age INT NULL, firstName VARCHAR(20) NULL, lastName VARCHAR(20) NULL, UNQ_INDEX NUMERIC IDENTITY UNIQUE, PRIMARY KEY (id));

CREATE INDEX ${schemaname}.I_JPDPTBN_MGR ON ${schemaname}.JPADeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPDPTBN_REPORTSTO ON ${schemaname}.JPADeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_DEPT ON ${schemaname}.JPAEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPMPBEN_HOME ON ${schemaname}.JPAEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPMPBEN_WORK ON ${schemaname}.JPAEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPLNTTB_ORDER ON ${schemaname}.JPALineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPLNTTB_PRODUCT ON ${schemaname}.JPALineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPRDTTB_CUSTOMER ON ${schemaname}.JPAOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPPRTTB_DTYPE ON ${schemaname}.JPAPartTab (PARTTYPE);
CREATE INDEX ${schemaname}.I_JPPRTTB_SUPPLIER ON ${schemaname}.JPAProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPPRTBN_DEPT ON ${schemaname}.JPAProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_ELEMENT ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPSPTTB_SUPPLIERS_SID ON ${schemaname}.JPASupplierPartTab_JPAPartTab (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPTSKBN_PROJECT ON ${schemaname}.JPATaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPTSPBN_ELEMENT ON ${schemaname}.JPATaskBean_JPAEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPTSPBN_TASKS_TASKID ON ${schemaname}.JPATaskBean_JPAEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPSGTTB_CHILD ON ${schemaname}.JPAUsagePartTab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPSGTTB_PARENT ON ${schemaname}.JPAUsagePartTab (PARENT_PARTNO);
CREATE INDEX ${schemaname}.I_PRSNNCS_PERSON_ID ON ${schemaname}.Person_residences (PERSON_ID);

CREATE INDEX ${schemaname}.I_JPXMTBN_MGR ON ${schemaname}.JPAXMLDeptBean (MGR_EMPID);
CREATE INDEX ${schemaname}.I_JPXMTBN_REPORTSTO ON ${schemaname}.JPAXMLDeptBean (REPORTSTO_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_DEPT ON ${schemaname}.JPAXMLEmpBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMPBN_HOME ON ${schemaname}.JPAXMLEmpBean (HOME_STREET);
CREATE INDEX ${schemaname}.I_JPXMPBN_WORK ON ${schemaname}.JPAXMLEmpBean (WORK_STREET);
CREATE INDEX ${schemaname}.I_JPXMTTB_ORDER ON ${schemaname}.JPAXMLLineItemPartTab (ORDER_OID);
CREATE INDEX ${schemaname}.I_JPXMTTB_PRODUCT ON ${schemaname}.JPAXMLLineItemPartTab (PRODUCT_PID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CUSTOMER ON ${schemaname}.JPAXMLOrderPartTab (CUSTOMER_ID);
CREATE INDEX ${schemaname}.I_JPXMTTB_DTYPE ON ${schemaname}.JPAXMLPartTab (XMLPARTTYPE);
CREATE INDEX ${schemaname}.I_JPXMTTB_SUPPLIER ON ${schemaname}.JPAXMLProductPartTab (SUPPLIER_ID);
CREATE INDEX ${schemaname}.I_JPXMTBN_DEPT ON ${schemaname}.JPAXMLProjectBean (DEPT_DEPTNO);
CREATE INDEX ${schemaname}.I_JPXMMLP_ELEMENT ON ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIES_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMMLP_SUPPLIERS_SID ON ${schemaname}.JPAXMLSUPPLIERPARTTAB_JPAXMLPA (SUPPLIERS_SID);
CREATE INDEX ${schemaname}.I_JPXMKBN_PROJECT ON ${schemaname}.JPAXMLTaskBean (PROJECT_PROJID);
CREATE INDEX ${schemaname}.I_JPXMPBN_ELEMENT ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (EMPS_EMPID);
CREATE INDEX ${schemaname}.I_JPXMPBN_TASKS_TASKID ON ${schemaname}.JPAXMLTaskBean_JPAXMLEmpBean (TASKS_TASKID);
CREATE INDEX ${schemaname}.I_JPXMTTB_CHILD ON ${schemaname}.JPAXMLUsageparttab (CHILD_PARTNO);
CREATE INDEX ${schemaname}.I_JPXMTTB_PARENT ON ${schemaname}.JPAXMLUsageparttab (PARENT_PARTNO);
