/*******************************************************************************
 * Copyright (c) 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/**
 * A simple CDI injected ViewScope bean with request, app, response, dep bean references.
 *
 */
package com.ibm.ws.jsf23.fat.cdi.injection.beans.injected;

import java.io.Serializable;

import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;

import com.ibm.ws.jsf23.fat.cdi.injection.beans.viewscope.ViewScopeAppBean;
import com.ibm.ws.jsf23.fat.cdi.injection.beans.viewscope.ViewScopeDepBean;
import com.ibm.ws.jsf23.fat.cdi.injection.beans.viewscope.ViewScopeReqBean;
import com.ibm.ws.jsf23.fat.cdi.injection.beans.viewscope.ViewScopeSessBean;

/*
 * View scoped bean to test field and method injection. No constructor injection.
 */
@Named
@ViewScoped
public class ViewScopedManagedBean implements Serializable {

    /**  */
    private static final long serialVersionUID = 1L;

    @Inject
    private ViewScopeAppBean vab;

    private ViewScopeSessBean vsb;

    @Inject
    private ViewScopeReqBean vrb;

    @Inject
    private ViewScopeDepBean vdb;

    @Inject
    public void setMethodBean(ViewScopeSessBean bean) {
        vsb = bean;
    }

    public ViewScopeAppBean getVab() {
        return vab;
    }

    public ViewScopeReqBean getVrb() {
        return vrb;
    }

    public ViewScopeSessBean getVsb() {
        return vsb;
    }

    public ViewScopeDepBean getVdb() {
        return vdb;
    }
}
