#!/bin/bash

# Make sure we are root
if [ `whoami` != 'root' ] ; then
  echo "You must run this script as root."
  exit 1
fi

rm -f /tmp/_rhq-was-tuned

SYSCTL=/etc/sysctl.conf
SHMMAX_VAL=2147483648

if [ ! -f ${SYSCTL} ] ; then
  echo "${SYSCTL} does not exist, creating it"
  echo "# sysctl.conf created so PostgreSQL can support RHQ" >> ${SYSCTL}
  echo "kernel.shmmax=${SHMMAX_VAL}" >> ${SYSCTL}
else

SHMMAX=`cat ${SYSCTL} | grep -v '#' | grep kernel.shmmax | tr '=' ' ' | awk '{print $2}' | tr -d ' '`
if [ "x${SHMMAX}" = "x" ] ; then
  echo "${SYSCTL} does not define kernel.shmmax, adding it"
  echo "" >> ${SYSCTL}
  echo "# Added so PostgreSQL can support RHQ" >> ${SYSCTL}
  echo "kernel.shmmax=${SHMMAX_VAL}" >> ${SYSCTL}

elif [ `echo "${SHMMAX} "'<'" ${SHMMAX_VAL}" | bc` -gt 0 ] ; then
  echo "${SYSCTL} defines kernel.shmmax too low (was ${SHMMAX}, must be at least ${SHMMAX_VAL}), increasing it"
  EXISTING_SHMMAX=`cat ${SYSCTL} | grep -v '#' | grep kernel.shmmax`
  sed "s|^${EXISTING_SHMMAX}|"'\
#'" Changed by JBoss ON installer"'\
#'"${EXISTING_SHMMAX}"'\
'"kernel.shmmax=${SHMMAX_VAL}"'\
'"|g" ${SYSCTL} > /tmp/_sysctl.conf
  mv ${SYSCTL} ${SYSCTL}.bak
  mv /tmp/_sysctl.conf ${SYSCTL}
  echo "${SYSCTL} updated, previous file backed up to ${SYSCTL}.bak"
  
else
  echo "${SYSCTL} defined an adequate kernel.shmmax, not changing anything"
fi

fi

# don't forget to set it now too, at runtime.  sysctl.conf only gets read in at boot time.
echo ${SHMMAX_VAL} > /proc/sys/kernel/shmmax

# done!
touch /tmp/_rhq-was-tuned

echo ""
echo "Tuning completed successfully!"
echo ""
