/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.AbstractTestSetup;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestServices;

public class JBossTestCase
extends AbstractTestCaseWithSetup {
    protected static Exception deploymentException = null;
    protected JBossTestServices delegate;
    protected Logger log;

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        JBossTestServices delegate = new JBossTestServices(clazz);
        return delegate;
    }

    public JBossTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = this.getLog();
        this.delegate = (JBossTestServices)AbstractTestSetup.delegate;
    }

    protected void tearDown() throws Exception {
    }

    public Logger getLog() {
        Logger theLog = this.delegate == null ? Logger.getLogger(((Object)((Object)this)).getClass()) : super.getLog();
        return theLog;
    }

    public void resetDelegate() {
        try {
            this.delegate.reinit();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to init delegate", (Throwable)e);
        }
    }

    public void serverFound() throws Exception {
        if (deploymentException != null) {
            throw deploymentException;
        }
        JBossTestCase.assertTrue((String)"Server was not found", (this.getServer() != null ? 1 : 0) != 0);
    }

    protected InitialContext getInitialContext() throws Exception {
        return this.delegate.getInitialContext();
    }

    protected MBeanServerConnection getServer() throws Exception {
        return this.delegate.getServer();
    }

    protected ObjectName getDeployerName() throws MalformedObjectNameException {
        return this.delegate.getDeployerName();
    }

    protected URL getDeployURL(String filename) throws MalformedURLException {
        return this.delegate.getDeployURL(filename);
    }

    protected String getResourceURL(String resource) throws MalformedURLException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resURL = loader.getResource(resource);
        return resURL != null ? resURL.toString() : null;
    }

    protected Object invoke(ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        return this.delegate.invoke(name, method, args, sig);
    }

    protected void deploy(String name) throws Exception {
        this.delegate.deploy(name);
    }

    protected void redeploy(String name) throws Exception {
        this.delegate.redeploy(name);
    }

    protected void undeploy(String name) throws Exception {
        this.delegate.undeploy(name);
    }

    public static Test getDeploySetup(Class clazz, Test test, String jarNames) throws Exception {
        1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
        return wrapper;
    }

    public static Test getDeploySetup(Test test, String jarName) throws Exception {
        return JBossTestCase.getDeploySetup(JBossTestCase.class, test, jarName);
    }

    public static Test getDeploySetup(Class clazz, String jarName) throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSuite(clazz));
        return JBossTestCase.getDeploySetup(clazz, suite, jarName);
    }

    protected String getJndiURL() {
        return this.delegate.getJndiURL();
    }

    protected String getJndiInitFactory() {
        return this.delegate.getJndiInitFactory();
    }

    protected int getThreadCount() {
        return this.delegate.getThreadCount();
    }

    protected int getIterationCount() {
        return this.delegate.getIterationCount();
    }

    protected int getBeanCount() {
        return this.delegate.getBeanCount();
    }

    public String getServerHost() {
        return this.delegate.getServerHost();
    }

    protected void flushAuthCache() throws Exception {
        this.flushAuthCache("other");
    }

    protected void flushAuthCache(String domain) throws Exception {
        this.delegate.flushAuthCache(domain);
    }

    protected void restartDBPool() throws Exception {
        this.delegate.restartDBPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long interval) throws InterruptedException {
        JBossTestCase jBossTestCase = this;
        synchronized (jBossTestCase) {
            ((Object)((Object)this)).wait(interval);
        }
    }
}

