/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class BufferedInputFilter
implements InputFilter {
    private static final String ENCODING_NAME = "buffered";
    private static final ByteChunk ENCODING = new ByteChunk();
    private ByteChunk buffered = null;
    private ByteChunk tempRead = new ByteChunk(1024);
    private InputBuffer buffer;
    private boolean hasRead = false;

    public void setLimit(int limit) {
        if (this.buffered == null) {
            this.buffered = new ByteChunk(4048);
            this.buffered.setLimit(limit);
        }
    }

    public void setRequest(Request request) {
        try {
            while (this.buffer.doRead(this.tempRead, request) >= 0) {
                this.buffered.append(this.tempRead);
                this.tempRead.recycle();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int doRead(ByteChunk chunk, Request request) throws IOException {
        if (this.hasRead || this.buffered.getLength() <= 0) {
            return -1;
        }
        chunk.setBytes(this.buffered.getBytes(), this.buffered.getStart(), this.buffered.getLength());
        this.hasRead = true;
        return chunk.getLength();
    }

    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    public void recycle() {
        if (this.buffered != null) {
            if (this.buffered.getBuffer() != null && this.buffered.getBuffer().length > 65536) {
                this.buffered = null;
            } else {
                this.buffered.recycle();
            }
        }
        this.tempRead.recycle();
        this.hasRead = false;
        this.buffer = null;
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    public long end() throws IOException {
        return 0L;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }
}

